/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.BoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;
import org.springframework.lang.Nullable;

public interface HashOperations<H, HK, HV> {
    public Long delete(H var1, Object ... var2);

    public Boolean hasKey(H var1, Object var2);

    @Nullable
    public HV get(H var1, Object var2);

    public List<HV> multiGet(H var1, Collection<HK> var2);

    public Long increment(H var1, HK var2, long var3);

    public Double increment(H var1, HK var2, double var3);

    @Nullable
    public HK randomKey(H var1);

    @Nullable
    public Map.Entry<HK, HV> randomEntry(H var1);

    @Nullable
    public List<HK> randomKeys(H var1, long var2);

    @Nullable
    public Map<HK, HV> randomEntries(H var1, long var2);

    public Set<HK> keys(H var1);

    @Nullable
    public Long lengthOfValue(H var1, HK var2);

    public Long size(H var1);

    public void putAll(H var1, Map<? extends HK, ? extends HV> var2);

    public void put(H var1, HK var2, HV var3);

    public Boolean putIfAbsent(H var1, HK var2, HV var3);

    public List<HV> values(H var1);

    public Map<HK, HV> entries(H var1);

    public Cursor<Map.Entry<HK, HV>> scan(H var1, ScanOptions var2);

    @Nullable
    public ExpireChanges<HK> expire(H var1, Duration var2, Collection<HK> var3);

    @Nullable
    public ExpireChanges<HK> expireAt(H var1, Instant var2, Collection<HK> var3);

    @Nullable
    public ExpireChanges<HK> expire(H var1, Expiration var2, ExpirationOptions var3, Collection<HK> var4);

    @Nullable
    public ExpireChanges<HK> persist(H var1, Collection<HK> var2);

    @Nullable
    default public Expirations<HK> getTimeToLive(H key, Collection<HK> hashKeys) {
        return this.getTimeToLive(key, TimeUnit.SECONDS, hashKeys);
    }

    @Nullable
    public Expirations<HK> getTimeToLive(H var1, TimeUnit var2, Collection<HK> var3);

    default public BoundHashFieldExpirationOperations<HK> expiration(H key) {
        return new DefaultBoundHashFieldExpirationOperations(this, key, () -> this.keys(key));
    }

    default public BoundHashFieldExpirationOperations<HK> expiration(H key, HK ... hashFields) {
        return this.expiration(key, (Collection<HK>)Arrays.asList(hashFields));
    }

    default public BoundHashFieldExpirationOperations<HK> expiration(H key, Collection<HK> hashFields) {
        return new DefaultBoundHashFieldExpirationOperations(this, key, () -> hashFields);
    }

    public RedisOperations<H, ?> getOperations();
}

