/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.connection.stream.StreamSerialization;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public interface ByteRecord
extends MapRecord<byte[], byte[], byte[]> {
    @Override
    public ByteRecord withId(RecordId var1);

    public ByteRecord withStreamKey(byte[] var1);

    default public <T> MapRecord<T, T, T> deserialize(@Nullable RedisSerializer<T> serializer) {
        return this.deserialize(serializer, serializer, serializer);
    }

    default public <K, HK, HV> MapRecord<K, HK, HV> deserialize(@Nullable RedisSerializer<? extends K> streamSerializer, @Nullable RedisSerializer<? extends HK> fieldSerializer, @Nullable RedisSerializer<? extends HV> valueSerializer) {
        return this.mapEntries(it -> {
            Map map = Collections.singletonMap(StreamSerialization.deserialize(fieldSerializer, (byte[])it.getKey()), StreamSerialization.deserialize(valueSerializer, (byte[])it.getValue()));
            return map.entrySet().iterator().next();
        }).withStreamKey(StreamSerialization.deserialize(streamSerializer, (byte[])this.getRequiredStream()));
    }

    public static ByteRecord of(MapRecord<byte[], byte[], byte[]> source) {
        return StreamRecords.newRecord().in((byte[])source.getRequiredStream()).withId(source.getId()).ofBytes((Map)source.getValue());
    }
}

