/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.BaseRedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.ClusterConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClusterGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClusterZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.connection.lettuce.RedisClientProvider;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LettuceClusterConnection
extends LettuceConnection
implements RedisClusterConnection,
DefaultedRedisClusterConnection {
    static final ExceptionTranslationStrategy exceptionConverter = new PassThroughExceptionTranslationStrategy(LettuceExceptionConverter.INSTANCE);
    private boolean disposeClusterCommandExecutorOnClose;
    private ClusterCommandExecutor clusterCommandExecutor;
    private ClusterTopologyProvider topologyProvider;
    private final Log log = LogFactory.getLog(this.getClass());
    private final LettuceClusterGeoCommands geoCommands = new LettuceClusterGeoCommands(this);
    private final LettuceClusterHashCommands hashCommands = new LettuceClusterHashCommands(this);
    private final LettuceClusterHyperLogLogCommands hllCommands = new LettuceClusterHyperLogLogCommands(this);
    private final LettuceClusterKeyCommands keyCommands = new LettuceClusterKeyCommands(this);
    private final LettuceClusterListCommands listCommands = new LettuceClusterListCommands(this);
    private final LettuceClusterStringCommands stringCommands = new LettuceClusterStringCommands(this);
    private final LettuceClusterSetCommands setCommands = new LettuceClusterSetCommands(this);
    private final LettuceClusterZSetCommands zSetCommands = new LettuceClusterZSetCommands(this);
    private final LettuceClusterServerCommands serverCommands = new LettuceClusterServerCommands(this);

    public LettuceClusterConnection(RedisClusterClient clusterClient) {
        this(new ClusterConnectionProvider(clusterClient, CODEC));
    }

    public LettuceClusterConnection(RedisClusterClient clusterClient, ClusterCommandExecutor executor) {
        this(clusterClient, executor, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceClusterConnection(RedisClusterClient clusterClient, ClusterCommandExecutor executor, Duration timeout) {
        this(new ClusterConnectionProvider(clusterClient, CODEC), executor, timeout);
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider) {
        super((StatefulRedisConnection<byte[], byte[]>)null, connectionProvider, RedisURI.DEFAULT_TIMEOUT_DURATION.toMillis(), 0);
        Assert.isTrue((boolean)(connectionProvider instanceof ClusterConnectionProvider), (String)"LettuceConnectionProvider must be a ClusterConnectionProvider");
        this.topologyProvider = new LettuceClusterTopologyProvider(this.getClient());
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new LettuceClusterNodeResourceProvider(this.getConnectionProvider()), exceptionConverter);
        this.disposeClusterCommandExecutorOnClose = true;
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider, ClusterCommandExecutor executor) {
        this(connectionProvider, executor, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider, ClusterCommandExecutor executor, Duration timeout) {
        super((StatefulRedisConnection<byte[], byte[]>)null, connectionProvider, timeout.toMillis(), 0);
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null");
        Assert.isTrue((boolean)(connectionProvider instanceof ClusterConnectionProvider), (String)"LettuceConnectionProvider must be a ClusterConnectionProvider");
        this.topologyProvider = new LettuceClusterTopologyProvider(this.getClient());
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    protected LettuceClusterConnection(@Nullable StatefulRedisClusterConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, ClusterTopologyProvider clusterTopologyProvider, ClusterCommandExecutor executor, Duration timeout) {
        super((StatefulConnection<byte[], byte[]>)sharedConnection, connectionProvider, timeout.toMillis(), 0);
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null");
        this.topologyProvider = clusterTopologyProvider;
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    private RedisClusterClient getClient() {
        LettuceConnectionProvider connectionProvider = this.getConnectionProvider();
        if (connectionProvider instanceof RedisClientProvider) {
            RedisClientProvider redisClientProvider = (RedisClientProvider)((Object)connectionProvider);
            return (RedisClusterClient)redisClientProvider.getRedisClient();
        }
        String message = String.format("Connection provider %s does not implement RedisClientProvider", connectionProvider.getClass().getName());
        throw new IllegalStateException(message);
    }

    @Override
    public RedisClusterCommands clusterCommands() {
        return this;
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return this.geoCommands;
    }

    @Override
    public RedisHashCommands hashCommands() {
        return this.hashCommands;
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.hllCommands;
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this.keyCommands;
    }

    @Override
    public RedisListCommands listCommands() {
        return this.listCommands;
    }

    @Override
    public RedisSetCommands setCommands() {
        return this.setCommands;
    }

    @Override
    public RedisClusterServerCommands serverCommands() {
        return this.serverCommands;
    }

    @Override
    public RedisStringCommands stringCommands() {
        return this.stringCommands;
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return this.zSetCommands;
    }

    @Override
    public String ping() {
        List ping = this.clusterCommandExecutor.executeCommandOnAllNodes(this.pingCommand()).resultsAsList();
        for (String result : ping) {
            if (ObjectUtils.nullSafeEquals((Object)"PONG", (Object)result)) continue;
            return "";
        }
        return "PONG";
    }

    @Override
    public String ping(RedisClusterNode node) {
        return (String)this.clusterCommandExecutor.executeCommandOnSingleNode(this.pingCommand(), node).getValue();
    }

    private LettuceClusterCommandCallback<String> pingCommand() {
        return BaseRedisCommands::ping;
    }

    public List<RedisClusterNode> clusterGetNodes() {
        return new ArrayList<RedisClusterNode>(this.topologyProvider.getTopology().getNodes());
    }

    public Set<RedisClusterNode> clusterGetReplicas(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master must not be null");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        LettuceClusterCommandCallback command = client -> LettuceConverters.toSetOfRedisClusterNodes(client.clusterSlaves(nodeToUse.getId()));
        return (Set)this.clusterCommandExecutor.executeCommandOnSingleNode(command, master).getValue();
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterReplicaMap() {
        Set<RedisClusterNode> activeMasterNodes = this.topologyProvider.getTopology().getActiveMasterNodes();
        LettuceClusterCommandCallback command = client -> Converters.toSetOfRedisClusterNodes(client.clusterSlaves(client.clusterMyId()));
        List nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(command, activeMasterNodes).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), (Collection)nodeResult.getValue());
        }
        return result;
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        return SlotHash.getSlot((byte[])key);
    }

    @Override
    @Nullable
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        Set<RedisClusterNode> nodes = this.topologyProvider.getTopology().getSlotServingNodes(slot);
        return !nodes.isEmpty() ? nodes.iterator().next() : null;
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.clusterGetNodeForSlot(this.clusterGetSlotForKey(key));
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        LettuceClusterCommandCallback command = client -> new ClusterInfo(LettuceConverters.toProperties(client.clusterInfo()));
        return (ClusterInfo)this.clusterCommandExecutor.executeCommandOnArbitraryNode(command).getValue();
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        LettuceClusterCommandCallback command = client -> client.clusterAddSlots(slots);
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        try {
            return this.getConnection().clusterCountKeysInSlot(slot);
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        LettuceClusterCommandCallback command = client -> client.clusterDelSlots(slots);
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>((Collection<RedisClusterNode>)this.clusterGetNodes());
        RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        LettuceClusterCommandCallback command = client -> client.clusterForget(nodeToRemove.getId());
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(command, nodes);
    }

    @Override
    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0");
        LettuceClusterCommandCallback command = client -> client.clusterMeet(node.getHost(), node.getPort().intValue());
        this.clusterCommandExecutor.executeCommandOnAllNodes(command);
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        String nodeId = nodeToUse.getId();
        LettuceClusterCommandCallback command = client -> switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case RedisClusterCommands.AddSlots.MIGRATING -> client.clusterSetSlotMigrating(slot, nodeId);
            case RedisClusterCommands.AddSlots.IMPORTING -> client.clusterSetSlotImporting(slot, nodeId);
            case RedisClusterCommands.AddSlots.NODE -> client.clusterSetSlotNode(slot, nodeId);
            case RedisClusterCommands.AddSlots.STABLE -> client.clusterSetSlotStable(slot);
        };
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        try {
            return this.getConnection().clusterGetKeysInSlot(slot, count.intValue());
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode replica) {
        RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        LettuceClusterCommandCallback command = client -> client.clusterReplicate(masterNode.getId());
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, replica);
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return new LettuceClusterKeyCommands(this).keys(node, pattern);
    }

    @Override
    public Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        return new LettuceClusterKeyCommands(this).scan(node, options);
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return new LettuceClusterKeyCommands(this).randomKey(node);
    }

    @Override
    public void select(int dbIndex) {
        if (dbIndex != 0) {
            throw new InvalidDataAccessApiUsageException("Cannot SELECT non zero index in cluster mode");
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode");
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MULTI is currently not supported in cluster mode");
    }

    public ClusterCommandExecutor getClusterCommandExecutor() {
        return this.clusterCommandExecutor;
    }

    @Override
    public void close() throws DataAccessException {
        if (!this.isClosed() && this.disposeClusterCommandExecutorOnClose) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
        super.close();
    }

    static class LettuceClusterNodeResourceProvider
    implements ClusterNodeResourceProvider,
    DisposableBean {
        private final Lock lock = new ReentrantLock();
        private final LettuceConnectionProvider connectionProvider;
        @Nullable
        private volatile StatefulRedisClusterConnection<byte[], byte[]> connection;

        LettuceClusterNodeResourceProvider(LettuceConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public io.lettuce.core.cluster.api.sync.RedisClusterCommands<byte[], byte[]> getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Node must not be null");
            if (this.connection == null) {
                this.lock.lock();
                try {
                    if (this.connection == null) {
                        this.connection = this.connectionProvider.getConnection(StatefulRedisClusterConnection.class);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return this.connection.getConnection(node.getHost(), node.getPort().intValue()).sync();
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object resource) {
        }

        public void destroy() throws Exception {
            if (this.connection != null) {
                this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
            }
        }
    }

    protected static interface LettuceClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<io.lettuce.core.cluster.api.sync.RedisClusterCommands<byte[], byte[]>, T> {
    }

    protected static interface LettuceMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<io.lettuce.core.cluster.api.sync.RedisClusterCommands<byte[], byte[]>, T> {
    }
}

