/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;

class DefaultRedisElementReader<T>
implements RedisElementReader<T> {
    @Nullable
    private final RedisSerializer<T> serializer;

    DefaultRedisElementReader(RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public T read(ByteBuffer buffer) {
        if (this.serializer == null) {
            return (T)buffer;
        }
        return this.serializer.deserialize(ByteUtils.extractBytes(buffer));
    }
}

