/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.domain.geo;

import org.springframework.data.geo.Point;
import org.springframework.util.ObjectUtils;

public class GeoLocation<T> {
    private final T name;
    private final Point point;

    public GeoLocation(T name, Point point) {
        this.name = name;
        this.point = point;
    }

    public T getName() {
        return this.name;
    }

    public Point getPoint() {
        return this.point;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation that = (GeoLocation)o;
        if (!ObjectUtils.nullSafeEquals(this.name, that.name)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.point, (Object)that.point);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.point);
        return result;
    }

    public String toString() {
        return "GeoLocation(name=" + this.getName() + ", point=" + this.getPoint() + ")";
    }
}

