/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface BoundZSetOperations<K, V>
extends BoundKeyOperations<K> {
    @Nullable
    public Boolean add(V var1, double var2);

    @Nullable
    public Boolean addIfAbsent(V var1, double var2);

    @Nullable
    public Long add(Set<ZSetOperations.TypedTuple<V>> var1);

    @Nullable
    public Long addIfAbsent(Set<ZSetOperations.TypedTuple<V>> var1);

    @Nullable
    public Long remove(Object ... var1);

    @Nullable
    public Double incrementScore(V var1, double var2);

    public V randomMember();

    @Nullable
    public Set<V> distinctRandomMembers(long var1);

    @Nullable
    public List<V> randomMembers(long var1);

    public ZSetOperations.TypedTuple<V> randomMemberWithScore();

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(long var1);

    @Nullable
    public List<ZSetOperations.TypedTuple<V>> randomMembersWithScore(long var1);

    @Nullable
    public Long rank(Object var1);

    @Nullable
    public Long reverseRank(Object var1);

    @Nullable
    public Set<V> range(long var1, long var3);

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(long var1, long var3);

    @Nullable
    public Set<V> rangeByScore(double var1, double var3);

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(double var1, double var3);

    @Nullable
    public Set<V> reverseRange(long var1, long var3);

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(long var1, long var3);

    @Nullable
    public Set<V> reverseRangeByScore(double var1, double var3);

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(double var1, double var3);

    @Nullable
    public Long count(double var1, double var3);

    @Nullable
    public Long lexCount(RedisZSetCommands.Range var1);

    @Nullable
    public ZSetOperations.TypedTuple<V> popMin();

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> popMin(long var1);

    @Nullable
    public ZSetOperations.TypedTuple<V> popMin(long var1, TimeUnit var3);

    @Nullable
    default public ZSetOperations.TypedTuple<V> popMin(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMin(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public ZSetOperations.TypedTuple<V> popMax();

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> popMax(long var1);

    @Nullable
    public ZSetOperations.TypedTuple<V> popMax(long var1, TimeUnit var3);

    @Nullable
    default public ZSetOperations.TypedTuple<V> popMax(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMax(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public Long size();

    @Nullable
    public Long zCard();

    @Nullable
    public Double score(Object var1);

    @Nullable
    public List<Double> score(Object ... var1);

    @Nullable
    public Long removeRange(long var1, long var3);

    @Nullable
    public Long removeRangeByLex(RedisZSetCommands.Range var1);

    @Nullable
    public Long removeRangeByScore(double var1, double var3);

    @Nullable
    public Long unionAndStore(Collection<K> var1, K var2, RedisZSetCommands.Aggregate var3, RedisZSetCommands.Weights var4);

    @Nullable
    default public Set<V> difference(K otherKey) {
        return this.difference((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> difference(Collection<K> var1);

    @Nullable
    default public Set<ZSetOperations.TypedTuple<V>> differenceWithScores(K otherKey) {
        return this.differenceWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> differenceWithScores(Collection<K> var1);

    @Nullable
    default public Long differenceAndStore(K otherKey, K destKey) {
        return this.differenceAndStore((Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Nullable
    public Long differenceAndStore(Collection<K> var1, K var2);

    @Nullable
    default public Set<V> intersect(K otherKey) {
        return this.intersect((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> intersect(Collection<K> var1);

    @Nullable
    default public Set<ZSetOperations.TypedTuple<V>> intersectWithScores(K otherKey) {
        return this.intersectWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> intersectWithScores(Collection<K> var1);

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> intersectWithScores(Collection<K> var1, RedisZSetCommands.Aggregate var2, RedisZSetCommands.Weights var3);

    @Nullable
    public Long intersectAndStore(K var1, K var2);

    @Nullable
    public Long intersectAndStore(Collection<K> var1, K var2);

    @Nullable
    public Long intersectAndStore(Collection<K> var1, K var2, RedisZSetCommands.Aggregate var3);

    @Nullable
    public Long intersectAndStore(Collection<K> var1, K var2, RedisZSetCommands.Aggregate var3, RedisZSetCommands.Weights var4);

    @Nullable
    default public Set<V> union(K otherKey) {
        return this.union((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<V> union(Collection<K> var1);

    @Nullable
    default public Set<ZSetOperations.TypedTuple<V>> unionWithScores(K otherKey) {
        return this.unionWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> unionWithScores(Collection<K> var1);

    @Nullable
    default public Set<ZSetOperations.TypedTuple<V>> unionWithScores(Collection<K> otherKeys, RedisZSetCommands.Aggregate aggregate) {
        return this.unionWithScores(otherKeys, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<V>> unionWithScores(Collection<K> var1, RedisZSetCommands.Aggregate var2, RedisZSetCommands.Weights var3);

    @Nullable
    public Long unionAndStore(K var1, K var2);

    @Nullable
    public Long unionAndStore(Collection<K> var1, K var2);

    @Nullable
    public Long unionAndStore(Collection<K> var1, K var2, RedisZSetCommands.Aggregate var3);

    public Cursor<ZSetOperations.TypedTuple<V>> scan(ScanOptions var1);

    @Nullable
    default public Set<V> rangeByLex(RedisZSetCommands.Range range) {
        return this.rangeByLex(range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public Set<V> rangeByLex(RedisZSetCommands.Range var1, RedisZSetCommands.Limit var2);

    @Nullable
    default public Set<V> reverseRangeByLex(RedisZSetCommands.Range range) {
        return this.reverseRangeByLex(range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public Set<V> reverseRangeByLex(RedisZSetCommands.Range var1, RedisZSetCommands.Limit var2);

    public RedisOperations<K, V> getOperations();
}

