/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.MapConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.data.redis.connection.jedis.JedisVersionUtil;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.util.SafeEncoder;

public abstract class JedisConverters
extends Converters {
    private static final Converter<String, byte[]> STRING_TO_BYTES;
    private static final ListConverter<String, byte[]> STRING_LIST_TO_BYTE_LIST;
    private static final SetConverter<String, byte[]> STRING_SET_TO_BYTE_SET;
    private static final MapConverter<String, byte[]> STRING_MAP_TO_BYTE_MAP;
    private static final SetConverter<Tuple, RedisZSetCommands.Tuple> TUPLE_SET_TO_TUPLE_SET;
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER;
    private static final Converter<String[], List<RedisClientInfo>> STRING_TO_CLIENT_INFO_CONVERTER;
    private static final Converter<Tuple, RedisZSetCommands.Tuple> TUPLE_CONVERTER;
    private static final ListConverter<Tuple, RedisZSetCommands.Tuple> TUPLE_LIST_TO_TUPLE_LIST_CONVERTER;
    private static final Converter<Object, RedisClusterNode> OBJECT_TO_CLUSTER_NODE_CONVERTER;
    private static final Converter<Expiration, byte[]> EXPIRATION_TO_COMMAND_OPTION_CONVERTER;
    private static final Converter<RedisStringCommands.SetOption, byte[]> SET_OPTION_TO_COMMAND_OPTION_CONVERTER;
    private static final Converter<List<String>, Long> STRING_LIST_TO_TIME_CONVERTER;
    private static final Converter<GeoCoordinate, Point> GEO_COORDINATE_TO_POINT_CONVERTER;
    private static final ListConverter<GeoCoordinate, Point> LIST_GEO_COORDINATE_TO_POINT_CONVERTER;
    private static final Converter<byte[], String> BYTES_TO_STRING_CONVERTER;
    private static final ListConverter<byte[], String> BYTES_LIST_TO_STRING_LIST_CONVERTER;
    private static final ListConverter<byte[], Long> BYTES_LIST_TO_LONG_LIST_CONVERTER;
    private static final Converter<BitFieldSubCommands, List<byte[]>> BITFIELD_COMMAND_ARGUMENT_CONVERTER;
    public static final byte[] PLUS_BYTES;
    public static final byte[] MINUS_BYTES;
    public static final byte[] POSITIVE_INFINITY_BYTES;
    public static final byte[] NEGATIVE_INFINITY_BYTES;
    private static final byte[] EX;
    private static final byte[] PX;
    private static final byte[] NX;
    private static final byte[] XX;

    public static Converter<String, byte[]> stringToBytes() {
        return STRING_TO_BYTES;
    }

    public static ListConverter<Tuple, RedisZSetCommands.Tuple> tuplesToTuples() {
        return TUPLE_LIST_TO_TUPLE_LIST_CONVERTER;
    }

    public static ListConverter<String, byte[]> stringListToByteList() {
        return STRING_LIST_TO_BYTE_LIST;
    }

    public static SetConverter<String, byte[]> stringSetToByteSet() {
        return STRING_SET_TO_BYTE_SET;
    }

    public static MapConverter<String, byte[]> stringMapToByteMap() {
        return STRING_MAP_TO_BYTE_MAP;
    }

    public static SetConverter<Tuple, RedisZSetCommands.Tuple> tupleSetToTupleSet() {
        return TUPLE_SET_TO_TUPLE_SET;
    }

    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static String[] toStrings(byte[][] source) {
        String[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = SafeEncoder.encode((byte[])source[i]);
        }
        return result;
    }

    public static Set<RedisZSetCommands.Tuple> toTupleSet(Set<Tuple> source) {
        return TUPLE_SET_TO_TUPLE_SET.convert(source);
    }

    public static Map<byte[], Double> toTupleMap(Set<RedisZSetCommands.Tuple> tuples) {
        Assert.notNull(tuples, (String)"Tuple set must not be null!");
        LinkedHashMap<byte[], Double> args = new LinkedHashMap<byte[], Double>(tuples.size(), 1.0f);
        HashSet<Double> scores = new HashSet<Double>(tuples.size(), 1.0f);
        boolean isAtLeastJedis24 = JedisVersionUtil.atLeastJedis24();
        for (RedisZSetCommands.Tuple tuple : tuples) {
            if (!isAtLeastJedis24) {
                if (scores.contains(tuple.getScore())) {
                    throw new UnsupportedOperationException("Bulk add of multiple elements with the same score is not supported. Add the elements individually.");
                }
                scores.add(tuple.getScore());
            }
            args.put(tuple.getValue(), tuple.getScore());
        }
        return args;
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Long source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Double source) {
        return JedisConverters.toBytes(String.valueOf(source));
    }

    public static byte[] toBytes(String source) {
        return (byte[])STRING_TO_BYTES.convert((Object)source);
    }

    @Nullable
    public static String toString(@Nullable byte[] source) {
        return source == null ? null : SafeEncoder.encode((byte[])source);
    }

    public static ValueEncoding toEncoding(@Nullable byte[] source) {
        return ValueEncoding.of(JedisConverters.toString(source));
    }

    public static RedisClusterNode toNode(Object source) {
        return (RedisClusterNode)OBJECT_TO_CLUSTER_NODE_CONVERTER.convert(source);
    }

    public static List<RedisClientInfo> toListOfRedisClientInformation(String source) {
        if (!StringUtils.hasText((String)source)) {
            return Collections.emptyList();
        }
        return (List)STRING_TO_CLIENT_INFO_CONVERTER.convert((Object)source.split("\\r?\\n"));
    }

    public static List<RedisServer> toListOfRedisServer(List<Map<String, String>> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<RedisServer> sentinels = new ArrayList<RedisServer>();
        for (Map<String, String> info : source) {
            sentinels.add(RedisServer.newServerFrom(Converters.toProperties(info)));
        }
        return sentinels;
    }

    public static DataAccessException toDataAccessException(Exception ex) {
        return (DataAccessException)EXCEPTION_CONVERTER.convert((Object)ex);
    }

    public static BinaryClient.LIST_POSITION toListPosition(RedisListCommands.Position source) {
        Assert.notNull((Object)((Object)source), (String)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)source) ? BinaryClient.LIST_POSITION.AFTER : BinaryClient.LIST_POSITION.BEFORE;
    }

    public static byte[][] toByteArrays(Map<byte[], byte[]> source) {
        byte[][] result = new byte[source.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : source.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    @Nullable
    public static SortingParams toSortingParams(@Nullable SortParameters params) {
        SortingParams jedisParams = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            jedisParams = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jedisParams.by(params.getByPattern());
            }
            if ((getPattern = params.getGetPattern()) != null) {
                jedisParams.get(getPattern);
            }
            if ((limit = params.getLimit()) != null) {
                jedisParams.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jedisParams.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jedisParams.alpha();
            }
        }
        return jedisParams;
    }

    public static BitOP toBitOp(RedisStringCommands.BitOperation bitOp) {
        switch (bitOp) {
            case AND: {
                return BitOP.AND;
            }
            case OR: {
                return BitOP.OR;
            }
            case NOT: {
                return BitOP.NOT;
            }
            case XOR: {
                return BitOP.XOR;
            }
        }
        throw new IllegalArgumentException();
    }

    public static byte[] boundaryToBytesForZRange(@Nullable RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, new byte[0], JedisConverters.toBytes("("));
    }

    public static byte[] boundaryToBytesForZRangeByLex(@Nullable RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, JedisConverters.toBytes("["), JedisConverters.toBytes("("));
    }

    public static byte[] toSetCommandExPxArgument(Expiration expiration) {
        return (byte[])EXPIRATION_TO_COMMAND_OPTION_CONVERTER.convert((Object)expiration);
    }

    public static byte[] toSetCommandNxXxArgument(RedisStringCommands.SetOption option) {
        return (byte[])SET_OPTION_TO_COMMAND_OPTION_CONVERTER.convert((Object)option);
    }

    private static byte[] boundaryToBytes(RedisZSetCommands.Range.Boundary boundary, byte[] inclPrefix, byte[] exclPrefix) {
        byte[] prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        byte[] value = null;
        if (boundary.getValue() instanceof byte[]) {
            value = (byte[])boundary.getValue();
        } else if (boundary.getValue() instanceof Double) {
            value = JedisConverters.toBytes((Double)boundary.getValue());
        } else if (boundary.getValue() instanceof Long) {
            value = JedisConverters.toBytes((Long)boundary.getValue());
        } else if (boundary.getValue() instanceof Integer) {
            value = JedisConverters.toBytes((Integer)boundary.getValue());
        } else if (boundary.getValue() instanceof String) {
            value = JedisConverters.toBytes((String)boundary.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot convert %s to binary format", boundary.getValue()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + value.length);
        buffer.put(prefix);
        buffer.put(value);
        return buffer.array();
    }

    public static ScanParams toScanParams(ScanOptions options) {
        ScanParams sp = new ScanParams();
        if (!options.equals(ScanOptions.NONE)) {
            if (options.getCount() != null) {
                sp.count(Integer.valueOf(options.getCount().intValue()));
            }
            if (StringUtils.hasText((String)options.getPattern())) {
                sp.match(options.getPattern());
            }
        }
        return sp;
    }

    static Converter<List<String>, Long> toTimeConverter() {
        return STRING_LIST_TO_TIME_CONVERTER;
    }

    public static List<String> toStrings(List<byte[]> source) {
        return BYTES_LIST_TO_STRING_LIST_CONVERTER.convert(source);
    }

    public static ListConverter<byte[], String> bytesListToStringListConverter() {
        return BYTES_LIST_TO_STRING_LIST_CONVERTER;
    }

    public static ListConverter<byte[], Long> getBytesListToLongListConverter() {
        return BYTES_LIST_TO_LONG_LIST_CONVERTER;
    }

    public static ListConverter<GeoCoordinate, Point> geoCoordinateToPointConverter() {
        return LIST_GEO_COORDINATE_TO_POINT_CONVERTER;
    }

    public static Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoRadiusResponseToGeoResultsConverter(Metric metric) {
        return GeoResultsConverterFactory.INSTANCE.forMetric(metric);
    }

    public static GeoUnit toGeoUnit(Metric metric) {
        RedisGeoCommands.DistanceUnit metricToUse = metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric;
        return (GeoUnit)ObjectUtils.caseInsensitiveValueOf((Enum[])GeoUnit.values(), (String)metricToUse.getAbbreviation());
    }

    public static GeoCoordinate toGeoCoordinate(Point source) {
        return source == null ? null : new GeoCoordinate(source.getX(), source.getY());
    }

    public static GeoRadiusParam toGeoRadiusParam(RedisGeoCommands.GeoRadiusCommandArgs source) {
        GeoRadiusParam param = GeoRadiusParam.geoRadiusParam();
        if (source == null) {
            return param;
        }
        if (source.hasFlags()) {
            for (RedisGeoCommands.GeoRadiusCommandArgs.Flag flag : source.getFlags()) {
                switch (flag) {
                    case WITHCOORD: {
                        param.withCoord();
                        break;
                    }
                    case WITHDIST: {
                        param.withDist();
                    }
                }
            }
        }
        if (source.hasSortDirection()) {
            switch (source.getSortDirection()) {
                case ASC: {
                    param.sortAscending();
                    break;
                }
                case DESC: {
                    param.sortDescending();
                }
            }
        }
        if (source.hasLimit()) {
            param.count(source.getLimit().intValue());
        }
        return param;
    }

    public static byte[][] toBitfieldCommandArguments(BitFieldSubCommands bitfieldOperation) {
        List tmp = (List)BITFIELD_COMMAND_ARGUMENT_CONVERTER.convert((Object)bitfieldOperation);
        return (byte[][])tmp.toArray((T[])new byte[tmp.size()][]);
    }

    static {
        EXCEPTION_CONVERTER = new JedisExceptionConverter();
        STRING_TO_CLIENT_INFO_CONVERTER = new StringToRedisClientInfoConverter();
        BYTES_TO_STRING_CONVERTER = source -> source == null ? null : SafeEncoder.encode((byte[])source);
        BYTES_LIST_TO_STRING_LIST_CONVERTER = new ListConverter<byte[], String>(BYTES_TO_STRING_CONVERTER);
        STRING_TO_BYTES = source -> source == null ? null : SafeEncoder.encode((String)source);
        STRING_LIST_TO_BYTE_LIST = new ListConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_SET_TO_BYTE_SET = new SetConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_MAP_TO_BYTE_MAP = new MapConverter<String, byte[]>(STRING_TO_BYTES);
        TUPLE_CONVERTER = source -> source != null ? new DefaultTuple(source.getBinaryElement(), source.getScore()) : null;
        TUPLE_SET_TO_TUPLE_SET = new SetConverter<Tuple, RedisZSetCommands.Tuple>(TUPLE_CONVERTER);
        TUPLE_LIST_TO_TUPLE_LIST_CONVERTER = new ListConverter<Tuple, RedisZSetCommands.Tuple>(TUPLE_CONVERTER);
        PLUS_BYTES = JedisConverters.toBytes("+");
        MINUS_BYTES = JedisConverters.toBytes("-");
        POSITIVE_INFINITY_BYTES = JedisConverters.toBytes("+inf");
        NEGATIVE_INFINITY_BYTES = JedisConverters.toBytes("-inf");
        OBJECT_TO_CLUSTER_NODE_CONVERTER = infos -> {
            List values = (List)infos;
            RedisClusterNode.SlotRange range = new RedisClusterNode.SlotRange(((Number)values.get(0)).intValue(), ((Number)values.get(1)).intValue());
            List nodeInfo = (List)values.get(2);
            return new RedisClusterNode(JedisConverters.toString((byte[])nodeInfo.get(0)), ((Number)nodeInfo.get(1)).intValue(), range);
        };
        EX = JedisConverters.toBytes("EX");
        PX = JedisConverters.toBytes("PX");
        EXPIRATION_TO_COMMAND_OPTION_CONVERTER = new Converter<Expiration, byte[]>(){

            public byte[] convert(Expiration source) {
                if (source == null || source.isPersistent()) {
                    return new byte[0];
                }
                if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)source.getTimeUnit()))) {
                    return PX;
                }
                return EX;
            }
        };
        NX = JedisConverters.toBytes("NX");
        XX = JedisConverters.toBytes("XX");
        SET_OPTION_TO_COMMAND_OPTION_CONVERTER = new Converter<RedisStringCommands.SetOption, byte[]>(){

            public byte[] convert(RedisStringCommands.SetOption source) {
                switch (source) {
                    case UPSERT: {
                        return new byte[0];
                    }
                    case SET_IF_ABSENT: {
                        return NX;
                    }
                    case SET_IF_PRESENT: {
                        return XX;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid argument %s for SetOption.", new Object[]{source}));
            }
        };
        STRING_LIST_TO_TIME_CONVERTER = source -> {
            Assert.notEmpty((Collection)source, (String)"Received invalid result from server. Expected 2 items in collection.");
            Assert.isTrue((source.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + source.size()));
            return JedisConverters.toTimeMillis((String)source.get(0), (String)source.get(1));
        };
        GEO_COORDINATE_TO_POINT_CONVERTER = geoCoordinate -> geoCoordinate != null ? new Point(geoCoordinate.getLongitude(), geoCoordinate.getLatitude()) : null;
        LIST_GEO_COORDINATE_TO_POINT_CONVERTER = new ListConverter<GeoCoordinate, Point>(GEO_COORDINATE_TO_POINT_CONVERTER);
        BYTES_LIST_TO_LONG_LIST_CONVERTER = new ListConverter<byte[], Long>(new Converter<byte[], Long>(){

            public Long convert(byte[] source) {
                return Long.valueOf(JedisConverters.toString(source));
            }
        });
        BITFIELD_COMMAND_ARGUMENT_CONVERTER = new Converter<BitFieldSubCommands, List<byte[]>>(){

            public List<byte[]> convert(BitFieldSubCommands source) {
                if (source == null) {
                    return Collections.emptyList();
                }
                ArrayList<byte[]> args = new ArrayList<byte[]>(source.getSubCommands().size() * 4);
                for (BitFieldSubCommands.BitFieldSubCommand command : source.getSubCommands()) {
                    BitFieldSubCommands.BitFieldIncrBy.Overflow overflow;
                    if (command instanceof BitFieldSubCommands.BitFieldIncrBy && (overflow = ((BitFieldSubCommands.BitFieldIncrBy)command).getOverflow()) != null) {
                        args.add(JedisConverters.toBytes("OVERFLOW"));
                        args.add(JedisConverters.toBytes(overflow.name()));
                    }
                    args.add(JedisConverters.toBytes(command.getCommand()));
                    args.add(JedisConverters.toBytes(command.getType().asString()));
                    args.add(JedisConverters.toBytes(command.getOffset().asString()));
                    if (command instanceof BitFieldSubCommands.BitFieldSet) {
                        args.add(JedisConverters.toBytes(((BitFieldSubCommands.BitFieldSet)command).getValue()));
                        continue;
                    }
                    if (!(command instanceof BitFieldSubCommands.BitFieldIncrBy)) continue;
                    args.add(JedisConverters.toBytes(((BitFieldSubCommands.BitFieldIncrBy)command).getValue()));
                }
                return args;
            }
        };
    }

    static enum GeoResultConverterFactory {
        INSTANCE;


        Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultConverter(metric);
        }

        private static class GeoResultConverter
        implements Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> {
            private Metric metric;

            public GeoResultConverter(Metric metric) {
                this.metric = metric;
            }

            public GeoResult<RedisGeoCommands.GeoLocation<byte[]>> convert(GeoRadiusResponse source) {
                Point point = (Point)GEO_COORDINATE_TO_POINT_CONVERTER.convert((Object)source.getCoordinate());
                return new GeoResult(new RedisGeoCommands.GeoLocation<byte[]>(source.getMember(), point), new Distance(source.getDistance(), this.metric));
            }
        }
    }

    static enum GeoResultsConverterFactory {
        INSTANCE;


        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultsConverter(metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric);
        }

        private static class GeoResultsConverter
        implements Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> {
            private Metric metric;

            public GeoResultsConverter(Metric metric) {
                this.metric = metric;
            }

            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> convert(List<GeoRadiusResponse> source) {
                ArrayList<Object> results = new ArrayList<Object>(source.size());
                Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> converter = GeoResultConverterFactory.INSTANCE.forMetric(this.metric);
                for (GeoRadiusResponse result : source) {
                    results.add(converter.convert((Object)result));
                }
                return new GeoResults(results, this.metric);
            }
        }
    }
}

