/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Client;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.util.Pool;

public class JedisConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final Log log = LogFactory.getLog(JedisConnectionFactory.class);
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private final JedisClientConfiguration clientConfiguration;
    @Nullable
    private JedisShardInfo shardInfo;
    private boolean providedShardInfo = false;
    @Nullable
    private Pool<Jedis> pool;
    private boolean convertPipelineAndTxResults = true;
    private RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration("localhost", 6379);
    @Nullable
    private RedisConfiguration configuration;
    @Nullable
    private JedisCluster cluster;
    @Nullable
    private ClusterCommandExecutor clusterCommandExecutor;

    public JedisConnectionFactory() {
        this(new MutableJedisClientConfiguration());
    }

    private JedisConnectionFactory(JedisClientConfiguration clientConfig) {
        Assert.notNull((Object)clientConfig, (String)"JedisClientConfiguration must not be null!");
        this.clientConfiguration = clientConfig;
    }

    @Deprecated
    public JedisConnectionFactory(JedisShardInfo shardInfo) {
        this(MutableJedisClientConfiguration.create(shardInfo));
        this.shardInfo = shardInfo;
        this.providedShardInfo = true;
    }

    public JedisConnectionFactory(JedisPoolConfig poolConfig) {
        this((RedisSentinelConfiguration)null, poolConfig);
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        this(sentinelConfig, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig, JedisPoolConfig poolConfig) {
        this.configuration = sentinelConfig;
        this.clientConfiguration = MutableJedisClientConfiguration.create((GenericObjectPoolConfig)(poolConfig != null ? poolConfig : new JedisPoolConfig()));
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig) {
        this(clusterConfig, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig, JedisPoolConfig poolConfig) {
        Assert.notNull((Object)clusterConfig, (String)"RedisClusterConfiguration must not be null!");
        this.configuration = clusterConfig;
        this.clientConfiguration = MutableJedisClientConfiguration.create((GenericObjectPoolConfig)poolConfig);
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig) {
        this(standaloneConfig, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig, JedisClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)standaloneConfig, (String)"RedisStandaloneConfiguration must not be null!");
        this.standaloneConfig = standaloneConfig;
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig, JedisClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)sentinelConfig, (String)"RedisSentinelConfiguration must not be null!");
        this.configuration = sentinelConfig;
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig, JedisClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)clusterConfig, (String)"RedisClusterConfiguration must not be null!");
        this.configuration = clusterConfig;
    }

    protected Jedis fetchJedisConnector() {
        try {
            if (this.getUsePool() && this.pool != null) {
                return (Jedis)this.pool.getResource();
            }
            Jedis jedis = this.createJedis();
            jedis.connect();
            this.potentiallySetClientName(jedis);
            return jedis;
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", ex);
        }
    }

    private Jedis createJedis() {
        if (this.providedShardInfo) {
            return new Jedis(this.getShardInfo());
        }
        Jedis jedis = new Jedis(this.getHostName(), this.getPort(), this.getConnectTimeout(), this.getReadTimeout(), this.isUseSsl(), (SSLSocketFactory)this.clientConfiguration.getSslSocketFactory().orElse(null), (SSLParameters)this.clientConfiguration.getSslParameters().orElse(null), (HostnameVerifier)this.clientConfiguration.getHostnameVerifier().orElse(null));
        Client client = jedis.getClient();
        this.getRedisPassword().map(String::new).ifPresent(arg_0 -> ((Client)client).setPassword(arg_0));
        client.setDb((long)this.getDatabase());
        return jedis;
    }

    protected JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    public void afterPropertiesSet() {
        if (this.shardInfo == null && this.clientConfiguration instanceof MutableJedisClientConfiguration) {
            this.providedShardInfo = false;
            this.shardInfo = new JedisShardInfo(this.getHostName(), this.getPort(), this.isUseSsl(), (SSLSocketFactory)this.clientConfiguration.getSslSocketFactory().orElse(null), (SSLParameters)this.clientConfiguration.getSslParameters().orElse(null), (HostnameVerifier)this.clientConfiguration.getHostnameVerifier().orElse(null));
            this.getRedisPassword().map(String::new).ifPresent(arg_0 -> ((JedisShardInfo)this.shardInfo).setPassword(arg_0));
            int readTimeout = this.getReadTimeout();
            if (readTimeout > 0) {
                this.shardInfo.setSoTimeout(readTimeout);
            }
            this.getMutableConfiguration().setShardInfo(this.shardInfo);
        }
        if (this.getUsePool() && !this.isRedisClusterAware()) {
            this.pool = this.createPool();
        }
        if (this.isRedisClusterAware()) {
            this.cluster = this.createCluster();
        }
    }

    private Pool<Jedis> createPool() {
        if (this.isRedisSentinelAware()) {
            return this.createRedisSentinelPool((RedisSentinelConfiguration)this.configuration);
        }
        return this.createRedisPool();
    }

    protected Pool<Jedis> createRedisSentinelPool(RedisSentinelConfiguration config) {
        GenericObjectPoolConfig poolConfig = this.getPoolConfig() != null ? this.getPoolConfig() : new JedisPoolConfig();
        return new JedisSentinelPool(config.getMaster().getName(), this.convertToJedisSentinelSet(config.getSentinels()), poolConfig, this.getConnectTimeout(), this.getReadTimeout(), this.getPassword(), this.getDatabase(), this.getClientName());
    }

    protected Pool<Jedis> createRedisPool() {
        return new JedisPool(this.getPoolConfig(), this.getHostName(), this.getPort(), this.getConnectTimeout(), this.getReadTimeout(), this.getPassword(), this.getDatabase(), this.getClientName(), this.isUseSsl(), (SSLSocketFactory)this.clientConfiguration.getSslSocketFactory().orElse(null), (SSLParameters)this.clientConfiguration.getSslParameters().orElse(null), (HostnameVerifier)this.clientConfiguration.getHostnameVerifier().orElse(null));
    }

    private JedisCluster createCluster() {
        JedisCluster cluster = this.createCluster((RedisClusterConfiguration)this.configuration, this.getPoolConfig());
        JedisClusterConnection.JedisClusterTopologyProvider topologyProvider = new JedisClusterConnection.JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = new ClusterCommandExecutor(topologyProvider, new JedisClusterConnection.JedisClusterNodeResourceProvider(cluster, topologyProvider), EXCEPTION_TRANSLATION);
        return cluster;
    }

    protected JedisCluster createCluster(RedisClusterConfiguration clusterConfig, GenericObjectPoolConfig poolConfig) {
        Assert.notNull((Object)clusterConfig, (String)"Cluster configuration must not be null!");
        HashSet<HostAndPort> hostAndPort = new HashSet<HostAndPort>();
        for (RedisNode node : clusterConfig.getClusterNodes()) {
            hostAndPort.add(new HostAndPort(node.getHost(), node.getPort().intValue()));
        }
        int redirects = clusterConfig.getMaxRedirects() != null ? clusterConfig.getMaxRedirects() : 5;
        int connectTimeout = this.getConnectTimeout();
        int readTimeout = this.getReadTimeout();
        return StringUtils.hasText((String)this.getPassword()) ? new JedisCluster(hostAndPort, connectTimeout, readTimeout, redirects, this.getPassword(), poolConfig) : new JedisCluster(hostAndPort, connectTimeout, readTimeout, redirects, poolConfig);
    }

    public void destroy() {
        if (this.getUsePool() && this.pool != null) {
            try {
                this.pool.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Jedis pool", (Throwable)ex);
            }
            this.pool = null;
        }
        if (this.cluster != null) {
            try {
                this.cluster.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close Jedis cluster", (Throwable)ex);
            }
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isRedisClusterAware()) {
            return this.getClusterConnection();
        }
        Jedis jedis = this.fetchJedisConnector();
        String clientName = this.clientConfiguration.getClientName().orElse(null);
        JedisConnection connection = this.getUsePool() ? new JedisConnection(jedis, this.pool, this.getDatabase(), clientName) : new JedisConnection(jedis, null, this.getDatabase(), clientName);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        if (!this.isRedisClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new JedisClusterConnection(this.cluster, this.clusterCommandExecutor);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.standaloneConfig.getHostName();
    }

    @Deprecated
    public void setHostName(String hostName) {
        this.standaloneConfig.setHostName(hostName);
    }

    public boolean isUseSsl() {
        return this.clientConfiguration.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.getMutableConfiguration().setUseSsl(useSsl);
    }

    public String getPassword() {
        return this.getRedisPassword().map(String::new).orElse(null);
    }

    private RedisPassword getRedisPassword() {
        return RedisConfiguration.getPasswordOrElse(this.configuration, this.standaloneConfig::getPassword);
    }

    @Deprecated
    public void setPassword(String password) {
        if (RedisConfiguration.isPasswordAware(this.configuration)) {
            ((RedisConfiguration.WithPassword)((Object)this.configuration)).setPassword(password);
            return;
        }
        this.standaloneConfig.setPassword(RedisPassword.of(password));
    }

    public int getPort() {
        return this.standaloneConfig.getPort();
    }

    @Deprecated
    public void setPort(int port) {
        this.standaloneConfig.setPort(port);
    }

    @Deprecated
    @Nullable
    public JedisShardInfo getShardInfo() {
        return this.shardInfo;
    }

    @Deprecated
    public void setShardInfo(JedisShardInfo shardInfo) {
        this.shardInfo = shardInfo;
        this.providedShardInfo = true;
        this.getMutableConfiguration().setShardInfo(shardInfo);
    }

    public int getTimeout() {
        return this.getReadTimeout();
    }

    @Deprecated
    public void setTimeout(int timeout) {
        this.getMutableConfiguration().setReadTimeout(Duration.ofMillis(timeout));
        this.getMutableConfiguration().setConnectTimeout(Duration.ofMillis(timeout));
    }

    public boolean getUsePool() {
        if (this.isRedisSentinelAware()) {
            return true;
        }
        return this.clientConfiguration.isUsePooling();
    }

    @Deprecated
    public void setUsePool(boolean usePool) {
        if (this.isRedisSentinelAware() && !usePool) {
            throw new IllegalStateException("Jedis requires pooling for Redis Sentinel use!");
        }
        this.getMutableConfiguration().setUsePooling(usePool);
    }

    @Nullable
    public GenericObjectPoolConfig getPoolConfig() {
        return this.clientConfiguration.getPoolConfig().orElse(null);
    }

    @Deprecated
    public void setPoolConfig(JedisPoolConfig poolConfig) {
        this.getMutableConfiguration().setPoolConfig((GenericObjectPoolConfig)poolConfig);
    }

    public int getDatabase() {
        return RedisConfiguration.getDatabaseOrElse(this.configuration, this.standaloneConfig::getDatabase);
    }

    @Deprecated
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        if (RedisConfiguration.isDatabaseIndexAware(this.configuration)) {
            ((RedisConfiguration.WithDatabaseIndex)((Object)this.configuration)).setDatabase(index);
            return;
        }
        this.standaloneConfig.setDatabase(index);
    }

    @Nullable
    public String getClientName() {
        return this.clientConfiguration.getClientName().orElse(null);
    }

    @Deprecated
    public void setClientName(String clientName) {
        this.getMutableConfiguration().setClientName(clientName);
    }

    public JedisClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Nullable
    public RedisStandaloneConfiguration getStandaloneConfiguration() {
        return this.standaloneConfig;
    }

    @Nullable
    public RedisSentinelConfiguration getSentinelConfiguration() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration) ? (RedisSentinelConfiguration)this.configuration : null;
    }

    @Nullable
    public RedisClusterConfiguration getClusterConfiguration() {
        return RedisConfiguration.isClusterConfiguration(this.configuration) ? (RedisClusterConfiguration)this.configuration : null;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    public boolean isRedisClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        if (!this.isRedisSentinelAware()) {
            throw new InvalidDataAccessResourceUsageException("No Sentinels configured");
        }
        return new JedisSentinelConnection(this.getActiveSentinel());
    }

    private Jedis getActiveSentinel() {
        Assert.isTrue((boolean)RedisConfiguration.isSentinelConfiguration(this.configuration), (String)"SentinelConfig must not be null!");
        for (RedisNode node : ((RedisConfiguration.SentinelConfiguration)((Object)this.configuration)).getSentinels()) {
            Jedis jedis = new Jedis(node.getHost(), node.getPort().intValue(), this.getConnectTimeout(), this.getReadTimeout());
            try {
                if (!jedis.ping().equalsIgnoreCase("pong")) continue;
                this.potentiallySetClientName(jedis);
                return jedis;
            }
            catch (Exception ex) {
                log.warn((Object)String.format("Ping failed for sentinel host:%s", node.getHost()), (Throwable)ex);
            }
        }
        throw new InvalidDataAccessResourceUsageException("No Sentinel found");
    }

    private Set<String> convertToJedisSentinelSet(Collection<RedisNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> convertedNodes = new LinkedHashSet<String>(nodes.size());
        for (RedisNode node : nodes) {
            if (node == null) continue;
            convertedNodes.add(node.asString());
        }
        return convertedNodes;
    }

    private void potentiallySetClientName(Jedis jedis) {
        this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((Jedis)jedis).clientSetname(arg_0));
    }

    private int getReadTimeout() {
        return Math.toIntExact(this.clientConfiguration.getReadTimeout().toMillis());
    }

    private int getConnectTimeout() {
        return Math.toIntExact(this.clientConfiguration.getConnectTimeout().toMillis());
    }

    private MutableJedisClientConfiguration getMutableConfiguration() {
        Assert.state((boolean)(this.clientConfiguration instanceof MutableJedisClientConfiguration), () -> String.format("Client configuration must be instance of MutableJedisClientConfiguration but is %s", ClassUtils.getShortName(this.clientConfiguration.getClass())));
        return (MutableJedisClientConfiguration)this.clientConfiguration;
    }

    static class MutableJedisClientConfiguration
    implements JedisClientConfiguration {
        private boolean useSsl;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private SSLParameters sslParameters;
        @Nullable
        private HostnameVerifier hostnameVerifier;
        private boolean usePooling = true;
        private GenericObjectPoolConfig poolConfig = new JedisPoolConfig();
        @Nullable
        private String clientName;
        private Duration readTimeout = Duration.ofMillis(2000L);
        private Duration connectTimeout = Duration.ofMillis(2000L);

        MutableJedisClientConfiguration() {
        }

        public static JedisClientConfiguration create(JedisShardInfo shardInfo) {
            MutableJedisClientConfiguration configuration = new MutableJedisClientConfiguration();
            configuration.setShardInfo(shardInfo);
            return configuration;
        }

        public static JedisClientConfiguration create(GenericObjectPoolConfig jedisPoolConfig) {
            MutableJedisClientConfiguration configuration = new MutableJedisClientConfiguration();
            configuration.setPoolConfig(jedisPoolConfig);
            return configuration;
        }

        @Override
        public boolean isUseSsl() {
            return this.useSsl;
        }

        public void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        @Override
        public Optional<SSLSocketFactory> getSslSocketFactory() {
            return Optional.ofNullable(this.sslSocketFactory);
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        @Override
        public Optional<SSLParameters> getSslParameters() {
            return Optional.ofNullable(this.sslParameters);
        }

        public void setSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
        }

        @Override
        public Optional<HostnameVerifier> getHostnameVerifier() {
            return Optional.ofNullable(this.hostnameVerifier);
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        @Override
        public boolean isUsePooling() {
            return this.usePooling;
        }

        public void setUsePooling(boolean usePooling) {
            this.usePooling = usePooling;
        }

        @Override
        public Optional<GenericObjectPoolConfig> getPoolConfig() {
            return Optional.ofNullable(this.poolConfig);
        }

        public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
        }

        @Override
        public Optional<String> getClientName() {
            return Optional.ofNullable(this.clientName);
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        @Override
        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setShardInfo(JedisShardInfo shardInfo) {
            this.setSslSocketFactory(shardInfo.getSslSocketFactory());
            this.setSslParameters(shardInfo.getSslParameters());
            this.setHostnameVerifier(shardInfo.getHostnameVerifier());
            this.setUseSsl(shardInfo.getSsl());
            this.setConnectTimeout(Duration.ofMillis(shardInfo.getConnectionTimeout()));
            this.setReadTimeout(Duration.ofMillis(shardInfo.getSoTimeout()));
        }
    }
}

