/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.support;

import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.repository.core.MappingRedisEntityInformation;
import org.springframework.data.redis.repository.query.RedisQueryCreator;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class RedisRepositoryFactory
extends KeyValueRepositoryFactory {
    private final KeyValueOperations operations;

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations) {
        this(keyValueOperations, RedisQueryCreator.class);
    }

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this(keyValueOperations, queryCreator, KeyValuePartTreeQuery.class);
    }

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        super(keyValueOperations, queryCreator, repositoryQueryType);
        this.operations = keyValueOperations;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        RedisPersistentEntity entity = (RedisPersistentEntity)this.operations.getMappingContext().getRequiredPersistentEntity(domainClass);
        return new MappingRedisEntityInformation(entity);
    }
}

