/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;

public class RedisKeyExpiredEvent<T>
extends RedisKeyspaceEvent {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final byte[][] args;
    @Nullable
    private final Object value;

    public RedisKeyExpiredEvent(byte[] key) {
        this(key, null);
    }

    public RedisKeyExpiredEvent(byte[] key, @Nullable Object value) {
        this(null, key, value);
    }

    public RedisKeyExpiredEvent(@Nullable String channel, byte[] key, @Nullable Object value) {
        super(channel, key);
        this.args = ByteUtils.split(key, 58);
        this.value = value;
    }

    public String getKeyspace() {
        if (this.args.length >= 2) {
            return new String(this.args[0], CHARSET);
        }
        return null;
    }

    public byte[] getId() {
        return this.args.length == 2 ? this.args[1] : this.args[0];
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        byte[] id = this.getId();
        return "RedisKeyExpiredEvent [keyspace=" + this.getKeyspace() + ", id=" + (id == null ? null : new String(id)) + "]";
    }
}

