/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveValueOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveValueOperations<K, V>
implements ReactiveValueOperations<K, V> {
    @NonNull
    private final ReactiveRedisTemplate<?, ?> template;
    @NonNull
    private final RedisSerializationContext<K, V> serializationContext;

    @Override
    public Mono<Boolean> set(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.set(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Boolean> set(K key, V value, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Duration must not be null!");
        return this.createMono(connection -> connection.set(this.rawKey(key), this.rawValue(value), Expiration.from(timeout), RedisStringCommands.SetOption.UPSERT));
    }

    @Override
    public Mono<Boolean> setIfAbsent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.set(this.rawKey(key), this.rawValue(value), Expiration.persistent(), RedisStringCommands.SetOption.SET_IF_ABSENT));
    }

    @Override
    public Mono<Boolean> setIfPresent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.set(this.rawKey(key), this.rawValue(value), Expiration.persistent(), RedisStringCommands.SetOption.SET_IF_PRESENT));
    }

    @Override
    public Mono<Boolean> multiSet(Map<? extends K, ? extends V> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        return this.createMono(connection -> {
            Mono serializedMap = Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawKey(entry.getKey()), entry -> this.rawValue(entry.getValue()));
            return serializedMap.flatMap(connection::mSet);
        });
    }

    @Override
    public Mono<Boolean> multiSetIfAbsent(Map<? extends K, ? extends V> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        return this.createMono(connection -> {
            Mono serializedMap = Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawKey(entry.getKey()), entry -> this.rawValue(entry.getValue()));
            return serializedMap.flatMap(connection::mSetNX);
        });
    }

    @Override
    public Mono<V> get(Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.get(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Mono<V> getAndSet(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.getSet(this.rawKey(key), this.rawValue(value)).map(this.value()::read));
    }

    @Override
    public Mono<List<V>> multiGet(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)keys).map(this.key()::write).collectList().flatMap(connection::mGet).map(this::deserializeValues));
    }

    @Override
    public Mono<Long> append(K key, String value) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.createMono(connection -> connection.append(this.rawKey(key), this.serializationContext.getStringSerializationPair().write(value)));
    }

    @Override
    public Mono<String> get(K key, long start, long end) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.getRange(this.rawKey(key), start, end).map(this.stringSerializationPair()::read));
    }

    @Override
    public Mono<Long> set(K key, V value, long offset) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.setRange(this.rawKey(key), this.rawValue(value), offset));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.strLen(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> setBit(K key, long offset, boolean value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.setBit(this.rawKey(key), offset, value));
    }

    @Override
    public Mono<Boolean> getBit(K key, long offset) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.getBit(this.rawKey(key), offset));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveStringCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.stringCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private RedisSerializationContext.SerializationPair<String> stringSerializationPair() {
        return this.serializationContext.getStringSerializationPair();
    }

    private RedisSerializationContext.SerializationPair<K> key() {
        return this.serializationContext.getKeySerializationPair();
    }

    private RedisSerializationContext.SerializationPair<V> value() {
        return this.serializationContext.getValueSerializationPair();
    }

    private List<V> deserializeValues(List<ByteBuffer> source) {
        ArrayList<V> result = new ArrayList<V>(source.size());
        for (ByteBuffer buffer : source) {
            if (buffer == null) {
                result.add(null);
                continue;
            }
            result.add(this.readValue(buffer));
        }
        return result;
    }

    @ConstructorProperties(value={"template", "serializationContext"})
    public DefaultReactiveValueOperations(@NonNull ReactiveRedisTemplate<?, ?> template, @NonNull RedisSerializationContext<K, V> serializationContext) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (serializationContext == null) {
            throw new NullPointerException("serializationContext");
        }
        this.template = template;
        this.serializationContext = serializationContext;
    }
}

