/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.util.Assert;

class LettucePoolingConnectionProvider
implements LettuceConnectionProvider,
DisposableBean {
    private static final Log log = LogFactory.getLog(LettucePoolingConnectionProvider.class);
    private final LettuceConnectionProvider connectionProvider;
    private final GenericObjectPoolConfig poolConfig;
    private final Map<StatefulConnection<?, ?>, GenericObjectPool<StatefulConnection<?, ?>>> poolRef = new ConcurrentHashMap(32);
    private final Map<Class<?>, GenericObjectPool<StatefulConnection<?, ?>>> pools = new ConcurrentHashMap(32);

    LettucePoolingConnectionProvider(LettuceConnectionProvider connectionProvider, LettucePoolingClientConfiguration clientConfiguration) {
        Assert.notNull((Object)connectionProvider, (String)"ConnectionProvider must not be null!");
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        this.connectionProvider = connectionProvider;
        this.poolConfig = clientConfiguration.getPoolConfig();
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        GenericObjectPool pool = this.pools.computeIfAbsent(connectionType, poolType -> ConnectionPoolSupport.createGenericObjectPool(() -> this.connectionProvider.getConnection(connectionType), (GenericObjectPoolConfig)this.poolConfig, (boolean)false));
        try {
            StatefulConnection connection = (StatefulConnection)pool.borrowObject();
            this.poolRef.put(connection, pool);
            return (T)((StatefulConnection)connectionType.cast(connection));
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void release(StatefulConnection<?, ?> connection) {
        GenericObjectPool<StatefulConnection<?, ?>> pool = this.poolRef.remove(connection);
        if (pool == null) {
            throw new PoolException("Returned connection " + connection + " was either previously returned or does not belong to this connection provider");
        }
        pool.returnObject(connection);
    }

    public void destroy() throws Exception {
        if (!this.poolRef.isEmpty()) {
            log.warn((Object)"LettucePoolingConnectionProvider contains unreleased connections");
            this.poolRef.forEach((connection, pool) -> pool.returnObject(connection));
            this.poolRef.clear();
        }
        this.pools.forEach((type, pool) -> pool.close());
        this.pools.clear();
    }
}

