/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Set;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisZSetCommands {
    @Nullable
    public Boolean zAdd(byte[] var1, double var2, byte[] var4);

    @Nullable
    public Long zAdd(byte[] var1, Set<Tuple> var2);

    @Nullable
    public Long zRem(byte[] var1, byte[] ... var2);

    @Nullable
    public Double zIncrBy(byte[] var1, double var2, byte[] var4);

    @Nullable
    public Long zRank(byte[] var1, byte[] var2);

    @Nullable
    public Long zRevRank(byte[] var1, byte[] var2);

    @Nullable
    public Set<byte[]> zRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range range) {
        return this.zRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    @Nullable
    public Set<byte[]> zRevRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRevRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, Range range) {
        return this.zRevRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, new Range().gte(min).lte(max), Limit.unlimited());
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<byte[]> zRevRangeByScore(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range range) {
        return this.zRevRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, new Range().gte(min).lte(max));
    }

    @Nullable
    public Long zCount(byte[] var1, Range var2);

    @Nullable
    public Long zCard(byte[] var1);

    @Nullable
    public Double zScore(byte[] var1, byte[] var2);

    @Nullable
    public Long zRemRange(byte[] var1, long var2, long var4);

    @Nullable
    default public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    public Long zRemRangeByScore(byte[] var1, Range var2);

    @Nullable
    public Long zUnionStore(byte[] var1, byte[] ... var2);

    @Nullable
    public Long zUnionStore(byte[] var1, Aggregate var2, int[] var3, byte[] ... var4);

    @Nullable
    public Long zInterStore(byte[] var1, byte[] ... var2);

    @Nullable
    public Long zInterStore(byte[] var1, Aggregate var2, int[] var3, byte[] ... var4);

    public Cursor<Tuple> zScan(byte[] var1, ScanOptions var2);

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, Range range) {
        return this.zRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, String var2, String var3, long var4, long var6);

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key) {
        return this.zRangeByLex(key, Range.unbounded());
    }

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key, Range range) {
        return this.zRangeByLex(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByLex(byte[] var1, Range var2, Limit var3);

    public static class Limit {
        private static final Limit UNLIMITED = new Limit(){

            @Override
            public int getCount() {
                return -1;
            }

            @Override
            public int getOffset() {
                return super.getOffset();
            }
        };
        int offset;
        int count;

        public static Limit limit() {
            return new Limit();
        }

        public Limit offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Limit count(int count) {
            this.count = count;
            return this;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isUnlimited() {
            return this.equals(UNLIMITED);
        }

        public static Limit unlimited() {
            return UNLIMITED;
        }
    }

    public static class Range {
        @Nullable
        Boundary min;
        @Nullable
        Boundary max;

        public static Range range() {
            return new Range();
        }

        public static Range unbounded() {
            Range range = new Range();
            range.min = Boundary.infinite();
            range.max = Boundary.infinite();
            return range;
        }

        public Range gte(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, true);
            return this;
        }

        public Range gt(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, false);
            return this;
        }

        public Range lte(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, true);
            return this;
        }

        public Range lt(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, false);
            return this;
        }

        @Nullable
        public Boundary getMin() {
            return this.min;
        }

        @Nullable
        public Boundary getMax() {
            return this.max;
        }

        public static class Boundary {
            @Nullable
            Object value;
            boolean including;

            static Boundary infinite() {
                return new Boundary(null, true);
            }

            Boundary(@Nullable Object value, boolean including) {
                this.value = value;
                this.including = including;
            }

            @Nullable
            public Object getValue() {
                return this.value;
            }

            public boolean isIncluding() {
                return this.including;
            }
        }
    }

    public static interface Tuple
    extends Comparable<Double> {
        public byte[] getValue();

        public Double getScore();
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

