/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.ClusterConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettucePoolingConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceSentinelConnection;
import org.springframework.data.redis.connection.lettuce.StandaloneConnectionProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory,
ReactiveRedisConnectionFactory {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private final LettuceClientConfiguration clientConfiguration;
    @Nullable
    private AbstractRedisClient client;
    @Nullable
    private LettuceConnectionProvider connectionProvider;
    @Nullable
    private LettuceConnectionProvider reactiveConnectionProvider;
    private boolean validateConnection = false;
    private boolean shareNativeConnection = true;
    @Nullable
    private StatefulRedisConnection<byte[], byte[]> connection;
    @Nullable
    private LettucePool pool;
    private final Object connectionMonitor = new Object();
    private boolean convertPipelineAndTxResults = true;
    private RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration("localhost", 6379);
    @Nullable
    private RedisSentinelConfiguration sentinelConfiguration;
    @Nullable
    private RedisClusterConfiguration clusterConfiguration;
    @Nullable
    private ClusterCommandExecutor clusterCommandExecutor;

    public LettuceConnectionFactory() {
        this(new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration config) {
        this(config, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    private LettuceConnectionFactory(LettuceClientConfiguration clientConfig) {
        Assert.notNull((Object)clientConfig, (String)"LettuceClientConfiguration must not be null!");
        this.clientConfiguration = clientConfig;
    }

    public LettuceConnectionFactory(String host, int port) {
        this(new RedisStandaloneConfiguration(host, port), (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration) {
        this(sentinelConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration) {
        this(clusterConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    @Deprecated
    public LettuceConnectionFactory(LettucePool pool) {
        this(new MutableLettuceClientConfiguration());
        this.pool = pool;
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration standaloneConfig, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)standaloneConfig, (String)"RedisStandaloneConfiguration must not be null!");
        this.standaloneConfig = standaloneConfig;
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration must not be null!");
        this.sentinelConfiguration = sentinelConfiguration;
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)clusterConfiguration, (String)"RedisClusterConfiguration must not be null!");
        this.clusterConfiguration = clusterConfiguration;
    }

    public void afterPropertiesSet() {
        this.client = this.createClient();
        this.connectionProvider = this.createConnectionProvider(this.client, LettuceConnection.CODEC);
        this.reactiveConnectionProvider = this.createConnectionProvider(this.client, LettuceReactiveRedisConnection.CODEC);
        if (this.isClusterAware()) {
            this.clusterCommandExecutor = new ClusterCommandExecutor(new LettuceClusterTopologyProvider((RedisClusterClient)this.client), new LettuceClusterConnection.LettuceClusterNodeResourceProvider(this.connectionProvider), EXCEPTION_TRANSLATION);
        }
    }

    public void destroy() {
        block9: {
            block8: {
                this.resetConnection();
                if (this.connectionProvider instanceof DisposableBean) {
                    try {
                        ((DisposableBean)this.connectionProvider).destroy();
                    }
                    catch (Exception e) {
                        if (!this.log.isWarnEnabled()) break block8;
                        this.log.warn((Object)(this.connectionProvider + " did not shut down gracefully."), (Throwable)e);
                    }
                }
            }
            try {
                Duration timeout = this.clientConfiguration.getShutdownTimeout();
                this.client.shutdown(timeout.toMillis(), timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block9;
                this.log.warn((Object)((this.client != null ? ClassUtils.getShortName(this.client.getClass()) : "LettuceClient") + " did not shut down gracefully."), (Throwable)e);
            }
        }
        if (this.clusterCommandExecutor != null) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isClusterAware()) {
            return this.getClusterConnection();
        }
        LettuceConnection connection = this.pool != null ? new LettuceConnection(this.getSharedConnection(), this.getTimeout(), null, this.pool, this.getDatabase()) : new LettuceConnection(this.getSharedConnection(), this.connectionProvider, this.getTimeout(), this.getDatabase());
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new LettuceClusterConnection(this.connectionProvider, this.clusterCommandExecutor, this.clientConfiguration.getCommandTimeout());
    }

    @Override
    public LettuceReactiveRedisConnection getReactiveConnection() {
        return new LettuceReactiveRedisConnection(this.reactiveConnectionProvider);
    }

    @Override
    public LettuceReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new LettuceReactiveRedisClusterConnection(this.reactiveConnectionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.resetConnection();
            }
            this.connection = this.createLettuceConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            boolean valid = false;
            if (this.connection.isOpen()) {
                try {
                    this.connection.sync().ping();
                    valid = true;
                }
                catch (Exception e) {
                    this.log.debug((Object)"Validation failed", (Throwable)e);
                }
            }
            if (!valid) {
                this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
                this.log.warn((Object)"Validation of shared connection failed. Creating a new connection.");
                this.initConnection();
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return this.standaloneConfig.getHostName();
    }

    @Deprecated
    public void setHostName(String hostName) {
        this.standaloneConfig.setHostName(hostName);
    }

    public int getPort() {
        return this.standaloneConfig.getPort();
    }

    @Deprecated
    public void setPort(int port) {
        this.standaloneConfig.setPort(port);
    }

    public long getTimeout() {
        return this.getClientTimeout();
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.getMutableConfiguration().setTimeout(Duration.ofMillis(timeout));
    }

    public boolean isUseSsl() {
        return this.clientConfiguration.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.getMutableConfiguration().setUseSsl(useSsl);
    }

    public boolean isVerifyPeer() {
        return this.clientConfiguration.isVerifyPeer();
    }

    @Deprecated
    public void setVerifyPeer(boolean verifyPeer) {
        this.getMutableConfiguration().setVerifyPeer(verifyPeer);
    }

    public boolean isStartTls() {
        return this.clientConfiguration.isStartTls();
    }

    @Deprecated
    public void setStartTls(boolean startTls) {
        this.getMutableConfiguration().setStartTls(startTls);
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public int getDatabase() {
        if (this.isRedisSentinelAware()) {
            return this.sentinelConfiguration.getDatabase();
        }
        return this.standaloneConfig.getDatabase();
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        if (this.isRedisSentinelAware()) {
            this.sentinelConfiguration.setDatabase(index);
            return;
        }
        this.standaloneConfig.setDatabase(index);
    }

    public String getPassword() {
        return this.getRedisPassword().map(String::new).orElse(null);
    }

    private RedisPassword getRedisPassword() {
        if (this.isRedisSentinelAware()) {
            return this.sentinelConfiguration.getPassword();
        }
        if (this.isClusterAware()) {
            return this.clusterConfiguration.getPassword();
        }
        return this.standaloneConfig.getPassword();
    }

    @Deprecated
    public void setPassword(String password) {
        if (this.isRedisSentinelAware()) {
            this.sentinelConfiguration.setPassword(RedisPassword.of(password));
            return;
        }
        if (this.isClusterAware()) {
            this.clusterConfiguration.setPassword(RedisPassword.of(password));
            return;
        }
        this.standaloneConfig.setPassword(RedisPassword.of(password));
    }

    public long getShutdownTimeout() {
        return this.clientConfiguration.getShutdownTimeout().toMillis();
    }

    @Deprecated
    public void setShutdownTimeout(long shutdownTimeout) {
        this.getMutableConfiguration().setShutdownTimeout(Duration.ofMillis(shutdownTimeout));
    }

    public ClientResources getClientResources() {
        return this.clientConfiguration.getClientResources().orElse(null);
    }

    @Deprecated
    public void setClientResources(ClientResources clientResources) {
        this.getMutableConfiguration().setClientResources(clientResources);
    }

    public LettuceClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RedisStandaloneConfiguration getStandaloneConfiguration() {
        return this.standaloneConfig;
    }

    @Nullable
    public RedisSentinelConfiguration getSentinelConfiguration() {
        return this.sentinelConfiguration;
    }

    @Nullable
    public RedisClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean isRedisSentinelAware() {
        return this.sentinelConfiguration != null;
    }

    public boolean isClusterAware() {
        return this.clusterConfiguration != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisConnection<byte[], byte[]> getSharedConnection() {
        if (this.shareNativeConnection) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection == null) {
                    this.initConnection();
                }
                if (this.validateConnection) {
                    this.validateConnection();
                }
                return this.connection;
            }
        }
        return null;
    }

    protected StatefulRedisConnection<byte[], byte[]> createLettuceConnector() {
        try {
            StatefulRedisConnection connection;
            if (!this.isClusterAware()) {
                connection = this.connectionProvider.getConnection(StatefulRedisConnection.class);
                if (this.getDatabase() > 0) {
                    connection.sync().select(this.getDatabase());
                }
            } else {
                connection = null;
            }
            return connection;
        }
        catch (RedisException e) {
            throw new RedisConnectionFailureException("Unable to connect to Redis on " + this.getHostName() + ":" + this.getPort(), e);
        }
    }

    private LettuceConnectionProvider createConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        LettuceConnectionProvider connectionProvider = this.doConnectionProvider(client, codec);
        if (this.clientConfiguration instanceof LettucePoolingClientConfiguration) {
            return new LettucePoolingConnectionProvider(connectionProvider, (LettucePoolingClientConfiguration)this.clientConfiguration);
        }
        return connectionProvider;
    }

    private LettuceConnectionProvider doConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        if (this.isClusterAware()) {
            return new ClusterConnectionProvider((RedisClusterClient)client, codec);
        }
        return new StandaloneConnectionProvider((RedisClient)client, codec);
    }

    private AbstractRedisClient createClient() {
        if (this.isRedisSentinelAware()) {
            RedisURI redisURI = this.getSentinelRedisURI();
            RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisURI)).orElseGet(() -> RedisClient.create((RedisURI)redisURI));
            this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
            return redisClient;
        }
        if (this.isClusterAware()) {
            ArrayList<RedisURI> initialUris = new ArrayList<RedisURI>();
            for (RedisNode node : this.clusterConfiguration.getClusterNodes()) {
                initialUris.add(this.createRedisURIAndApplySettings(node.getHost(), node.getPort()));
            }
            RedisClusterClient clusterClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClusterClient.create((ClientResources)clientResources, (Iterable)initialUris)).orElseGet(() -> RedisClusterClient.create((Iterable)initialUris));
            this.clientConfiguration.getClientOptions().filter(clientOptions -> clientOptions instanceof ClusterClientOptions).ifPresent(clientOptions -> clusterClient.setOptions((ClusterClientOptions)clientOptions));
            return clusterClient;
        }
        RedisURI uri = this.createRedisURIAndApplySettings(this.getHostName(), this.getPort());
        RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)uri)).orElseGet(() -> RedisClient.create((RedisURI)uri));
        this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
        return redisClient;
    }

    private RedisURI getSentinelRedisURI() {
        RedisURI redisUri = LettuceConverters.sentinelConfigurationToRedisURI(this.sentinelConfiguration);
        this.getRedisPassword().toOptional().ifPresent(arg_0 -> ((RedisURI)redisUri).setPassword(arg_0));
        redisUri.setTimeout(this.clientConfiguration.getCommandTimeout());
        return redisUri;
    }

    private RedisURI createRedisURIAndApplySettings(String host, int port) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)host, (int)port);
        this.getRedisPassword().toOptional().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        builder.withSsl(this.clientConfiguration.isUseSsl());
        builder.withVerifyPeer(this.clientConfiguration.isVerifyPeer());
        builder.withStartTls(this.clientConfiguration.isStartTls());
        builder.withTimeout(this.clientConfiguration.getCommandTimeout());
        return builder.build();
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        return new LettuceSentinelConnection(this.connectionProvider);
    }

    private MutableLettuceClientConfiguration getMutableConfiguration() {
        Assert.state((boolean)(this.clientConfiguration instanceof MutableLettuceClientConfiguration), () -> String.format("Client configuration must be instance of MutableLettuceClientConfiguration but is %s", ClassUtils.getShortName(this.clientConfiguration.getClass())));
        return (MutableLettuceClientConfiguration)this.clientConfiguration;
    }

    private long getClientTimeout() {
        return this.clientConfiguration.getCommandTimeout().toMillis();
    }

    static class MutableLettuceClientConfiguration
    implements LettuceClientConfiguration {
        private boolean useSsl;
        private boolean verifyPeer = true;
        private boolean startTls;
        @Nullable
        private ClientResources clientResources;
        private Duration timeout = Duration.ofSeconds(60L);
        private Duration shutdownTimeout = Duration.ofMillis(100L);

        MutableLettuceClientConfiguration() {
        }

        @Override
        public boolean isUseSsl() {
            return this.useSsl;
        }

        public void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        @Override
        public boolean isVerifyPeer() {
            return this.verifyPeer;
        }

        public void setVerifyPeer(boolean verifyPeer) {
            this.verifyPeer = verifyPeer;
        }

        @Override
        public boolean isStartTls() {
            return this.startTls;
        }

        public void setStartTls(boolean startTls) {
            this.startTls = startTls;
        }

        @Override
        public Optional<ClientResources> getClientResources() {
            return Optional.ofNullable(this.clientResources);
        }

        public void setClientResources(ClientResources clientResources) {
            this.clientResources = clientResources;
        }

        @Override
        public Optional<ClientOptions> getClientOptions() {
            return Optional.empty();
        }

        @Override
        public Duration getCommandTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Override
        public Duration getShutdownTimeout() {
            return this.shutdownTimeout;
        }

        public void setShutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
        }
    }
}

