/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.data.redis.core.convert.Jsr310Converters;
import org.springframework.data.util.CacheValue;
import org.springframework.util.Assert;

public class CustomConversions {
    private static final Logger LOG = LoggerFactory.getLogger(CustomConversions.class);
    private static final String READ_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as reading converter although it doesn't convert from a Redis supported type! You might wanna check you annotation setup at the converter implementation.";
    private static final String WRITE_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as writing converter although it doesn't convert to a Redis supported type! You might wanna check you annotation setup at the converter implementation.";
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private final Set<Class<?>> customSimpleTypes;
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;
    private final Map<GenericConverter.ConvertiblePair, CacheValue<Class<?>>> customReadTargetTypes;
    private final Map<GenericConverter.ConvertiblePair, CacheValue<Class<?>>> customWriteTargetTypes;
    private final Map<Class<?>, CacheValue<Class<?>>> rawWriteTargetTypes;

    public CustomConversions() {
        this(new ArrayList());
    }

    public CustomConversions(List<?> converters) {
        Assert.notNull(converters, (String)"Converters must not be null!");
        this.readingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.customReadTargetTypes = new ConcurrentHashMap();
        this.customWriteTargetTypes = new ConcurrentHashMap();
        this.rawWriteTargetTypes = new ConcurrentHashMap();
        ArrayList<Object> toRegister = new ArrayList<Object>();
        toRegister.addAll(converters);
        toRegister.add(new BinaryConverters.StringToBytesConverter());
        toRegister.add(new BinaryConverters.BytesToStringConverter());
        toRegister.add(new BinaryConverters.NumberToBytesConverter());
        toRegister.add(new BinaryConverters.BytesToNumberConverterFactory());
        toRegister.add(new BinaryConverters.EnumToBytesConverter());
        toRegister.add(new BinaryConverters.BytesToEnumConverterFactory());
        toRegister.add(new BinaryConverters.BooleanToBytesConverter());
        toRegister.add(new BinaryConverters.BytesToBooleanConverter());
        toRegister.add(new BinaryConverters.DateToBytesConverter());
        toRegister.add(new BinaryConverters.BytesToDateConverter());
        toRegister.addAll(Jsr310Converters.getConvertersToRegister());
        for (Object e : toRegister) {
            this.registerConversion(e);
        }
        Collections.reverse(toRegister);
        this.converters = Collections.unmodifiableList(toRegister);
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, true);
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public void registerConvertersIn(GenericConversionService conversionService) {
        for (Object converter : this.converters) {
            boolean added = false;
            if (converter instanceof Converter) {
                conversionService.addConverter((Converter)converter);
                added = true;
            }
            if (converter instanceof ConverterFactory) {
                conversionService.addConverterFactory((ConverterFactory)converter);
                added = true;
            }
            if (converter instanceof GenericConverter) {
                conversionService.addConverter((GenericConverter)converter);
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException("Given set contains element that is neither Converter nor ConverterFactory!");
        }
    }

    private void registerConversion(Object converter) {
        Class<?> type = converter.getClass();
        boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
        boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
        if (converter instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)converter;
            for (GenericConverter.ConvertiblePair pair : genericConverter.getConvertibleTypes()) {
                this.register(new ConverterRegistration(pair, isReading, isWriting));
            }
        } else if (converter instanceof Converter) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            this.register(new ConverterRegistration(new GenericConverter.ConvertiblePair(arguments[0], arguments[1]), isReading, isWriting));
        } else if (converter instanceof ConverterFactory) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), ConverterFactory.class);
            this.register(new ConverterRegistration(new GenericConverter.ConvertiblePair(arguments[0], arguments[1]), isReading, isWriting));
        } else {
            throw new IllegalArgumentException("Unsupported Converter type!");
        }
    }

    private void register(ConverterRegistration converterRegistration) {
        GenericConverter.ConvertiblePair pair = converterRegistration.getConvertiblePair();
        if (converterRegistration.isReading()) {
            this.readingPairs.add(pair);
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleSourceType()) {
                LOG.warn(String.format(READ_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        if (converterRegistration.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleTargetType()) {
                LOG.warn(String.format(WRITE_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
    }

    public Class<?> getCustomWriteTarget(final Class<?> sourceType) {
        return CustomConversions.getOrCreateAndCache(sourceType, this.rawWriteTargetTypes, new Producer(){

            @Override
            public Class<?> get() {
                return CustomConversions.getCustomTarget(sourceType, null, CustomConversions.this.writingPairs);
            }
        });
    }

    public Class<?> getCustomWriteTarget(final Class<?> sourceType, final Class<?> requestedTargetType) {
        if (requestedTargetType == null) {
            return this.getCustomWriteTarget(sourceType);
        }
        return CustomConversions.getOrCreateAndCache(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType), this.customWriteTargetTypes, new Producer(){

            @Override
            public Class<?> get() {
                return CustomConversions.getCustomTarget(sourceType, requestedTargetType, CustomConversions.this.writingPairs);
            }
        });
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.hasCustomWriteTarget(sourceType, null);
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        return this.getCustomWriteTarget(sourceType, requestedTargetType) != null;
    }

    public boolean hasCustomReadTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        return this.getCustomReadTarget(sourceType, requestedTargetType) != null;
    }

    private Class<?> getCustomReadTarget(final Class<?> sourceType, final Class<?> requestedTargetType) {
        if (requestedTargetType == null) {
            return null;
        }
        return CustomConversions.getOrCreateAndCache(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType), this.customReadTargetTypes, new Producer(){

            @Override
            public Class<?> get() {
                return CustomConversions.getCustomTarget(sourceType, requestedTargetType, CustomConversions.this.readingPairs);
            }
        });
    }

    private static Class<?> getCustomTarget(Class<?> sourceType, Class<?> requestedTargetType, Collection<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(sourceType, (String)"SourceType must not be null!");
        Assert.notNull(pairs, (String)"Convertible pairs must not be null!");
        if (requestedTargetType != null && pairs.contains(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType))) {
            return requestedTargetType;
        }
        for (GenericConverter.ConvertiblePair typePair : pairs) {
            if (!typePair.getSourceType().isAssignableFrom(sourceType)) continue;
            Class targetType = typePair.getTargetType();
            if (requestedTargetType != null && !targetType.isAssignableFrom(requestedTargetType)) continue;
            return targetType;
        }
        return null;
    }

    private static <T> Class<?> getOrCreateAndCache(T key, Map<T, CacheValue<Class<?>>> cache, Producer producer) {
        CacheValue<Class<?>> cacheValue = cache.get(key);
        if (cacheValue != null) {
            return (Class)cacheValue.getValue();
        }
        Class<?> type = producer.get();
        cache.put(key, CacheValue.ofNullable(type));
        return type;
    }

    static class ConverterRegistration {
        private final GenericConverter.ConvertiblePair convertiblePair;
        private final boolean reading;
        private final boolean writing;

        public ConverterRegistration(GenericConverter.ConvertiblePair convertiblePair, boolean isReading, boolean isWriting) {
            Assert.notNull((Object)convertiblePair, (String)"Convertible pair must not be null!");
            this.convertiblePair = convertiblePair;
            this.reading = isReading;
            this.writing = isWriting;
        }

        public ConverterRegistration(Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
            this(new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
        }

        public boolean isWriting() {
            return this.writing || !this.reading && this.isSimpleTargetType();
        }

        public boolean isReading() {
            return this.reading || !this.writing && this.isSimpleSourceType();
        }

        public GenericConverter.ConvertiblePair getConvertiblePair() {
            return this.convertiblePair;
        }

        public boolean isSimpleSourceType() {
            return ConverterRegistration.isRedisBasicType(this.convertiblePair.getSourceType());
        }

        public boolean isSimpleTargetType() {
            return ConverterRegistration.isRedisBasicType(this.convertiblePair.getTargetType());
        }

        private static boolean isRedisBasicType(Class<?> type) {
            return byte[].class.equals(type) || Map.class.equals(type);
        }
    }

    private static interface Producer {
        public Class<?> get();
    }
}

