/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisOperations;

class DefaultBoundGeoOperations<K, M>
extends DefaultBoundKeyOperations<K>
implements BoundGeoOperations<K, M> {
    private final GeoOperations<K, M> ops;

    public DefaultBoundGeoOperations(K key, RedisOperations<K, M> operations) {
        super(key, operations);
        this.ops = operations.opsForGeo();
    }

    @Override
    public Long geoAdd(Point point, M member) {
        return this.ops.geoAdd(this.getKey(), point, member);
    }

    @Override
    public Long geoAdd(RedisGeoCommands.GeoLocation<M> location) {
        return this.ops.geoAdd(this.getKey(), location);
    }

    @Override
    public Long geoAdd(Map<M, Point> memberCoordinateMap) {
        return this.ops.geoAdd(this.getKey(), memberCoordinateMap);
    }

    @Override
    public Long geoAdd(Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        return this.ops.geoAdd(this.getKey(), locations);
    }

    @Override
    public Distance geoDist(M member1, M member2) {
        return this.ops.geoDist(this.getKey(), member1, member2);
    }

    @Override
    public Distance geoDist(M member1, M member2, Metric unit) {
        return this.ops.geoDist(this.getKey(), member1, member2, unit);
    }

    @Override
    public List<String> geoHash(M ... members) {
        return this.ops.geoHash(this.getKey(), members);
    }

    @Override
    public List<Point> geoPos(M ... members) {
        return this.ops.geoPos(this.getKey(), members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(Circle within) {
        return this.ops.geoRadius(this.getKey(), within);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(Circle within, RedisGeoCommands.GeoRadiusCommandArgs param) {
        return this.ops.geoRadius(this.getKey(), within, param);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, double radius) {
        return this.ops.geoRadiusByMember(this.getKey(), member, radius);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(M member, Distance distance) {
        return this.ops.geoRadiusByMember(this.getKey(), member, distance);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs param) {
        return this.ops.geoRadiusByMember(this.getKey(), member, distance, param);
    }

    @Override
    public Long geoRemove(M ... members) {
        return this.ops.geoRemove(this.getKey(), members);
    }

    @Override
    public DataType getType() {
        return DataType.ZSET;
    }
}

