/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Set;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

public interface RedisZSetCommands {
    public Boolean zAdd(byte[] var1, double var2, byte[] var4);

    public Long zAdd(byte[] var1, Set<Tuple> var2);

    public Long zRem(byte[] var1, byte[] ... var2);

    public Double zIncrBy(byte[] var1, double var2, byte[] var4);

    public Long zRank(byte[] var1, byte[] var2);

    public Long zRevRank(byte[] var1, byte[] var2);

    public Set<byte[]> zRange(byte[] var1, long var2, long var4);

    public Set<Tuple> zRangeWithScores(byte[] var1, long var2, long var4);

    public Set<byte[]> zRangeByScore(byte[] var1, double var2, double var4);

    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, Range var2);

    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, double var2, double var4);

    public Set<byte[]> zRangeByScore(byte[] var1, double var2, double var4, long var6, long var8);

    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, double var2, double var4, long var6, long var8);

    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    public Set<byte[]> zRevRange(byte[] var1, long var2, long var4);

    public Set<Tuple> zRevRangeWithScores(byte[] var1, long var2, long var4);

    public Set<byte[]> zRevRangeByScore(byte[] var1, double var2, double var4);

    public Set<byte[]> zRevRangeByScore(byte[] var1, Range var2);

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, double var2, double var4);

    public Set<byte[]> zRevRangeByScore(byte[] var1, double var2, double var4, long var6, long var8);

    public Set<byte[]> zRevRangeByScore(byte[] var1, Range var2, Limit var3);

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, double var2, double var4, long var6, long var8);

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, Range var2);

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    public Long zCount(byte[] var1, double var2, double var4);

    public Long zCount(byte[] var1, Range var2);

    public Long zCard(byte[] var1);

    public Double zScore(byte[] var1, byte[] var2);

    public Long zRemRange(byte[] var1, long var2, long var4);

    public Long zRemRangeByScore(byte[] var1, double var2, double var4);

    public Long zRemRangeByScore(byte[] var1, Range var2);

    public Long zUnionStore(byte[] var1, byte[] ... var2);

    public Long zUnionStore(byte[] var1, Aggregate var2, int[] var3, byte[] ... var4);

    public Long zInterStore(byte[] var1, byte[] ... var2);

    public Long zInterStore(byte[] var1, Aggregate var2, int[] var3, byte[] ... var4);

    public Cursor<Tuple> zScan(byte[] var1, ScanOptions var2);

    public Set<byte[]> zRangeByScore(byte[] var1, String var2, String var3);

    public Set<byte[]> zRangeByScore(byte[] var1, Range var2);

    public Set<byte[]> zRangeByScore(byte[] var1, String var2, String var3, long var4, long var6);

    public Set<byte[]> zRangeByScore(byte[] var1, Range var2, Limit var3);

    public Set<byte[]> zRangeByLex(byte[] var1);

    public Set<byte[]> zRangeByLex(byte[] var1, Range var2);

    public Set<byte[]> zRangeByLex(byte[] var1, Range var2, Limit var3);

    public static class Limit {
        int offset;
        int count;

        public static Limit limit() {
            return new Limit();
        }

        public Limit offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Limit count(int count) {
            this.count = count;
            return this;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class Range {
        Boundary min;
        Boundary max;

        public static Range range() {
            return new Range();
        }

        public static Range unbounded() {
            Range range = new Range();
            range.min = Boundary.infinite();
            range.max = Boundary.infinite();
            return range;
        }

        public Range gte(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, true);
            return this;
        }

        public Range gt(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, false);
            return this;
        }

        public Range lte(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, true);
            return this;
        }

        public Range lt(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, false);
            return this;
        }

        public Boundary getMin() {
            return this.min;
        }

        public Boundary getMax() {
            return this.max;
        }

        public static class Boundary {
            Object value;
            boolean including;

            static Boundary infinite() {
                return new Boundary(null, true);
            }

            Boundary(Object value, boolean including) {
                this.value = value;
                this.including = including;
            }

            public Object getValue() {
                return this.value;
            }

            public boolean isIncluding() {
                return this.including;
            }
        }
    }

    public static interface Tuple
    extends Comparable<Double> {
        public byte[] getValue();

        public Double getScore();
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

