/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.CustomConversions;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.comparator.NullSafeComparator;

public class MappingRedisConverter
implements RedisConverter,
InitializingBean {
    private static final String TYPE_HINT_ALIAS = "_class";
    private static final String INVALID_TYPE_ASSIGNMENT = "Value of type %s cannot be assigned to property %s of type %s.";
    private final RedisMappingContext mappingContext;
    private final GenericConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final TypeMapper<RedisData> typeMapper;
    private final Comparator<String> listKeyComparator = new NullSafeComparator((Comparator)NaturalOrderingKeyComparator.INSTANCE, true);
    private ReferenceResolver referenceResolver;
    private IndexResolver indexResolver;
    private CustomConversions customConversions;

    MappingRedisConverter(RedisMappingContext context) {
        this(context, null, null);
    }

    public MappingRedisConverter(RedisMappingContext mappingContext, IndexResolver indexResolver, ReferenceResolver referenceResolver) {
        this.mappingContext = mappingContext != null ? mappingContext : new RedisMappingContext();
        this.entityInstantiators = new EntityInstantiators();
        this.conversionService = new DefaultConversionService();
        this.customConversions = new CustomConversions();
        this.typeMapper = new DefaultTypeMapper((TypeAliasAccessor)new RedisTypeAliasAccessor((ConversionService)this.conversionService));
        this.referenceResolver = referenceResolver;
        this.indexResolver = indexResolver != null ? indexResolver : new PathIndexResolver(this.mappingContext);
    }

    public <R> R read(Class<R> type, RedisData source) {
        return this.readInternal("", type, source);
    }

    private <R> R readInternal(final String path, Class<R> type, final RedisData source) {
        if (source.getBucket() == null || source.getBucket().isEmpty()) {
            return null;
        }
        TypeInformation readType = this.typeMapper.readType((Object)source);
        TypeInformation typeToUse = readType != null ? readType : ClassTypeInformation.from(type);
        final RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((TypeInformation<?>)typeToUse);
        if (this.customConversions.hasCustomReadTarget(Map.class, typeToUse.getType())) {
            HashMap<String, byte[]> partial = new HashMap<String, byte[]>();
            if (!path.isEmpty()) {
                for (Map.Entry<String, byte[]> entry : source.getBucket().extract(path + ".").entrySet()) {
                    partial.put(entry.getKey().substring(path.length() + 1), entry.getValue());
                }
            } else {
                partial.putAll(source.getBucket().asMap());
            }
            Object instance = this.conversionService.convert(partial, typeToUse.getType());
            if (entity.hasIdProperty()) {
                entity.getPropertyAccessor(instance).setProperty(entity.getIdProperty(), (Object)source.getId());
            }
            return (R)instance;
        }
        if (this.conversionService.canConvert(byte[].class, typeToUse.getType())) {
            return (R)this.conversionService.convert((Object)source.getBucket().get(StringUtils.hasText((String)path) ? path : "_raw"), typeToUse.getType());
        }
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new ConverterAwareParameterValueProvider(path, source, (ConversionService)this.conversionService), (Object)this.conversionService));
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<KeyValuePersistentProperty>(){

            public void doWithPersistentProperty(KeyValuePersistentProperty persistentProperty) {
                String currentPath = !path.isEmpty() ? path + "." + persistentProperty.getName() : persistentProperty.getName();
                PreferredConstructor constructor = entity.getPersistenceConstructor();
                if (constructor.isConstructorParameter((PersistentProperty)persistentProperty)) {
                    return;
                }
                if (persistentProperty.isMap()) {
                    Map targetValue = null;
                    targetValue = MappingRedisConverter.this.conversionService.canConvert(byte[].class, persistentProperty.getMapValueType()) ? MappingRedisConverter.this.readMapOfSimpleTypes(currentPath, persistentProperty.getType(), persistentProperty.getComponentType(), persistentProperty.getMapValueType(), source) : MappingRedisConverter.this.readMapOfComplexTypes(currentPath, persistentProperty.getType(), persistentProperty.getComponentType(), persistentProperty.getMapValueType(), source);
                    if (targetValue != null) {
                        accessor.setProperty((PersistentProperty)persistentProperty, (Object)targetValue);
                    }
                } else if (persistentProperty.isCollectionLike()) {
                    Object targetValue = MappingRedisConverter.this.readCollectionOrArray(currentPath, persistentProperty.getType(), persistentProperty.getTypeInformation().getComponentType().getActualType().getType(), source.getBucket());
                    if (targetValue != null) {
                        accessor.setProperty((PersistentProperty)persistentProperty, targetValue);
                    }
                } else if (persistentProperty.isEntity() && !MappingRedisConverter.this.conversionService.canConvert(byte[].class, persistentProperty.getTypeInformation().getActualType().getType())) {
                    Class targetType = persistentProperty.getTypeInformation().getActualType().getType();
                    Bucket bucket = source.getBucket().extract(currentPath + ".");
                    RedisData newBucket = new RedisData(bucket);
                    byte[] type = bucket.get(currentPath + "." + MappingRedisConverter.TYPE_HINT_ALIAS);
                    if (type != null && type.length > 0) {
                        newBucket.getBucket().put(MappingRedisConverter.TYPE_HINT_ALIAS, type);
                    }
                    accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.readInternal(currentPath, targetType, newBucket));
                } else {
                    if (persistentProperty.isIdProperty() && StringUtils.isEmpty((Object)path.isEmpty())) {
                        if (source.getBucket().get(currentPath) == null) {
                            accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.fromBytes(source.getBucket().get(currentPath), persistentProperty.getActualType()));
                        } else {
                            accessor.setProperty((PersistentProperty)persistentProperty, (Object)source.getId());
                        }
                    }
                    Class typeToUse = MappingRedisConverter.this.getTypeHint(currentPath, source.getBucket(), persistentProperty.getActualType());
                    accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.fromBytes(source.getBucket().get(currentPath), typeToUse));
                }
            }
        });
        this.readAssociation(path, source, entity, accessor);
        return (R)instance;
    }

    private void readAssociation(final String path, final RedisData source, KeyValuePersistentEntity<?> entity, final PersistentPropertyAccessor accessor) {
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<KeyValuePersistentProperty>(){

            public void doWithAssociation(Association<KeyValuePersistentProperty> association) {
                String currentPath;
                String string = currentPath = !path.isEmpty() ? path + "." + ((KeyValuePersistentProperty)association.getInverse()).getName() : ((KeyValuePersistentProperty)association.getInverse()).getName();
                if (((KeyValuePersistentProperty)association.getInverse()).isCollectionLike()) {
                    Bucket bucket = source.getBucket().extract(currentPath + ".[");
                    Collection target = CollectionFactory.createCollection((Class)((KeyValuePersistentProperty)association.getInverse()).getType(), (Class)((KeyValuePersistentProperty)association.getInverse()).getComponentType(), (int)bucket.size());
                    for (Map.Entry<String, byte[]> entry : bucket.entrySet()) {
                        String referenceKey = MappingRedisConverter.this.fromBytes(entry.getValue(), String.class);
                        if (!KeyspaceIdentifier.isValid(referenceKey)) continue;
                        KeyspaceIdentifier identifier = KeyspaceIdentifier.of(referenceKey);
                        Map<byte[], byte[]> rawHash = MappingRedisConverter.this.referenceResolver.resolveReference((Serializable)((Object)identifier.getId()), identifier.getKeyspace());
                        if (CollectionUtils.isEmpty(rawHash)) continue;
                        target.add(MappingRedisConverter.this.read(((KeyValuePersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                    }
                    accessor.setProperty(association.getInverse(), (Object)target);
                } else {
                    byte[] binKey = source.getBucket().get(currentPath);
                    if (binKey == null || binKey.length == 0) {
                        return;
                    }
                    String referenceKey = MappingRedisConverter.this.fromBytes(binKey, String.class);
                    if (KeyspaceIdentifier.isValid(referenceKey)) {
                        KeyspaceIdentifier identifier = KeyspaceIdentifier.of(referenceKey);
                        Map<byte[], byte[]> rawHash = MappingRedisConverter.this.referenceResolver.resolveReference((Serializable)((Object)identifier.getId()), identifier.getKeyspace());
                        if (!CollectionUtils.isEmpty(rawHash)) {
                            accessor.setProperty(association.getInverse(), MappingRedisConverter.this.read(((KeyValuePersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                        }
                    }
                }
            }
        });
    }

    public void write(Object source, RedisData sink) {
        if (source == null) {
            return;
        }
        if (source instanceof PartialUpdate) {
            this.writePartialUpdate((PartialUpdate)source, sink);
            return;
        }
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(source.getClass());
        if (!this.customConversions.hasCustomWriteTarget(source.getClass())) {
            this.typeMapper.writeType(ClassUtils.getUserClass((Object)source), (Object)sink);
        }
        if (entity == null) {
            this.typeMapper.writeType(ClassUtils.getUserClass((Object)source), (Object)sink);
            sink.getBucket().put("_raw", (byte[])this.conversionService.convert(source, byte[].class));
            return;
        }
        sink.setKeyspace(entity.getKeySpace());
        this.writeInternal(entity.getKeySpace(), "", source, entity.getTypeInformation(), sink);
        sink.setId((String)this.getConversionService().convert(entity.getIdentifierAccessor(source).getIdentifier(), String.class));
        Long ttl = entity.getTimeToLiveAccessor().getTimeToLive(source);
        if (ttl != null && ttl > 0L) {
            sink.setTimeToLive(ttl);
        }
        for (IndexedData indexedData : this.indexResolver.resolveIndexesFor(entity.getTypeInformation(), source)) {
            sink.addIndexedData(indexedData);
        }
    }

    protected void writePartialUpdate(PartialUpdate<?> update, RedisData sink) {
        Long ttl;
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(update.getTarget());
        this.write(update.getValue(), sink);
        if (sink.getBucket().keySet().contains(TYPE_HINT_ALIAS)) {
            sink.getBucket().put(TYPE_HINT_ALIAS, null);
        }
        if (update.isRefreshTtl() && !update.getPropertyUpdates().isEmpty() && (ttl = entity.getTimeToLiveAccessor().getTimeToLive(update)) != null && ttl > 0L) {
            sink.setTimeToLive(ttl);
        }
        for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
            String path = pUpdate.getPropertyPath();
            if (!PartialUpdate.UpdateCommand.SET.equals((Object)pUpdate.getCmd())) continue;
            this.writePartialPropertyUpdate(update, pUpdate, sink, entity, path);
        }
    }

    private void writePartialPropertyUpdate(PartialUpdate<?> update, PartialUpdate.PropertyUpdate pUpdate, RedisData sink, RedisPersistentEntity<?> entity, String path) {
        KeyValuePersistentProperty targetProperty = this.getTargetPropertyOrNullForPath(path, update.getTarget());
        if (targetProperty == null) {
            targetProperty = this.getTargetPropertyOrNullForPath(path.replaceAll("\\.\\[.*\\]", ""), update.getTarget());
            ClassTypeInformation ti = targetProperty == null ? ClassTypeInformation.OBJECT : (targetProperty.isMap() ? (targetProperty.getTypeInformation().getMapValueType() != null ? targetProperty.getTypeInformation().getMapValueType() : ClassTypeInformation.OBJECT) : targetProperty.getTypeInformation().getActualType());
            this.writeInternal(entity.getKeySpace(), pUpdate.getPropertyPath(), pUpdate.getValue(), (TypeInformation<?>)ti, sink);
            return;
        }
        if (targetProperty.isAssociation()) {
            if (targetProperty.isCollectionLike()) {
                RedisPersistentEntity<?> ref = this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)targetProperty.getAssociation().getInverse()).getTypeInformation().getComponentType().getActualType());
                int i = 0;
                for (Object o : (Collection)pUpdate.getValue()) {
                    Object refId = ref.getPropertyAccessor(o).getProperty(ref.getIdProperty());
                    sink.getBucket().put(pUpdate.getPropertyPath() + ".[" + i + "]", this.toBytes(ref.getKeySpace() + ":" + refId));
                    ++i;
                }
            } else {
                RedisPersistentEntity<?> ref = this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)targetProperty.getAssociation().getInverse()).getTypeInformation());
                Object refId = ref.getPropertyAccessor(pUpdate.getValue()).getProperty(ref.getIdProperty());
                sink.getBucket().put(pUpdate.getPropertyPath(), this.toBytes(ref.getKeySpace() + ":" + refId));
            }
        } else if (targetProperty.isCollectionLike()) {
            Set<Object> collection = pUpdate.getValue() instanceof Collection ? (Set<Object>)pUpdate.getValue() : Collections.singleton(pUpdate.getValue());
            this.writeCollection(entity.getKeySpace(), pUpdate.getPropertyPath(), collection, targetProperty.getTypeInformation().getActualType(), sink);
        } else if (targetProperty.isMap()) {
            HashMap map = new HashMap();
            if (pUpdate.getValue() instanceof Map) {
                map.putAll((Map)pUpdate.getValue());
            } else if (pUpdate.getValue() instanceof Map.Entry) {
                map.put(((Map.Entry)pUpdate.getValue()).getKey(), ((Map.Entry)pUpdate.getValue()).getValue());
            } else {
                throw new MappingException(String.format("Cannot set update value for map property '%s' to '%s'. Please use a Map or Map.Entry.", pUpdate.getPropertyPath(), pUpdate.getValue()));
            }
            this.writeMap(entity.getKeySpace(), pUpdate.getPropertyPath(), targetProperty.getMapValueType(), map, sink);
        } else {
            this.writeInternal(entity.getKeySpace(), pUpdate.getPropertyPath(), pUpdate.getValue(), targetProperty.getTypeInformation(), sink);
            Set<IndexedData> data = this.indexResolver.resolveIndexesFor(entity.getKeySpace(), pUpdate.getPropertyPath(), targetProperty.getTypeInformation(), pUpdate.getValue());
            if (data.isEmpty()) {
                data = this.indexResolver.resolveIndexesFor(entity.getKeySpace(), pUpdate.getPropertyPath(), targetProperty.getOwner().getTypeInformation(), pUpdate.getValue());
            }
            sink.addIndexedData(data);
        }
    }

    KeyValuePersistentProperty getTargetPropertyOrNullForPath(String path, Class<?> type) {
        try {
            PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(path, type);
            return (KeyValuePersistentProperty)persistentPropertyPath.getLeafProperty();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void writeInternal(final String keyspace, final String path, Object value, TypeInformation<?> typeHint, final RedisData sink) {
        if (value == null) {
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            if (!StringUtils.hasText((String)path) && this.customConversions.getCustomWriteTarget(value.getClass()).equals(byte[].class)) {
                sink.getBucket().put(StringUtils.hasText((String)path) ? path : "_raw", (byte[])this.conversionService.convert(value, byte[].class));
            } else {
                if (!ClassUtils.isAssignable((Class)typeHint.getType(), value.getClass())) {
                    throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, value.getClass(), path, typeHint.getType()));
                }
                this.writeToBucket(path, value, sink, typeHint.getType());
            }
            return;
        }
        if (value.getClass() != typeHint.getType()) {
            sink.getBucket().put(!path.isEmpty() ? path + "." + TYPE_HINT_ALIAS : TYPE_HINT_ALIAS, this.toBytes(value.getClass().getName()));
        }
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(value.getClass());
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<KeyValuePersistentProperty>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doWithPersistentProperty(KeyValuePersistentProperty persistentProperty) {
                String propertyStringPath = (!path.isEmpty() ? path + "." : "") + persistentProperty.getName();
                if (persistentProperty.isIdProperty()) {
                    sink.getBucket().put(propertyStringPath, MappingRedisConverter.this.toBytes(accessor.getProperty((PersistentProperty)persistentProperty)));
                    return;
                }
                if (persistentProperty.isMap()) {
                    MappingRedisConverter.this.writeMap(keyspace, propertyStringPath, persistentProperty.getMapValueType(), (Map)accessor.getProperty((PersistentProperty)persistentProperty), sink);
                    return;
                } else if (persistentProperty.isCollectionLike()) {
                    Object property = accessor.getProperty((PersistentProperty)persistentProperty);
                    if (property == null || Iterable.class.isAssignableFrom(property.getClass())) {
                        MappingRedisConverter.this.writeCollection(keyspace, propertyStringPath, (Iterable)property, persistentProperty.getTypeInformation().getComponentType(), sink);
                        return;
                    } else {
                        if (!property.getClass().isArray()) throw new RuntimeException("Don't know how to handle " + property.getClass() + " type collection");
                        MappingRedisConverter.this.writeCollection(keyspace, propertyStringPath, CollectionUtils.arrayToList((Object)property), persistentProperty.getTypeInformation().getComponentType(), sink);
                    }
                    return;
                } else if (persistentProperty.isEntity()) {
                    MappingRedisConverter.this.writeInternal(keyspace, propertyStringPath, accessor.getProperty((PersistentProperty)persistentProperty), persistentProperty.getTypeInformation().getActualType(), sink);
                    return;
                } else {
                    Object propertyValue = accessor.getProperty((PersistentProperty)persistentProperty);
                    MappingRedisConverter.this.writeToBucket(propertyStringPath, propertyValue, sink, persistentProperty.getType());
                }
            }
        });
        this.writeAssociation(path, entity, value, sink);
    }

    private void writeAssociation(final String path, KeyValuePersistentEntity<?> entity, Object value, final RedisData sink) {
        if (value == null) {
            return;
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<KeyValuePersistentProperty>(){

            public void doWithAssociation(Association<KeyValuePersistentProperty> association) {
                Object refObject = accessor.getProperty(association.getInverse());
                if (refObject == null) {
                    return;
                }
                if (((KeyValuePersistentProperty)association.getInverse()).isCollectionLike()) {
                    RedisPersistentEntity<?> ref = MappingRedisConverter.this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)association.getInverse()).getTypeInformation().getComponentType().getActualType());
                    String keyspace = ref.getKeySpace();
                    String propertyStringPath = (!path.isEmpty() ? path + "." : "") + ((KeyValuePersistentProperty)association.getInverse()).getName();
                    int i = 0;
                    for (Object o : (Collection)refObject) {
                        Object refId = ref.getPropertyAccessor(o).getProperty(ref.getIdProperty());
                        sink.getBucket().put(propertyStringPath + ".[" + i + "]", MappingRedisConverter.this.toBytes(keyspace + ":" + refId));
                        ++i;
                    }
                } else {
                    RedisPersistentEntity<?> ref = MappingRedisConverter.this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)association.getInverse()).getTypeInformation());
                    String keyspace = ref.getKeySpace();
                    Object refId = ref.getPropertyAccessor(refObject).getProperty(ref.getIdProperty());
                    String propertyStringPath = (!path.isEmpty() ? path + "." : "") + ((KeyValuePersistentProperty)association.getInverse()).getName();
                    sink.getBucket().put(propertyStringPath, MappingRedisConverter.this.toBytes(keyspace + ":" + refId));
                }
            }
        });
    }

    private void writeCollection(String keyspace, String path, Iterable<?> values, TypeInformation<?> typeHint, RedisData sink) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (Object value : values) {
            if (value == null) break;
            String currentPath = path + ".[" + i + "]";
            if (!ClassUtils.isAssignable((Class)typeHint.getType(), value.getClass())) {
                throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, value.getClass(), currentPath, typeHint.getType()));
            }
            if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
                this.writeToBucket(currentPath, value, sink, typeHint.getType());
            } else {
                this.writeInternal(keyspace, currentPath, value, typeHint, sink);
            }
            ++i;
        }
    }

    private void writeToBucket(String path, Object value, RedisData sink, Class<?> propertyType) {
        if (value == null) {
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            Class<?> targetType = this.customConversions.getCustomWriteTarget(value.getClass());
            if (!ClassUtils.isAssignable(Map.class, targetType) && this.customConversions.isSimpleType(value.getClass()) && value.getClass() != propertyType) {
                sink.getBucket().put(!path.isEmpty() ? path + "." + TYPE_HINT_ALIAS : TYPE_HINT_ALIAS, this.toBytes(value.getClass().getName()));
            }
            if (ClassUtils.isAssignable(Map.class, targetType)) {
                Map map = (Map)this.conversionService.convert(value, targetType);
                for (Map.Entry entry : map.entrySet()) {
                    sink.getBucket().put(path + (StringUtils.hasText((String)path) ? "." : "") + entry.getKey(), this.toBytes(entry.getValue()));
                }
            } else if (ClassUtils.isAssignable(byte[].class, targetType)) {
                sink.getBucket().put(path, this.toBytes(value));
            } else {
                throw new IllegalArgumentException(String.format("Cannot convert value '%s' of type %s to bytes.", value, value.getClass()));
            }
        }
    }

    private Object readCollectionOrArray(String path, Class<?> collectionType, Class<?> valueType, Bucket bucket) {
        ArrayList<String> keys = new ArrayList<String>(bucket.extractAllKeysFor(path));
        Collections.sort(keys, this.listKeyComparator);
        boolean isArray = collectionType.isArray();
        Class collectionTypeToUse = isArray ? ArrayList.class : collectionType;
        Collection target = CollectionFactory.createCollection(collectionTypeToUse, valueType, (int)keys.size());
        for (String key : keys) {
            Class<?> typeToUse;
            if (key.endsWith(TYPE_HINT_ALIAS)) continue;
            Bucket elementData = bucket.extract(key);
            byte[] typeInfo = elementData.get(key + "." + TYPE_HINT_ALIAS);
            if (typeInfo != null && typeInfo.length > 0) {
                elementData.put(TYPE_HINT_ALIAS, typeInfo);
            }
            if (this.conversionService.canConvert(byte[].class, typeToUse = this.getTypeHint(key, elementData, valueType))) {
                target.add(this.fromBytes(elementData.get(key), typeToUse));
                continue;
            }
            target.add(this.readInternal(key, valueType, new RedisData(elementData)));
        }
        return isArray ? this.toArray(target, collectionType, valueType) : (target.isEmpty() ? null : target);
    }

    private void writeMap(String keyspace, String path, Class<?> mapValueType, Map<?, ?> source, RedisData sink) {
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            String currentPath = path + ".[" + this.mapMapKey(entry.getKey()) + "]";
            if (!ClassUtils.isAssignable(mapValueType, entry.getValue().getClass())) {
                throw new MappingException(String.format(INVALID_TYPE_ASSIGNMENT, entry.getValue().getClass(), currentPath, mapValueType));
            }
            if (this.customConversions.hasCustomWriteTarget(entry.getValue().getClass())) {
                this.writeToBucket(currentPath, entry.getValue(), sink, mapValueType);
                continue;
            }
            this.writeInternal(keyspace, currentPath, entry.getValue(), (TypeInformation<?>)ClassTypeInformation.from(mapValueType), sink);
        }
    }

    private String mapMapKey(Object key) {
        if (this.conversionService.canConvert(key.getClass(), byte[].class)) {
            return new String((byte[])this.conversionService.convert(key, byte[].class));
        }
        return (String)this.conversionService.convert(key, String.class);
    }

    private Map<?, ?> readMapOfSimpleTypes(String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Bucket partial = source.getBucket().extract(path + ".[");
        Map target = CollectionFactory.createMap(mapType, (int)partial.size());
        for (Map.Entry<String, byte[]> entry : partial.entrySet()) {
            if (entry.getKey().endsWith(TYPE_HINT_ALIAS)) continue;
            Object key = this.extractMapKeyForPath(path, entry.getKey(), keyType);
            Class<?> typeToUse = this.getTypeHint(path + ".[" + key + "]", source.getBucket(), valueType);
            target.put(key, this.fromBytes(entry.getValue(), typeToUse));
        }
        return target.isEmpty() ? null : target;
    }

    private Map<?, ?> readMapOfComplexTypes(String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Set<String> keys = source.getBucket().extractAllKeysFor(path);
        Map target = CollectionFactory.createMap(mapType, (int)keys.size());
        for (String key : keys) {
            Bucket partial = source.getBucket().extract(key);
            byte[] typeInfo = partial.get(key + "." + TYPE_HINT_ALIAS);
            if (typeInfo != null && typeInfo.length > 0) {
                partial.put(TYPE_HINT_ALIAS, typeInfo);
            }
            Object value = this.readInternal(key, valueType, new RedisData(partial));
            Object mapKey = this.extractMapKeyForPath(path, key, keyType);
            target.put(mapKey, value);
        }
        return target.isEmpty() ? null : target;
    }

    private Object extractMapKeyForPath(String path, String key, Class<?> targetType) {
        String regex = "^(" + Pattern.quote(path) + "\\.\\[)(.*?)(\\])";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(key);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Cannot extract map value for key '%s' in path '%s'.", key, path));
        }
        String mapKey = matcher.group(2);
        if (ClassUtils.isAssignable(targetType, mapKey.getClass())) {
            return mapKey;
        }
        return this.conversionService.convert((Object)this.toBytes(mapKey), targetType);
    }

    private Class<?> getTypeHint(String path, Bucket bucket, Class<?> fallback) {
        byte[] typeInfo = bucket.get(path + "." + TYPE_HINT_ALIAS);
        if (typeInfo == null || typeInfo.length < 1) {
            return fallback;
        }
        String typeName = this.fromBytes(typeInfo, String.class);
        try {
            return ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MappingException(String.format("Cannot find class for type %s. ", typeName), (Throwable)e);
        }
        catch (LinkageError e) {
            throw new MappingException(String.format("Cannot find class for type %s. ", typeName), (Throwable)e);
        }
    }

    public byte[] toBytes(Object source) {
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return (byte[])this.conversionService.convert(source, byte[].class);
    }

    public <T> T fromBytes(byte[] source, Class<T> type) {
        return (T)this.conversionService.convert((Object)source, type);
    }

    private Object toArray(Collection<Object> source, Class<?> arrayType, Class<?> valueType) {
        if (source.isEmpty()) {
            return null;
        }
        if (!ClassUtils.isPrimitiveArray(arrayType)) {
            return source.toArray((Object[])Array.newInstance(valueType, source.size()));
        }
        Object targetArray = Array.newInstance(valueType, source.size());
        Iterator<Object> iterator = source.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Array.set(targetArray, i, this.conversionService.convert(iterator.next(), valueType));
            ++i;
        }
        return i > 0 ? targetArray : null;
    }

    public void setCustomConversions(CustomConversions customConversions) {
        this.customConversions = customConversions != null ? customConversions : new CustomConversions();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setIndexResolver(IndexResolver indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Override
    public RedisMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        this.customConversions.registerConvertersIn(this.conversionService);
    }

    public static class BinaryKeyspaceIdentifier {
        public static final byte[] PHANTOM = "phantom".getBytes();
        public static final byte DELIMITTER = 58;
        public static final byte[] PHANTOM_SUFFIX = ByteUtils.concat(new byte[]{58}, PHANTOM);
        private byte[] keyspace;
        private byte[] id;
        private boolean phantomKey;

        public static BinaryKeyspaceIdentifier of(byte[] key) {
            Assert.isTrue((boolean)BinaryKeyspaceIdentifier.isValid(key), (String)String.format("Invalid key %s", new String(key)));
            boolean phantomKey = ByteUtils.startsWith(key, PHANTOM_SUFFIX, key.length - PHANTOM_SUFFIX.length);
            int keyspaceEndIndex = ByteUtils.indexOf(key, (byte)58);
            byte[] keyspace = BinaryKeyspaceIdentifier.extractKeyspace(key, keyspaceEndIndex);
            byte[] id = BinaryKeyspaceIdentifier.extractId(key, phantomKey, keyspaceEndIndex);
            return new BinaryKeyspaceIdentifier(keyspace, id, phantomKey);
        }

        public static boolean isValid(byte[] key) {
            if (key == null) {
                return false;
            }
            int keyspaceEndIndex = ByteUtils.indexOf(key, (byte)58);
            return keyspaceEndIndex > 0 && key.length > keyspaceEndIndex;
        }

        private static byte[] extractId(byte[] key, boolean phantomKey, int keyspaceEndIndex) {
            int idSize = phantomKey ? key.length - PHANTOM_SUFFIX.length - (keyspaceEndIndex + 1) : key.length - (keyspaceEndIndex + 1);
            byte[] id = new byte[idSize];
            System.arraycopy(key, keyspaceEndIndex + 1, id, 0, idSize);
            return id;
        }

        private static byte[] extractKeyspace(byte[] key, int keyspaceEndIndex) {
            byte[] keyspace = new byte[keyspaceEndIndex];
            System.arraycopy(key, 0, keyspace, 0, keyspaceEndIndex);
            return keyspace;
        }

        private BinaryKeyspaceIdentifier(byte[] keyspace, byte[] id, boolean phantomKey) {
            this.keyspace = keyspace;
            this.id = id;
            this.phantomKey = phantomKey;
        }

        public byte[] getKeyspace() {
            return this.keyspace;
        }

        public byte[] getId() {
            return this.id;
        }

        public boolean isPhantomKey() {
            return this.phantomKey;
        }
    }

    public static class KeyspaceIdentifier {
        public static final String PHANTOM = "phantom";
        public static final String DELIMITTER = ":";
        public static final String PHANTOM_SUFFIX = ":phantom";
        private String keyspace;
        private String id;
        private boolean phantomKey;

        public static KeyspaceIdentifier of(String key) {
            Assert.isTrue((boolean)KeyspaceIdentifier.isValid(key), (String)String.format("Invalid key %s", key));
            boolean phantomKey = key.endsWith(PHANTOM_SUFFIX);
            int keyspaceEndIndex = key.indexOf(DELIMITTER);
            String keyspace = key.substring(0, keyspaceEndIndex);
            String id = phantomKey ? key.substring(keyspaceEndIndex + 1, key.length() - PHANTOM_SUFFIX.length()) : key.substring(keyspaceEndIndex + 1);
            return new KeyspaceIdentifier(keyspace, id, phantomKey);
        }

        public static boolean isValid(String key) {
            if (key == null) {
                return false;
            }
            int keyspaceEndIndex = key.indexOf(DELIMITTER);
            return keyspaceEndIndex > 0 && key.length() > keyspaceEndIndex;
        }

        private KeyspaceIdentifier(String keyspace, String id, boolean phantomKey) {
            this.keyspace = keyspace;
            this.id = id;
            this.phantomKey = phantomKey;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getId() {
            return this.id;
        }

        public boolean isPhantomKey() {
            return this.phantomKey;
        }
    }

    private static enum NaturalOrderingKeyComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String s1, String s2) {
            Part thatPart;
            Part thisPart;
            int s1offset = 0;
            for (int s2offset = 0; s1offset < s1.length() && s2offset < s2.length(); s1offset += thisPart.length(), s2offset += thatPart.length()) {
                thisPart = this.extractPart(s1, s1offset);
                int result = thisPart.compareTo(thatPart = this.extractPart(s2, s2offset));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private Part extractPart(String source, int offset) {
            StringBuilder builder = new StringBuilder();
            char c = source.charAt(offset);
            builder.append(c);
            boolean isDigit = Character.isDigit(c);
            for (int i = offset + 1; i < source.length(); ++i) {
                c = source.charAt(i);
                if (isDigit && !Character.isDigit(c) || !isDigit && Character.isDigit(c)) break;
                builder.append(c);
            }
            return new Part(builder.toString(), isDigit);
        }

        private static class Part
        implements Comparable<Part> {
            private final String rawValue;
            private final Long longValue;

            Part(String value, boolean isDigit) {
                this.rawValue = value;
                this.longValue = isDigit ? Long.valueOf(value) : null;
            }

            boolean isNumeric() {
                return this.longValue != null;
            }

            int length() {
                return this.rawValue.length();
            }

            @Override
            public int compareTo(Part that) {
                if (this.isNumeric() && that.isNumeric()) {
                    return this.longValue.compareTo(that.longValue);
                }
                return this.rawValue.compareTo(that.rawValue);
            }
        }
    }

    static enum ClassNameKeySpaceResolver implements KeySpaceResolver
    {
        INSTANCE;


        public String resolveKeySpace(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return ClassUtils.getUserClass(type).getName();
        }
    }

    private static class RedisTypeAliasAccessor
    implements TypeAliasAccessor<RedisData> {
        private final String typeKey;
        private final ConversionService conversionService;

        RedisTypeAliasAccessor(ConversionService conversionService) {
            this(conversionService, MappingRedisConverter.TYPE_HINT_ALIAS);
        }

        RedisTypeAliasAccessor(ConversionService conversionService, String typeKey) {
            this.conversionService = conversionService;
            this.typeKey = typeKey;
        }

        public Object readAliasFrom(RedisData source) {
            return this.conversionService.convert((Object)source.getBucket().get(this.typeKey), String.class);
        }

        public void writeTypeTo(RedisData sink, Object alias) {
            sink.getBucket().put(this.typeKey, (byte[])this.conversionService.convert(alias, byte[].class));
        }
    }

    private static class ConverterAwareParameterValueProvider
    implements PropertyValueProvider<KeyValuePersistentProperty> {
        private final String path;
        private final RedisData source;
        private final ConversionService conversionService;

        public ConverterAwareParameterValueProvider(String path, RedisData source, ConversionService conversionService) {
            this.path = path;
            this.source = source;
            this.conversionService = conversionService;
        }

        public <T> T getPropertyValue(KeyValuePersistentProperty property) {
            String name = StringUtils.hasText((String)this.path) ? this.path + "." + property.getName() : property.getName();
            return (T)this.conversionService.convert((Object)this.source.getBucket().get(name), property.getActualType());
        }
    }
}

