/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jredis.ClientRuntimeException;
import org.jredis.JRedis;
import org.jredis.Query;
import org.jredis.RedisException;
import org.jredis.Sort;
import org.jredis.connector.ConnectionException;
import org.jredis.connector.NotConnectedException;
import org.jredis.protocol.Command;
import org.jredis.ri.alphazero.JRedisSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.Pool;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.jredis.JredisUtils;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class JredisConnection
extends AbstractRedisConnection {
    private static final Method SERVICE_REQUEST = ReflectionUtils.findMethod(JRedisSupport.class, (String)"serviceRequest", (Class[])new Class[]{Command.class, byte[][].class});
    private final JRedis jredis;
    private final Pool<JRedis> pool;
    private boolean isClosed = false;
    private boolean broken = false;

    public JredisConnection(JRedis jredis) {
        this(jredis, null);
    }

    public JredisConnection(JRedis jredis, Pool<JRedis> pool) {
        Assert.notNull((Object)jredis, (String)"a not-null instance required");
        this.jredis = jredis;
        this.pool = pool;
    }

    protected DataAccessException convertJredisAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return JredisUtils.convertJredisAccessException((RedisException)ex);
        }
        if (ex instanceof ClientRuntimeException) {
            if (ex instanceof NotConnectedException || ex instanceof ConnectionException) {
                this.broken = true;
            }
            return JredisUtils.convertJredisAccessException((ClientRuntimeException)ex);
        }
        return new RedisSystemException("Unknown JRedis exception", ex);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            ArrayList mArgs = new ArrayList();
            if (!ObjectUtils.isEmpty((Object[])args)) {
                Collections.addAll(mArgs, args);
            }
            return ReflectionUtils.invokeMethod((Method)SERVICE_REQUEST, (Object)this.jredis, (Object[])new Object[]{Command.valueOf((String)command.trim().toUpperCase()), mArgs.toArray((T[])new byte[mArgs.size()][])});
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void close() throws RedisSystemException {
        super.close();
        if (this.isClosed()) {
            return;
        }
        this.isClosed = true;
        if (this.pool != null) {
            if (!this.broken) {
                this.pool.returnResource(this.jredis);
            } else {
                this.pool.returnBrokenResource(this.jredis);
            }
            return;
        }
        try {
            this.jredis.quit();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    public JRedis getNativeConnection() {
        return this.jredis;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isQueueing() {
        return false;
    }

    @Override
    public boolean isPipelined() {
        return false;
    }

    @Override
    public void openPipeline() {
        throw new UnsupportedOperationException("Pipelining not supported by JRedis");
    }

    @Override
    public List<Object> closePipeline() {
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Sort sort = this.jredis.sort((Object)key);
        JredisUtils.applySortingParams(sort, params, null);
        try {
            return sort.exec();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Sort sort = this.jredis.sort((Object)key);
        JredisUtils.applySortingParams(sort, params, storeKey);
        try {
            return Query.Support.unpackValue((List)sort.exec());
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            return this.jredis.dbsize();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            this.jredis.flushdb();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            this.jredis.flushall();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            return this.jredis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            this.jredis.ping();
            return "PONG";
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            this.jredis.bgsave();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void bgReWriteAof() {
        try {
            this.jredis.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    @Deprecated
    public void bgWriteAof() {
        this.bgReWriteAof();
    }

    @Override
    public void save() {
        try {
            this.jredis.save();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties info() {
        try {
            return JredisUtils.info(this.jredis.info());
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long lastSave() {
        try {
            return this.jredis.lastsave();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetConfigStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            return this.jredis.del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            this.jredis.discard();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            return this.jredis.exists((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            return this.jredis.expire((Object)key, (int)seconds);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            return this.jredis.expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long pTtl(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] dump(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.keys((Object)pattern));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void multi() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean persist(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            return this.jredis.move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            return this.jredis.randomkey();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            this.jredis.rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            return this.jredis.renamenx((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            return this.jredis.ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            return JredisUtils.convertDataType(this.jredis.type((Object)key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.jredis.get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            this.jredis.set((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        throw new UnsupportedOperationException("SET with options is not supported for JRedis. Please use SETNX, SETEX, PSETEX.");
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            return this.jredis.getset((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            return this.jredis.append((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            return this.jredis.mget((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuple) {
        try {
            this.jredis.mset(tuple);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        try {
            return this.jredis.msetnx(tuple);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            return this.jredis.setnx((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            return this.jredis.substr((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            return this.jredis.decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            return this.jredis.decrby((Object)key, (int)value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            return this.jredis.incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            return this.jredis.incrby((Object)key, (int)value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            return this.jredis.getbit((Object)key, (int)offset);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            return this.jredis.setbit((Object)key, (int)offset, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long strLen(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long bitCount(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            return this.jredis.lindex((Object)key, index);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            return this.jredis.llen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            return this.jredis.lpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        if (values.length > 1) {
            throw new UnsupportedOperationException("lPush of multiple fields not supported");
        }
        try {
            this.jredis.lpush((Object)key, values[0]);
            return null;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            List lrange = this.jredis.lrange((Object)key, start, end);
            return lrange;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            return this.jredis.lrem((Object)key, value, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            this.jredis.lset((Object)key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            this.jredis.ltrim((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            return this.jredis.rpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            return this.jredis.rpoplpush((Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        if (values.length > 1) {
            throw new UnsupportedOperationException("rPush of multiple fields not supported");
        }
        try {
            this.jredis.rpush((Object)key, values[0]);
            return null;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        if (values.length > 1) {
            throw new UnsupportedOperationException("sAdd of multiple fields not supported");
        }
        try {
            return JredisUtils.toLong(this.jredis.sadd((Object)key, values[0]));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            return this.jredis.scard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        byte[] destKey = keys[0];
        byte[][] sets = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        try {
            List result = this.jredis.sdiff((Object)destKey, (Object[])sets);
            return new LinkedHashSet<byte[]>(result);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            this.jredis.sdiffstore((Object)destKey, (Object[])keys);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        byte[] set1 = keys[0];
        byte[][] sets = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        try {
            List result = this.jredis.sinter((Object)set1, (Object[])sets);
            return new LinkedHashSet<byte[]>(result);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            this.jredis.sinterstore((Object)destKey, (Object[])keys);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            return this.jredis.sismember((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.smembers((Object)key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            return this.jredis.smove((Object)srcKey, (Object)destKey, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            return this.jredis.spop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            return this.jredis.srandmember((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        if (values.length > 1) {
            throw new UnsupportedOperationException("sRem of multiple fields not supported");
        }
        try {
            return JredisUtils.toLong(this.jredis.srem((Object)key, values[0]));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        byte[] set1 = keys[0];
        byte[][] sets = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        try {
            return new LinkedHashSet<byte[]>(this.jredis.sunion((Object)set1, (Object[])sets));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            this.jredis.sunionstore((Object)destKey, (Object[])keys);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            return this.jredis.zadd((Object)key, score, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            return this.jredis.zcard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)range, (String)"Range for ZCOUNT must not be null!");
        double min = (Double)range.getMin().getValue();
        double max = (Double)range.getMax().getValue();
        try {
            return this.jredis.zcount((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            return this.jredis.zincrby((Object)key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrangebyscore((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            return this.jredis.zrank((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        if (values.length > 1) {
            throw new UnsupportedOperationException("zRem of multiple fields not supported");
        }
        try {
            return JredisUtils.toLong(this.jredis.zrem((Object)key, values[0]));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            return this.jredis.zremrangebyrank((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            return this.jredis.zremrangebyscore((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrevrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            return this.jredis.zrevrank((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            return this.jredis.zscore((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        if (fields.length > 1) {
            throw new UnsupportedOperationException("hDel of multiple fields not supported");
        }
        try {
            return JredisUtils.toLong(this.jredis.hdel((Object)key, (Object)fields[0]));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            return this.jredis.hexists((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            return this.jredis.hget((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            return this.jredis.hgetall((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.hkeys((Object)key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            return this.jredis.hlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            return this.jredis.hset((Object)key, (Object)field, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            return this.jredis.hvals((Object)key);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return null;
    }

    @Override
    public boolean isSubscribed() {
        return false;
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scriptFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scriptKill() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String scriptLoad(byte[] script) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long time() {
        throw new UnsupportedOperationException("The 'TIME' command is not supported by the JRedis driver.");
    }

    @Override
    public void killClient(String host, int port) {
        throw new UnsupportedOperationException("The 'CLIENT KILL' command is not supported by the JRedis driver.");
    }

    @Override
    public void setClientName(byte[] name) {
        throw new UnsupportedOperationException("'CLIENT SETNAME' is not supported by the JRedis driver.");
    }

    @Override
    public void slaveOf(String host, int port) {
        try {
            this.jredis.slaveof(host, port);
        }
        catch (Exception e) {
            throw this.convertJredisAccessException(e);
        }
    }

    @Override
    public String getClientName() {
        throw new UnsupportedOperationException("The 'CLIENT GETNAME' command is not supported by the JRedis driver.");
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void slaveOfNoOne() {
        try {
            this.jredis.slaveofnone();
        }
        catch (Exception e) {
            throw this.convertJredisAccessException(e);
        }
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        throw new UnsupportedOperationException("'SCAN' command is not supported for jredis.");
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'ZSCAN' command is not supported for jredis.");
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'SSCAN' command is not uspported for jredis");
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'HSCAN' command is not uspported for jredis");
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        throw new UnsupportedOperationException("'zRangeByScore' command is not uspported for jredis");
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        throw new UnsupportedOperationException("'zRangeByScore' command is not uspported for jredis");
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for jredis.");
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for jredis.");
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for jredis.");
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        throw new UnsupportedOperationException();
    }

    static {
        ReflectionUtils.makeAccessible((Method)SERVICE_REQUEST);
    }
}

