/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.convert.BinaryConverters;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.util.Assert;

public class ReferenceResolverImpl
implements ReferenceResolver {
    private final RedisOperations<?, ?> redisOps;
    private final BinaryConverters.StringToBytesConverter converter;

    public ReferenceResolverImpl(RedisOperations<?, ?> redisOperations) {
        Assert.notNull(redisOperations);
        this.redisOps = redisOperations;
        this.converter = new BinaryConverters.StringToBytesConverter();
    }

    @Override
    public Map<byte[], byte[]> resolveReference(Serializable id, String keyspace) {
        final byte[] key = this.converter.convert(keyspace + ":" + id);
        return this.redisOps.execute(new RedisCallback<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.hGetAll(key);
            }
        });
    }
}

