/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.IndexWriter;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisQueryEngine;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.convert.CustomConversions;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class RedisKeyValueAdapter
extends AbstractKeyValueAdapter
implements InitializingBean,
ApplicationContextAware,
ApplicationListener<RedisKeyspaceEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisKeyValueAdapter.class);
    private RedisOperations<?, ?> redisOps;
    private RedisConverter converter;
    private RedisMessageListenerContainer messageListenerContainer;
    private final AtomicReference<KeyExpirationEventMessageListener> expirationListener = new AtomicReference<Object>(null);
    private ApplicationEventPublisher eventPublisher;
    private EnableKeyspaceEvents enableKeyspaceEvents = EnableKeyspaceEvents.OFF;

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps) {
        this(redisOps, new RedisMappingContext());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext) {
        this(redisOps, mappingContext, new CustomConversions());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext, CustomConversions customConversions) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        Assert.notNull((Object)((Object)mappingContext), (String)"RedisMappingContext must not be null!");
        MappingRedisConverter mappingConverter = new MappingRedisConverter(mappingContext, new PathIndexResolver(mappingContext), new ReferenceResolverImpl(redisOps));
        mappingConverter.setCustomConversions(customConversions == null ? new CustomConversions() : customConversions);
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
        this.redisOps = redisOps;
        this.initMessageListenerContainer();
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisConverter redisConverter) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        this.converter = redisConverter;
        this.redisOps = redisOps;
        this.initMessageListenerContainer();
    }

    protected RedisKeyValueAdapter() {
    }

    public Object put(Serializable id, Object item, Serializable keyspace) {
        RedisData rdo;
        RedisData redisData = rdo = item instanceof RedisData ? (RedisData)item : new RedisData();
        if (!(item instanceof RedisData)) {
            this.converter.write(item, rdo);
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_DEMAND), (Object)((Object)this.enableKeyspaceEvents)) && this.expirationListener.get() == null && rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
            this.initKeyExpirationListener();
        }
        if (rdo.getId() == null) {
            rdo.setId((String)this.converter.getConversionService().convert((Object)id, String.class));
            if (!(item instanceof RedisData)) {
                KeyValuePersistentProperty idProperty = (KeyValuePersistentProperty)((KeyValuePersistentEntity)this.converter.getMappingContext().getPersistentEntity(item.getClass())).getIdProperty();
                ((KeyValuePersistentEntity)this.converter.getMappingContext().getPersistentEntity(item.getClass())).getPropertyAccessor(item).setProperty((PersistentProperty)idProperty, (Object)id);
            }
        }
        this.redisOps.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] key = RedisKeyValueAdapter.this.toBytes(rdo.getId());
                byte[] objectKey = RedisKeyValueAdapter.this.createKey(rdo.getKeyspace(), rdo.getId());
                boolean isNew = connection.del(new byte[][]{objectKey}) == 0L;
                connection.hMSet(objectKey, rdo.getBucket().rawMap());
                if (rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
                    connection.expire(objectKey, rdo.getTimeToLive());
                    byte[] phantomKey = ByteUtils.concat(objectKey, RedisKeyValueAdapter.this.toBytes(":phantom"));
                    connection.del(new byte[][]{phantomKey});
                    connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                    connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                }
                connection.sAdd(RedisKeyValueAdapter.this.toBytes(rdo.getKeyspace()), new byte[][]{key});
                IndexWriter indexWriter = new IndexWriter(connection, RedisKeyValueAdapter.this.converter);
                if (isNew) {
                    indexWriter.createIndexes(key, rdo.getIndexedData());
                } else {
                    indexWriter.updateIndexes(key, rdo.getIndexedData());
                }
                return null;
            }
        });
        return item;
    }

    public boolean contains(final Serializable id, final Serializable keyspace) {
        Boolean exists = this.redisOps.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sIsMember(RedisKeyValueAdapter.this.toBytes(keyspace), RedisKeyValueAdapter.this.toBytes(id));
            }
        });
        return exists != null ? exists : false;
    }

    public Object get(Serializable id, Serializable keyspace) {
        return this.get(id, keyspace, Object.class);
    }

    public <T> T get(Serializable id, Serializable keyspace, Class<T> type) {
        String stringId = this.asString(id);
        String stringKeyspace = this.asString(keyspace);
        final byte[] binId = this.createKey(stringKeyspace, stringId);
        Map<byte[], byte[]> raw = this.redisOps.execute(new RedisCallback<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.hGetAll(binId);
            }
        });
        RedisData data = new RedisData(raw);
        data.setId(stringId);
        data.setKeyspace(stringKeyspace);
        return (T)this.converter.read(type, data);
    }

    public Object delete(Serializable id, Serializable keyspace) {
        return this.delete(id, keyspace, Object.class);
    }

    public <T> T delete(Serializable id, final Serializable keyspace, Class<T> type) {
        final byte[] binId = this.toBytes(id);
        final byte[] binKeyspace = this.toBytes(keyspace);
        T o = this.get(id, keyspace, type);
        if (o != null) {
            final byte[] keyToDelete = this.createKey(this.asString(keyspace), this.asString(id));
            this.redisOps.execute(new RedisCallback<Void>(){

                @Override
                public Void doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.del(new byte[][]{keyToDelete});
                    connection.sRem(binKeyspace, new byte[][]{binId});
                    new IndexWriter(connection, RedisKeyValueAdapter.this.converter).removeKeyFromIndexes(RedisKeyValueAdapter.this.asString(keyspace), binId);
                    return null;
                }
            });
        }
        return o;
    }

    public List<?> getAllOf(final Serializable keyspace) {
        final byte[] binKeyspace = this.toBytes(keyspace);
        List<Map<byte[], byte[]>> raw = this.redisOps.execute(new RedisCallback<List<Map<byte[], byte[]>>>(){

            @Override
            public List<Map<byte[], byte[]>> doInRedis(RedisConnection connection) throws DataAccessException {
                ArrayList<Map<byte[], byte[]>> rawData = new ArrayList<Map<byte[], byte[]>>();
                Set<byte[]> members = connection.sMembers(binKeyspace);
                for (byte[] id : members) {
                    rawData.add(connection.hGetAll(RedisKeyValueAdapter.this.createKey(RedisKeyValueAdapter.this.asString(keyspace), (String)RedisKeyValueAdapter.this.getConverter().getConversionService().convert((Object)id, String.class))));
                }
                return rawData;
            }
        });
        ArrayList<Object> result = new ArrayList<Object>(raw.size());
        for (Map<byte[], byte[]> rawData : raw) {
            result.add(this.converter.read(Object.class, new RedisData(rawData)));
        }
        return result;
    }

    public void deleteAllOf(final Serializable keyspace) {
        this.redisOps.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.del(new byte[][]{RedisKeyValueAdapter.this.toBytes(keyspace)});
                new IndexWriter(connection, RedisKeyValueAdapter.this.converter).removeAllIndexes(RedisKeyValueAdapter.this.asString(keyspace));
                return null;
            }
        });
    }

    public CloseableIterator<Map.Entry<Serializable, Object>> entries(Serializable keyspace) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public long count(final Serializable keyspace) {
        Long count = this.redisOps.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sCard(RedisKeyValueAdapter.this.toBytes(keyspace));
            }
        });
        return count != null ? count : 0L;
    }

    public <T> T execute(RedisCallback<T> callback) {
        return this.redisOps.execute(callback);
    }

    public RedisConverter getConverter() {
        return this.converter;
    }

    public void clear() {
    }

    private String asString(Serializable value) {
        return value instanceof String ? (String)((Object)value) : (String)this.getConverter().getConversionService().convert((Object)value, String.class);
    }

    public byte[] createKey(String keyspace, String id) {
        return this.toBytes(keyspace + ":" + id);
    }

    public byte[] toBytes(Object source) {
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return (byte[])this.converter.getConversionService().convert(source, byte[].class);
    }

    public void setEnableKeyspaceEvents(EnableKeyspaceEvents enableKeyspaceEvents) {
        this.enableKeyspaceEvents = enableKeyspaceEvents;
    }

    public void afterPropertiesSet() {
        if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_STARTUP), (Object)((Object)this.enableKeyspaceEvents))) {
            this.initKeyExpirationListener();
        }
    }

    public void destroy() throws Exception {
        if (this.expirationListener.get() != null) {
            this.expirationListener.get().destroy();
        }
        if (this.messageListenerContainer != null) {
            this.messageListenerContainer.destroy();
        }
    }

    public void onApplicationEvent(RedisKeyspaceEvent event) {
        LOGGER.debug("Received %s .", (Object)event);
        if (event instanceof RedisKeyExpiredEvent) {
            final RedisKeyExpiredEvent expiredEvent = (RedisKeyExpiredEvent)event;
            this.redisOps.execute(new RedisCallback<Void>(){

                @Override
                public Void doInRedis(RedisConnection connection) throws DataAccessException {
                    LOGGER.debug("Cleaning up expired key '%s' data structures in keyspace '%s'.", (Object)expiredEvent.getSource(), (Object)expiredEvent.getKeyspace());
                    connection.sRem(RedisKeyValueAdapter.this.toBytes(expiredEvent.getKeyspace()), new byte[][]{expiredEvent.getId()});
                    new IndexWriter(connection, RedisKeyValueAdapter.this.converter).removeKeyFromIndexes(expiredEvent.getKeyspace(), expiredEvent.getId());
                    return null;
                }
            });
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    private void initMessageListenerContainer() {
        this.messageListenerContainer = new RedisMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(((RedisTemplate)this.redisOps).getConnectionFactory());
        this.messageListenerContainer.afterPropertiesSet();
        this.messageListenerContainer.start();
    }

    private void initKeyExpirationListener() {
        if (this.expirationListener.get() == null) {
            MappingExpirationListener listener = new MappingExpirationListener(this.messageListenerContainer, this.redisOps, this.converter);
            if (this.eventPublisher != null) {
                listener.setApplicationEventPublisher(this.eventPublisher);
            }
            if (this.expirationListener.compareAndSet(null, listener)) {
                listener.init();
            }
        }
    }

    public static enum EnableKeyspaceEvents {
        ON_STARTUP,
        ON_DEMAND,
        OFF;

    }

    static class MappingExpirationListener
    extends KeyExpirationEventMessageListener {
        private final RedisOperations<?, ?> ops;
        private final RedisConverter converter;

        public MappingExpirationListener(RedisMessageListenerContainer listenerContainer, RedisOperations<?, ?> ops, RedisConverter converter) {
            super(listenerContainer);
            this.ops = ops;
            this.converter = converter;
        }

        @Override
        public void onMessage(Message message, byte[] pattern) {
            if (!this.isKeyExpirationMessage(message)) {
                return;
            }
            byte[] key = message.getBody();
            final byte[] phantomKey = ByteUtils.concat(key, (byte[])this.converter.getConversionService().convert((Object)":phantom", byte[].class));
            Map<byte[], byte[]> hash = this.ops.execute(new RedisCallback<Map<byte[], byte[]>>(){

                @Override
                public Map<byte[], byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                    Map<byte[], byte[]> hash = connection.hGetAll(phantomKey);
                    if (!CollectionUtils.isEmpty(hash)) {
                        connection.del(new byte[][]{phantomKey});
                    }
                    return hash;
                }
            });
            Object value = this.converter.read(Object.class, new RedisData(hash));
            this.publishEvent(new RedisKeyExpiredEvent(key, value));
        }

        private boolean isKeyExpirationMessage(Message message) {
            if (message == null || message.getChannel() == null || message.getBody() == null) {
                return false;
            }
            byte[][] args = ByteUtils.split(message.getBody(), 58);
            return args.length == 2;
        }
    }
}

