/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.atomic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

public class RedisAtomicDouble
extends Number
implements Serializable,
BoundKeyOperations<String> {
    private static final long serialVersionUID = 1L;
    private volatile String key;
    private ValueOperations<String, Double> operations;
    private RedisOperations<String, Double> generalOps;

    public RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory) {
        this(redisCounter, factory, null);
    }

    public RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory, double initialValue) {
        this(redisCounter, factory, (Double)initialValue);
    }

    private RedisAtomicDouble(String redisCounter, RedisConnectionFactory factory, Double initialValue) {
        Assert.hasText((String)redisCounter, (String)"a valid counter name is required");
        Assert.notNull((Object)factory, (String)"a valid factory is required");
        RedisTemplate<String, Double> redisTemplate = new RedisTemplate<String, Double>();
        redisTemplate.setKeySerializer(new StringRedisSerializer());
        redisTemplate.setValueSerializer(new GenericToStringSerializer<Double>(Double.class));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.afterPropertiesSet();
        this.key = redisCounter;
        this.generalOps = redisTemplate;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            if (this.operations.get(redisCounter) == null) {
                this.set(0.0);
            }
        } else {
            this.set(initialValue);
        }
    }

    public RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template) {
        this(redisCounter, template, null);
    }

    public RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template, double initialValue) {
        this(redisCounter, template, (Double)initialValue);
    }

    private RedisAtomicDouble(String redisCounter, RedisOperations<String, Double> template, Double initialValue) {
        Assert.hasText((String)redisCounter, (String)"a valid counter name is required");
        Assert.notNull(template, (String)"a valid template is required");
        Assert.notNull(template.getKeySerializer(), (String)"a valid key serializer in template is required");
        Assert.notNull(template.getValueSerializer(), (String)"a valid value serializer in template is required");
        this.key = redisCounter;
        this.generalOps = template;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            if (this.operations.get(redisCounter) == null) {
                this.set(0.0);
            }
        } else {
            this.set(initialValue);
        }
    }

    public double get() {
        return this.operations.get(this.key);
    }

    public void set(double newValue) {
        this.operations.set(this.key, newValue);
    }

    public double getAndSet(double newValue) {
        return this.operations.getAndSet(this.key, newValue);
    }

    public boolean compareAndSet(final double expect, final double update) {
        return this.generalOps.execute(new SessionCallback<Boolean>(){

            @Override
            public Boolean execute(RedisOperations operations) {
                operations.watch(Collections.singleton(RedisAtomicDouble.this.key));
                if (expect == RedisAtomicDouble.this.get()) {
                    RedisAtomicDouble.this.generalOps.multi();
                    RedisAtomicDouble.this.set(update);
                    if (operations.exec() != null) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public double getAndIncrement() {
        return this.incrementAndGet() - 1.0;
    }

    public double getAndDecrement() {
        return this.decrementAndGet() + 1.0;
    }

    public double getAndAdd(double delta) {
        return this.addAndGet(delta) - delta;
    }

    public double incrementAndGet() {
        return this.operations.increment(this.key, 1.0);
    }

    public double decrementAndGet() {
        return this.operations.increment(this.key, -1.0);
    }

    public double addAndGet(double delta) {
        return this.operations.increment(this.key, delta);
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    @Override
    public Long getExpire() {
        return this.generalOps.getExpire(this.key);
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.generalOps.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.generalOps.expireAt(this.key, date);
    }

    @Override
    public Boolean persist() {
        return this.generalOps.persist(this.key);
    }

    @Override
    public void rename(String newKey) {
        this.generalOps.rename(this.key, newKey);
        this.key = newKey;
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }
}

