/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisVersionUtil;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.util.Pool;

public class JedisConnection
extends AbstractRedisConnection {
    private static final Field CLIENT_FIELD;
    private static final Method SEND_COMMAND;
    private static final Method GET_RESPONSE;
    private static final String SHUTDOWN_SCRIPT = "return redis.call('SHUTDOWN','%s')";
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION;
    private final Jedis jedis;
    private final Client client;
    private final Transaction transaction;
    private final Pool<Jedis> pool;
    private boolean broken = false;
    private volatile JedisSubscription subscription;
    private volatile Pipeline pipeline;
    private final int dbIndex;
    private boolean convertPipelineAndTxResults = true;
    private List<FutureResult<Response<?>>> pipelinedResults = new ArrayList();
    private Queue<FutureResult<Response<?>>> txResults = new LinkedList();

    public JedisConnection(Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(Jedis jedis, Pool<Jedis> pool, int dbIndex) {
        this.jedis = jedis;
        this.client = (Client)ReflectionUtils.getField((Field)CLIENT_FIELD, (Object)jedis);
        this.transaction = new Transaction(this.client);
        this.pool = pool;
        this.dbIndex = dbIndex;
        if (dbIndex > 0) {
            try {
                this.select(dbIndex);
            }
            catch (DataAccessException ex) {
                this.close();
                throw ex;
            }
        }
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException exception;
        if (ex instanceof NullPointerException) {
            this.broken = true;
        }
        if ((exception = EXCEPTION_TRANSLATION.translate(ex)) instanceof RedisConnectionFailureException) {
            this.broken = true;
        }
        return exception;
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            ArrayList mArgs = new ArrayList();
            if (!ObjectUtils.isEmpty((Object[])args)) {
                Collections.addAll(mArgs, args);
            }
            ReflectionUtils.invokeMethod((Method)SEND_COMMAND, (Object)this.client, (Object[])new Object[]{Protocol.Command.valueOf((String)command.trim().toUpperCase()), mArgs.toArray((T[])new byte[mArgs.size()][])});
            if (this.isQueueing() || this.isPipelined()) {
                Pipeline target = this.isPipelined() ? this.pipeline : this.transaction;
                Response result = (Response)ReflectionUtils.invokeMethod((Method)GET_RESPONSE, (Object)target, (Object[])new Object[]{new Builder<Object>(){

                    public Object build(Object data) {
                        return data;
                    }

                    public String toString() {
                        return "Object";
                    }
                }});
                if (this.isPipelined()) {
                    this.pipeline(new JedisResult(result));
                } else {
                    this.transaction(new JedisResult(result));
                }
                return null;
            }
            return this.client.getOne();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        if (this.pool != null) {
            if (!this.broken) {
                try {
                    if (this.dbIndex > 0) {
                        this.jedis.select(0);
                    }
                    this.pool.returnResource((Object)this.jedis);
                    return;
                }
                catch (Exception ex) {
                    DataAccessException dae = this.convertJedisAccessException(ex);
                    if (this.broken) {
                        this.pool.returnBrokenResource((Object)this.jedis);
                    } else {
                        this.pool.returnResource((Object)this.jedis);
                    }
                    throw dae;
                }
            }
            this.pool.returnBrokenResource((Object)this.jedis);
            return;
        }
        Exception exc = null;
        if (this.isQueueing()) {
            try {
                this.client.quit();
            }
            catch (Exception ex) {
                exc = ex;
            }
            try {
                this.client.disconnect();
            }
            catch (Exception ex) {
                exc = ex;
            }
            return;
        }
        try {
            this.jedis.quit();
        }
        catch (Exception ex) {
            exc = ex;
        }
        try {
            this.jedis.disconnect();
        }
        catch (Exception ex) {
            exc = ex;
        }
        if (exc != null) {
            throw this.convertJedisAccessException(exc);
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        try {
            return !this.jedis.isConnected();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public boolean isQueueing() {
        return this.client.isInMulti();
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> closePipeline() {
        if (this.pipeline != null) {
            try {
                List<Object> list = this.convertPipelineResults();
                return list;
            }
            finally {
                this.pipeline = null;
                this.pipelinedResults.clear();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> convertPipelineResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        this.pipeline.sync();
        DataAccessException cause = null;
        for (FutureResult<Response<?>> result : this.pipelinedResults) {
            try {
                Object data = result.get();
                if (this.convertPipelineAndTxResults && result.isStatus()) continue;
                results.add(data);
            }
            catch (JedisDataException e) {
                DataAccessException dataAccessException = this.convertJedisAccessException((Exception)((Object)e));
                if (cause == null) {
                    cause = dataAccessException;
                }
                results.add((Object)dataAccessException);
            }
            catch (DataAccessException e) {
                if (cause == null) {
                    cause = e;
                }
                results.add((Object)e);
            }
        }
        if (cause != null) {
            throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)results);
        }
        return results;
    }

    private void doPipelined(Response<?> response) {
        this.pipeline(new JedisStatusResult(response));
    }

    private void pipeline(FutureResult<Response<?>> result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.pipelinedResults.add(result);
        }
    }

    private void doQueued(Response<?> response) {
        this.transaction(new JedisStatusResult(response));
    }

    private void transaction(FutureResult<Response<?>> result) {
        this.txResults.add(result);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(new JedisResult(this.pipeline.sort(key, sortParams)));
                } else {
                    this.pipeline(new JedisResult(this.pipeline.sort(key)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(new JedisResult(this.transaction.sort(key, sortParams)));
                } else {
                    this.transaction(new JedisResult(this.transaction.sort(key)));
                }
                return null;
            }
            return sortParams != null ? this.jedis.sort(key, sortParams) : this.jedis.sort(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(new JedisResult(this.pipeline.sort(key, sortParams, storeKey)));
                } else {
                    this.pipeline(new JedisResult(this.pipeline.sort(key, storeKey)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(new JedisResult(this.transaction.sort(key, sortParams, storeKey)));
                } else {
                    this.transaction(new JedisResult(this.transaction.sort(key, storeKey)));
                }
                return null;
            }
            return sortParams != null ? this.jedis.sort(key, sortParams, storeKey) : this.jedis.sort(key, storeKey);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.dbSize()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.dbSize()));
                return null;
            }
            return this.jedis.dbSize();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.flushDB()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.flushDB()));
                return;
            }
            this.jedis.flushDB();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.flushAll()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.flushAll()));
                return;
            }
            this.jedis.flushAll();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.bgsave()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.bgsave()));
                return;
            }
            this.jedis.bgsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.bgrewriteaof()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.bgrewriteaof()));
                return;
            }
            this.jedis.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Deprecated
    public void bgWriteAof() {
        this.bgReWriteAof();
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.save()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.save()));
                return;
            }
            this.jedis.save();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.configGet(param)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.configGet(param)));
                return null;
            }
            return this.jedis.configGet(param);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.info(), JedisConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.info(), JedisConverters.stringToProps()));
                return null;
            }
            return JedisConverters.toProperties(this.jedis.info());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            return JedisConverters.toProperties(this.jedis.info(section));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lastsave()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lastsave()));
                return null;
            }
            return this.jedis.lastsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.configSet(param, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.configSet(param, value)));
                return;
            }
            this.jedis.configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.configResetStat()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.configResetStat()));
                return;
            }
            this.jedis.configResetStat();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.shutdown()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.shutdown()));
                return;
            }
            this.jedis.shutdown();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        this.eval(String.format(SHUTDOWN_SCRIPT, option.name()).getBytes(), ReturnType.STATUS, 0, new byte[0][]);
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.echo(message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.echo(message)));
                return null;
            }
            return this.jedis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.ping()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.ping()));
                return null;
            }
            return this.jedis.ping();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.del(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.del(keys)));
                return null;
            }
            return this.jedis.del(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.discard()));
                return;
            }
            this.transaction.discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.exec(), new TransactionResultConverter(new LinkedList(this.txResults), JedisConverters.exceptionConverter())));
                List<Object> list = null;
                return list;
            }
            List<Object> results = this.transaction.exec();
            List<Object> list = this.convertPipelineAndTxResults ? new TransactionResultConverter(this.txResults, JedisConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.exists(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.exists(key)));
                return null;
            }
            return this.jedis.exists(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        if (seconds > Integer.MAX_VALUE) {
            return this.pExpireAt(key, this.time() + TimeUnit.SECONDS.toMillis(seconds));
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.expire(key, (int)seconds));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.expireAt(key, unixTime));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.keys(pattern)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.keys(pattern)));
                return null;
            }
            return this.jedis.keys(pattern);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.pipeline.multi();
                return;
            }
            this.jedis.multi();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.persist(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.move(key, dbIndex));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.randomKeyBinary()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.randomKeyBinary()));
                return null;
            }
            return this.jedis.randomBinaryKey();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.rename(oldName, newName)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.rename(oldName, newName)));
                return;
            }
            this.jedis.rename(oldName, newName);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.renamenx(oldName, newName), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.renamenx(oldName, newName), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.renamenx(oldName, newName));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.select(dbIndex)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.select(dbIndex)));
                return;
            }
            this.jedis.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.ttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.ttl(key)));
                return null;
            }
            return this.jedis.ttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        if (millis > Integer.MAX_VALUE) {
            return this.pExpireAt(key, this.time() + millis);
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.pexpire(key, (int)millis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.pexpire(key, (int)millis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.pexpire(key, (int)millis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.pexpireAt(key, unixTimeInMillis));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.pttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.pttl(key)));
                return null;
            }
            return this.jedis.pttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.dump(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.dump(key)));
                return null;
            }
            return this.jedis.dump(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            this.jedis.restore(key, (int)ttlInMillis, serializedValue);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.type(key), JedisConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.type(key), JedisConverters.stringToDataType()));
                return null;
            }
            return JedisConverters.toDataType(this.jedis.type(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            this.jedis.unwatch();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            for (byte[] key : keys) {
                if (this.isPipelined()) {
                    this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.watch((byte[][])new byte[][]{key})));
                    continue;
                }
                this.jedis.watch((byte[][])new byte[][]{key});
            }
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.get(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.get(key)));
                return null;
            }
            return this.jedis.get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.set(key, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.set(key, value)));
                return;
            }
            this.jedis.set(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.getSet(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.getSet(key, value)));
                return null;
            }
            return this.jedis.getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.append(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.append(key, value)));
                return null;
            }
            return this.jedis.append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.mget(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.mget(keys)));
                return null;
            }
            return this.jedis.mget(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.mset(JedisConverters.toByteArrays(tuples))));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.mset(JedisConverters.toByteArrays(tuples))));
                return;
            }
            this.jedis.mset(JedisConverters.toByteArrays(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.msetnx(JedisConverters.toByteArrays(tuples)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.setex(key, (int)time, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.setex(key, (int)time, value)));
                return;
            }
            this.jedis.setex(key, (int)time, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.doPipelined(this.pipeline.psetex(key, (int)milliseconds, value));
                return;
            }
            if (this.isQueueing()) {
                this.doQueued(this.transaction.psetex(key, (int)milliseconds, value));
                return;
            }
            this.jedis.psetex(key, (int)milliseconds, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            return this.jedis.substr(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.decr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.decr(key)));
                return null;
            }
            return this.jedis.decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.decrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.decrBy(key, value)));
                return null;
            }
            return this.jedis.decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.incr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.incr(key)));
                return null;
            }
            return this.jedis.incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.incrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.incrBy(key, value)));
                return null;
            }
            return this.jedis.incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.incrByFloat(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.incrByFloat(key, value)));
                return null;
            }
            return this.jedis.incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.getbit(key, offset)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.getbit(key, offset)));
                return null;
            }
            Boolean getBit = this.jedis.getbit(key, offset);
            if (getBit instanceof Long) {
                return (Long)((Object)getBit) == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            return getBit;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            return this.jedis.setbit(key, offset, JedisConverters.toBit(value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.setrange(key, start, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.setrange(key, start, value)));
                return;
            }
            this.jedis.setrange(key, start, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.strlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.strlen(key)));
                return null;
            }
            return this.jedis.strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.bitcount(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.bitcount(key)));
                return null;
            }
            return this.jedis.bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.bitcount(key, begin, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.bitcount(key, begin, end)));
                return null;
            }
            return this.jedis.bitcount(key, begin, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            return this.jedis.bitop(JedisConverters.toBitOp(op), destination, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lpush(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lpush(key, values)));
                return null;
            }
            return this.jedis.lpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.rpush(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.rpush(key, values)));
                return null;
            }
            return this.jedis.rpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.blpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.blpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            return this.jedis.blpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.brpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.brpop(this.bXPopArgs(timeout, keys))));
                return null;
            }
            return this.jedis.brpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lindex(key, index)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lindex(key, index)));
                return null;
            }
            return this.jedis.lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.linsert(key, JedisConverters.toListPosition(where), pivot, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.linsert(key, JedisConverters.toListPosition(where), pivot, value)));
                return null;
            }
            return this.jedis.linsert(key, JedisConverters.toListPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.llen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.llen(key)));
                return null;
            }
            return this.jedis.llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lpop(key)));
                return null;
            }
            return this.jedis.lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lrange(key, start, end)));
                return null;
            }
            return this.jedis.lrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lrem(key, count, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lrem(key, count, value)));
                return null;
            }
            return this.jedis.lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.lset(key, index, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.lset(key, index, value)));
                return;
            }
            this.jedis.lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.ltrim(key, start, end)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.ltrim(key, start, end)));
                return;
            }
            this.jedis.ltrim(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.rpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.rpop(key)));
                return null;
            }
            return this.jedis.rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.rpoplpush(srcKey, dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.rpoplpush(srcKey, dstKey)));
                return null;
            }
            return this.jedis.rpoplpush(srcKey, dstKey);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.brpoplpush(srcKey, dstKey, timeout)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.brpoplpush(srcKey, dstKey, timeout)));
                return null;
            }
            return this.jedis.brpoplpush(srcKey, dstKey, timeout);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.lpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.lpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            return this.jedis.lpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.rpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.rpushx(key, (byte[][])new byte[][]{value})));
                return null;
            }
            return this.jedis.rpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sadd(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sadd(key, values)));
                return null;
            }
            return this.jedis.sadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.scard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.scard(key)));
                return null;
            }
            return this.jedis.scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sdiff(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sdiff(keys)));
                return null;
            }
            return this.jedis.sdiff(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sdiffstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sdiffstore(destKey, keys)));
                return null;
            }
            return this.jedis.sdiffstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sinter(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sinter(keys)));
                return null;
            }
            return this.jedis.sinter(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sinterstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sinterstore(destKey, keys)));
                return null;
            }
            return this.jedis.sinterstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sismember(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sismember(key, value)));
                return null;
            }
            return this.jedis.sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.smembers(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.smembers(key)));
                return null;
            }
            return this.jedis.smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.smove(srcKey, destKey, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.smove(srcKey, destKey, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.spop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.spop(key)));
                return null;
            }
            return this.jedis.spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.srandmember(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.srandmember(key)));
                return null;
            }
            return this.jedis.srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.srandmember(key, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.srandmember(key, (int)count)));
                return null;
            }
            return this.jedis.srandmember(key, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.srem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.srem(key, values)));
                return null;
            }
            return this.jedis.srem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sunion(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sunion(keys)));
                return null;
            }
            return this.jedis.sunion(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.sunionstore(destKey, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.sunionstore(destKey, keys)));
                return null;
            }
            return this.jedis.sunionstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("zAdd of multiple fields not supported in pipeline or transaction");
        }
        Map<byte[], Double> args = this.zAddArgs(tuples);
        try {
            return this.jedis.zadd(key, args);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zcard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zcard(key)));
                return null;
            }
            return this.jedis.zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zcount(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zcount(key, min, max)));
                return null;
            }
            return this.jedis.zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zincrby(key, increment, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zincrby(key, increment, value)));
                return null;
            }
            return this.jedis.zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zinterstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zinterstore(destKey, zparams, sets)));
                return null;
            }
            return this.jedis.zinterstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zinterstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zinterstore(destKey, sets)));
                return null;
            }
            return this.jedis.zinterstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrange(key, start, end)));
                return null;
            }
            return this.jedis.zrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrangeByScore(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrangeByScore(key, min, max)));
                return null;
            }
            return this.jedis.zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrangeByScore(key, min, max, (int)offset, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrangeByScore(key, min, max, (int)offset, (int)count)));
                return null;
            }
            return this.jedis.zrangeByScore(key, min, max, (int)offset, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrangeByScore(key, max, min, (int)offset, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrangeByScore(key, max, min, (int)offset, (int)count)));
                return null;
            }
            return this.jedis.zrevrangeByScore(key, max, min, (int)offset, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrangeByScore(key, max, min)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrangeByScore(key, max, min)));
                return null;
            }
            return this.jedis.zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrangeByScoreWithScores(key, max, min, (int)offset, (int)count), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrangeByScoreWithScores(key, max, min, (int)offset, (int)count), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrevrangeByScoreWithScores(key, max, min, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.jedis.zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrank(key, value)));
                return null;
            }
            return this.jedis.zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrem(key, values)));
                return null;
            }
            return this.jedis.zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zremrangeByRank(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zremrangeByRank(key, start, end)));
                return null;
            }
            return this.jedis.zremrangeByRank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zremrangeByScore(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zremrangeByScore(key, min, max)));
                return null;
            }
            return this.jedis.zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrange(key, start, end)));
                return null;
            }
            return this.jedis.zrevrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zrevrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zrevrank(key, value)));
                return null;
            }
            return this.jedis.zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zscore(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zscore(key, value)));
                return null;
            }
            return this.jedis.zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zunionstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zunionstore(destKey, zparams, sets)));
                return null;
            }
            return this.jedis.zunionstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.zunionstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.zunionstore(destKey, sets)));
                return null;
            }
            return this.jedis.zunionstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hset(key, field, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hset(key, field, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hsetnx(key, field, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hsetnx(key, field, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.jedis.hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hdel(key, fields)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hdel(key, fields)));
                return null;
            }
            return this.jedis.hdel(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hexists(key, field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hexists(key, field)));
                return null;
            }
            return this.jedis.hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hget(key, field)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hget(key, field)));
                return null;
            }
            return this.jedis.hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hgetAll(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hgetAll(key)));
                return null;
            }
            return this.jedis.hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hincrBy(key, field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hincrBy(key, field, delta)));
                return null;
            }
            return this.jedis.hincrBy(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hincrByFloat(key, field, delta)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hincrByFloat(key, field, delta)));
                return null;
            }
            return this.jedis.hincrByFloat(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hkeys(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hkeys(key)));
                return null;
            }
            return this.jedis.hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hlen(key)));
                return null;
            }
            return this.jedis.hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hmget(key, fields)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hmget(key, fields)));
                return null;
            }
            return this.jedis.hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisStatusResult((Response<?>)this.pipeline.hmset(key, tuple)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisStatusResult((Response<?>)this.transaction.hmset(key, tuple)));
                return;
            }
            this.jedis.hmset(key, tuple);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.hvals(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.hvals(key)));
                return null;
            }
            return this.jedis.hvals(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new JedisResult(this.pipeline.publish(channel, message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(new JedisResult(this.transaction.publish(channel, message)));
                return null;
            }
            return this.jedis.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.jedis.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.jedis.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void scriptFlush() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.jedis.scriptFlush();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.jedis.scriptKill();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return JedisConverters.toString(this.jedis.scriptLoad(script));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.jedis.scriptExists(scriptSha1);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.jedis.eval(script, JedisConverters.toBytes(numKeys), keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.jedis.evalsha(JedisConverters.toBytes(scriptSha1), numKeys, keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long time() {
        List serverTimeInformation = this.jedis.time();
        Assert.notEmpty((Collection)serverTimeInformation, (String)"Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue((serverTimeInformation.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + serverTimeInformation.size()));
        return Converters.toTimeMillis((String)serverTimeInformation.get(0), (String)serverTimeInformation.get(1));
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT KILL' is not supported in transaction / pipline mode.");
        }
        try {
            this.jedis.clientKill(String.format("%s:%s", host, port));
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.jedis.slaveof(host, port);
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("'CLIENT SETNAME' is not suppored in transacton / pipeline mode.");
        }
        this.jedis.clientSetname(name);
    }

    @Override
    public String getClientName() {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        return this.jedis.clientGetname();
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT LIST' is not supported in in pipeline / multi mode.");
        }
        return JedisConverters.toListOfRedisClientInformation(this.jedis.clientList());
    }

    @Override
    public void slaveOfNoOne() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.jedis.slaveofNoOne();
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    public Cursor<byte[]> scan() {
        return this.scan(ScanOptions.NONE);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (JedisConnection.this.isQueueing() || JedisConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConnection.this.prepareScanParams(options);
                ScanResult result = JedisConnection.this.jedis.scan(Long.toString(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, Long cursorId, ScanOptions options) {
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId.longValue(), options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisConnection.this.isQueueing() || JedisConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConnection.this.prepareScanParams(options);
                ScanResult result = JedisConnection.this.jedis.zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisConnection.this.isQueueing() || JedisConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConnection.this.prepareScanParams(options);
                ScanResult result = JedisConnection.this.jedis.sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, 0L, options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisConnection.this.isQueueing() || JedisConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConnection.this.prepareScanParams(options);
                ScanResult result = JedisConnection.this.jedis.hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(result.getStringCursor()), result.getResult());
            }
        }.open();
    }

    private ScanParams prepareScanParams(ScanOptions options) {
        ScanParams sp = new ScanParams();
        if (!options.equals(ScanOptions.NONE)) {
            if (options.getCount() != null) {
                sp.count(options.getCount().intValue());
            }
            if (StringUtils.hasText((String)options.getPattern())) {
                sp.match(options.getPattern());
            }
        }
        return sp;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    private byte[][] bXPopArgs(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args.add(arg);
        }
        args.add(Protocol.toByteArray((int)timeout));
        return (byte[][])args.toArray((T[])new byte[args.size()][]);
    }

    private Map<byte[], Double> zAddArgs(Set<RedisZSetCommands.Tuple> tuples) {
        LinkedHashMap<byte[], Double> args = new LinkedHashMap<byte[], Double>(tuples.size(), 1.0f);
        HashSet<Double> scores = new HashSet<Double>(tuples.size(), 1.0f);
        boolean isAtLeastJedis24 = JedisVersionUtil.atLeastJedis24();
        for (RedisZSetCommands.Tuple tuple : tuples) {
            if (!isAtLeastJedis24) {
                if (scores.contains(tuple.getScore())) {
                    throw new UnsupportedOperationException("Bulk add of multiple elements with the same score is not supported. Add the elements individually.");
                }
                scores.add(tuple.getScore());
            }
            args.put(tuple.getValue(), tuple.getScore());
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(RedisNode node) {
        if (node == null) {
            return false;
        }
        Jedis temp = null;
        try {
            temp = this.getJedis(node);
            temp.connect();
            boolean bl = temp.ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (temp != null) {
                temp.disconnect();
                temp.close();
            }
        }
    }

    @Override
    protected JedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        return new JedisSentinelConnection(this.getJedis(sentinel));
    }

    protected Jedis getJedis(RedisNode node) {
        return new Jedis(node.getHost(), node.getPort().intValue());
    }

    static {
        EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
        CLIENT_FIELD = ReflectionUtils.findField(BinaryJedis.class, (String)"client", Client.class);
        ReflectionUtils.makeAccessible((Field)CLIENT_FIELD);
        SEND_COMMAND = ReflectionUtils.findMethod(Connection.class, (String)"sendCommand", (Class[])new Class[]{Protocol.Command.class, byte[][].class});
        ReflectionUtils.makeAccessible((Method)SEND_COMMAND);
        GET_RESPONSE = ReflectionUtils.findMethod(Queable.class, (String)"getResponse", (Class[])new Class[]{Builder.class});
        ReflectionUtils.makeAccessible((Method)GET_RESPONSE);
    }

    private class JedisStatusResult
    extends JedisResult {
        public JedisStatusResult(Response<?> resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }
    }

    private class JedisResult
    extends FutureResult<Response<?>> {
        public <T> JedisResult(Response<T> resultHolder, Converter<T, ?> converter) {
            super(resultHolder, converter);
        }

        public <T> JedisResult(Response<T> resultHolder) {
            super(resultHolder);
        }

        @Override
        public Object get() {
            if (JedisConnection.this.convertPipelineAndTxResults && this.converter != null) {
                return this.converter.convert(((Response)this.resultHolder).get());
            }
            return ((Response)this.resultHolder).get();
        }
    }
}

