/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class RedisConnectionUtils {
    private static final Log log = LogFactory.getLog(RedisConnectionUtils.class);

    public static RedisConnection bindConnection(RedisConnectionFactory factory) {
        return RedisConnectionUtils.doGetConnection(factory, true, true);
    }

    public static RedisConnection getConnection(RedisConnectionFactory factory) {
        return RedisConnectionUtils.doGetConnection(factory, true, false);
    }

    public static RedisConnection doGetConnection(RedisConnectionFactory factory, boolean allowCreate, boolean bind) {
        Assert.notNull((Object)factory, (String)"No RedisConnectionFactory specified");
        RedisConnectionHolder connHolder = (RedisConnectionHolder)TransactionSynchronizationManager.getResource((Object)factory);
        if (connHolder != null) {
            return connHolder.getConnection();
        }
        if (!allowCreate) {
            throw new IllegalArgumentException("No connection found and allowCreate = false");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening RedisConnection");
        }
        RedisConnection conn = factory.getConnection();
        if (bind) {
            connHolder = new RedisConnectionHolder(conn);
            TransactionSynchronizationManager.bindResource((Object)factory, (Object)connHolder);
            return connHolder.getConnection();
        }
        return conn;
    }

    public static void releaseConnection(RedisConnection conn, RedisConnectionFactory factory) {
        if (conn == null) {
            return;
        }
        if (!RedisConnectionUtils.isConnectionTransactional(conn, factory)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing Redis Connection");
            }
            conn.close();
        }
    }

    public static void unbindConnection(RedisConnectionFactory factory) {
        RedisConnectionHolder connHolder = (RedisConnectionHolder)TransactionSynchronizationManager.unbindResourceIfPossible((Object)factory);
        if (connHolder != null) {
            RedisConnection connection = connHolder.getConnection();
            connection.close();
        }
    }

    public static boolean isConnectionTransactional(RedisConnection conn, RedisConnectionFactory connFactory) {
        if (connFactory == null) {
            return false;
        }
        RedisConnectionHolder connHolder = (RedisConnectionHolder)TransactionSynchronizationManager.getResource((Object)connFactory);
        return connHolder != null && conn == connHolder.getConnection();
    }

    private static class RedisConnectionHolder
    implements ResourceHolder {
        private boolean isVoid = false;
        private final RedisConnection conn;

        public RedisConnectionHolder(RedisConnection conn) {
            this.conn = conn;
        }

        public boolean isVoid() {
            return this.isVoid;
        }

        public RedisConnection getConnection() {
            return this.conn;
        }

        public void reset() {
        }

        public void unbound() {
            this.isVoid = true;
        }
    }
}

