/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.support.collections.DefaultRedisMap;
import org.springframework.data.redis.support.collections.RedisMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisProperties
extends Properties
implements RedisMap<Object, Object> {
    private final BoundHashOperations<String, String, String> hashOps;
    private final RedisMap<String, String> delegate;

    public RedisProperties(BoundHashOperations<String, String, String> boundOps) {
        this(null, boundOps);
    }

    public RedisProperties(String key, RedisOperations<String, ?> operations) {
        this(null, operations.boundHashOps(key));
    }

    public RedisProperties(Properties defaults, BoundHashOperations<String, String, String> boundOps) {
        super(defaults);
        this.hashOps = boundOps;
        this.delegate = new DefaultRedisMap<String, String>(boundOps);
    }

    public RedisProperties(Properties defaults, String key, RedisOperations<String, ?> operations) {
        this(defaults, operations.boundHashOps(key));
    }

    @Override
    public synchronized Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.delegate.put((String)key, (String)value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        this.delegate.putAll(t);
    }

    @Override
    public Enumeration<?> propertyNames() {
        LinkedHashSet keys = new LinkedHashSet(this.delegate.keySet());
        if (this.defaults != null) {
            keys.addAll(this.defaults.stringPropertyNames());
        }
        return Collections.enumeration(keys);
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    public synchronized Object clone() {
        return new RedisProperties(this.defaults, this.hashOps);
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        Collection values = this.delegate.values();
        return Collections.enumeration(values);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        Set<Map.Entry<Object, Object>> entries = this.delegate.entrySet();
        return entries;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisProperties) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        int hash = RedisProperties.class.hashCode();
        return hash * 17 + this.delegate.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Set<Object> keys = this.keySet();
        return Collections.enumeration(keys);
    }

    @Override
    public Set<Object> keySet() {
        Set<Object> keys = this.delegate.keySet();
        return keys;
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<Object> values() {
        Collection<Object> vals = this.delegate.values();
        return vals;
    }

    @Override
    public Long increment(Object key, long delta) {
        return this.hashOps.increment((String)key, delta);
    }

    @Override
    public Double increment(Object key, double delta) {
        return this.hashOps.increment((String)key, delta);
    }

    @Override
    public RedisOperations<String, ?> getOperations() {
        return this.hashOps.getOperations();
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.hashOps.expire(timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.hashOps.expireAt(date);
    }

    @Override
    public Long getExpire() {
        return this.hashOps.getExpire();
    }

    @Override
    public String getKey() {
        return (String)this.hashOps.getKey();
    }

    @Override
    public DataType getType() {
        return this.hashOps.getType();
    }

    @Override
    public Boolean persist() {
        return this.hashOps.persist();
    }

    @Override
    public void rename(String newKey) {
        this.hashOps.rename(newKey);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.hashOps.putIfAbsent((String)key, (String)value) != false ? null : this.get(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }
}

