/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.SortParameters;

public class DefaultSortParameters
implements SortParameters {
    private byte[] byPattern;
    private SortParameters.Range limit;
    private final List<byte[]> getPattern = new ArrayList<byte[]>(4);
    private SortParameters.Order order;
    private Boolean alphabetic;

    public DefaultSortParameters() {
        this(null, null, null, null, null);
    }

    public DefaultSortParameters(SortParameters.Range limit, SortParameters.Order order, Boolean alphabetic) {
        this(null, limit, null, order, alphabetic);
    }

    public DefaultSortParameters(byte[] byPattern, SortParameters.Range limit, byte[][] getPattern, SortParameters.Order order, Boolean alphabetic) {
        this.byPattern = byPattern;
        this.limit = limit;
        this.order = order;
        this.alphabetic = alphabetic;
        this.setGetPattern(getPattern);
    }

    public byte[] getByPattern() {
        return this.byPattern;
    }

    public void setByPattern(byte[] byPattern) {
        this.byPattern = byPattern;
    }

    public SortParameters.Range getLimit() {
        return this.limit;
    }

    public void setLimit(SortParameters.Range limit) {
        this.limit = limit;
    }

    public byte[][] getGetPattern() {
        return (byte[][])this.getPattern.toArray((T[])new byte[this.getPattern.size()][]);
    }

    public void addGetPattern(byte[] gPattern) {
        this.getPattern.add(gPattern);
    }

    public void setGetPattern(byte[][] gPattern) {
        this.getPattern.clear();
        if (gPattern == null) {
            return;
        }
        for (byte[] bs : gPattern) {
            this.getPattern.add(bs);
        }
    }

    public SortParameters.Order getOrder() {
        return this.order;
    }

    public void setOrder(SortParameters.Order order) {
        this.order = order;
    }

    public Boolean isAlphabetic() {
        return this.alphabetic;
    }

    public void setAlphabetic(Boolean alphabetic) {
        this.alphabetic = alphabetic;
    }

    public DefaultSortParameters order(SortParameters.Order order) {
        this.setOrder(order);
        return this;
    }

    public DefaultSortParameters alpha() {
        this.setAlphabetic(true);
        return this;
    }

    public DefaultSortParameters asc() {
        this.setOrder(SortParameters.Order.ASC);
        return this;
    }

    public DefaultSortParameters desc() {
        this.setOrder(SortParameters.Order.DESC);
        return this;
    }

    public DefaultSortParameters numeric() {
        this.setAlphabetic(false);
        return this;
    }

    public DefaultSortParameters get(byte[] pattern) {
        this.addGetPattern(pattern);
        return this;
    }

    public DefaultSortParameters by(byte[] pattern) {
        this.setByPattern(pattern);
        return this;
    }

    public DefaultSortParameters limit(long start, long count) {
        this.setLimit(new SortParameters.Range(start, count));
        return this;
    }
}

