/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class R2dbcParameterAccessor
extends RelationalParametersParameterAccessor {
    private final @Nullable Object[] values;
    private final R2dbcQueryMethod method;

    public R2dbcParameterAccessor(R2dbcQueryMethod method, Object ... values) {
        super((QueryMethod)method, values);
        this.values = values;
        this.method = method;
    }

    public @Nullable Object[] getValues() {
        @Nullable Object[] result = new Object[this.values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    public @Nullable Object getBindableValue(int index) {
        return this.getValue(this.getParameters().getBindableParameter(index).getIndex());
    }

    public Mono<R2dbcParameterAccessor> resolveParameters() {
        boolean hasReactiveWrapper = false;
        for (Object value : this.values) {
            if (value == null || !ReactiveWrappers.supports(value.getClass())) continue;
            hasReactiveWrapper = true;
            break;
        }
        if (!hasReactiveWrapper) {
            return Mono.just((Object)((Object)this));
        }
        Object[] resolved = new Object[this.values.length];
        ConcurrentHashMap holder = new ConcurrentHashMap();
        ArrayList<Mono> publishers = new ArrayList<Mono>();
        for (int i = 0; i < this.values.length; ++i) {
            int index;
            resolved[i] = this.values[i];
            Object value = resolved[i];
            if (value == null || !ReactiveWrappers.supports(value.getClass())) continue;
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                index = i;
                publishers.add(((Mono)ReactiveWrapperConverters.toWrapper((Object)value, Mono.class)).map(Optional::of).defaultIfEmpty(Optional.empty()).doOnNext(it -> holder.put(index, (Optional)it)));
                continue;
            }
            index = i;
            publishers.add(((Flux)ReactiveWrapperConverters.toWrapper((Object)value, Flux.class)).collectList().doOnNext(it -> holder.put(index, Optional.of(it))));
        }
        return Flux.merge(publishers).then().thenReturn((Object)resolved).map(values -> {
            holder.forEach((index, v) -> {
                values[index.intValue()] = v.orElse(null);
            });
            return new R2dbcParameterAccessor(this.method, values);
        });
    }
}

