/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.expression.ReactiveValueEvaluationContextProvider;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.BindTargetBinder;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class StringBasedR2dbcQuery
extends AbstractR2dbcQuery {
    private final ExpressionQuery expressionQuery;
    private final ExpressionEvaluatingParameterBinder binder;
    private final ExpressionDependencies expressionDependencies;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final ReactiveValueEvaluationContextProvider valueContextProvider;

    public StringBasedR2dbcQuery(R2dbcQueryMethod method, R2dbcEntityOperations entityOperations, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy, ValueExpressionDelegate valueExpressionDelegate) {
        this(method.getRequiredAnnotatedQuery(), method, entityOperations, converter, dataAccessStrategy, valueExpressionDelegate);
    }

    public StringBasedR2dbcQuery(String query, R2dbcQueryMethod method, R2dbcEntityOperations entityOperations, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy, ValueExpressionDelegate valueExpressionDelegate) {
        super(method, entityOperations, converter);
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.dataAccessStrategy = dataAccessStrategy;
        this.expressionQuery = ExpressionQuery.create((ValueExpressionParser)valueExpressionDelegate, query);
        this.binder = new ExpressionEvaluatingParameterBinder(this.expressionQuery, dataAccessStrategy);
        ValueEvaluationContextProvider valueContextProvider = valueExpressionDelegate.createValueContextProvider((Parameters)method.getParameters());
        Assert.isInstanceOf(ReactiveValueEvaluationContextProvider.class, (Object)valueContextProvider, (String)"ValueEvaluationContextProvider must be reactive");
        this.valueContextProvider = (ReactiveValueEvaluationContextProvider)valueContextProvider;
        this.expressionDependencies = this.createExpressionDependencies();
        if (method.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries; Offending method: " + method);
        }
        if (method.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries; Offending method: " + method);
        }
        if (method.getParameters().hasLimitParameter()) {
            throw new UnsupportedOperationException("Queries with Limit are not supported using string-based queries; Offending method: " + method);
        }
    }

    private ExpressionDependencies createExpressionDependencies() {
        if (this.expressionQuery.getBindings().isEmpty()) {
            return ExpressionDependencies.none();
        }
        ArrayList dependencies = new ArrayList();
        this.expressionQuery.getBindings().forEach((s, valueExpression) -> dependencies.add(valueExpression.getExpressionDependencies()));
        return ExpressionDependencies.merged(dependencies);
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getQueryMethod().isModifyingQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected Mono<PreparedOperation<?>> createQuery(RelationalParameterAccessor accessor) {
        return this.getExpressionEvaluator(accessor).map(evaluator -> new ExpandedQuery(accessor, (ValueEvaluationContext)evaluator));
    }

    @Override
    Class<?> resolveResultType(ResultProcessor resultProcessor) {
        Class<?> returnedType = resultProcessor.getReturnedType().getReturnedType();
        return !returnedType.isInterface() ? returnedType : super.resolveResultType(resultProcessor);
    }

    private Mono<ValueEvaluationContext> getExpressionEvaluator(RelationalParameterAccessor accessor) {
        return this.valueContextProvider.getEvaluationContextLater((Object)accessor.getValues(), this.expressionDependencies);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.expressionQuery.getQuery() + "]";
    }

    private class ExpandedQuery
    implements PreparedOperation<String> {
        private final BindTargetRecorder recordedBindings = new BindTargetRecorder();
        private final PreparedOperation<?> expanded;
        private final Map<String, Parameter> remainderByName;
        private final Map<Integer, Parameter> remainderByIndex;

        public ExpandedQuery(RelationalParameterAccessor accessor, ValueEvaluationContext evaluationContext) {
            StringBasedR2dbcQuery.this.binder.bind(this.recordedBindings, accessor, evaluationContext);
            this.remainderByName = new LinkedHashMap<String, Parameter>(this.recordedBindings.byName);
            this.remainderByIndex = new LinkedHashMap<Integer, Parameter>(this.recordedBindings.byIndex);
            this.expanded = StringBasedR2dbcQuery.this.dataAccessStrategy.processNamedParameters(StringBasedR2dbcQuery.this.expressionQuery.getQuery(), (index, name) -> {
                if (this.recordedBindings.byName.containsKey(name)) {
                    this.remainderByName.remove(name);
                    return this.recordedBindings.byName.get(name);
                }
                if (this.recordedBindings.byIndex.containsKey(index)) {
                    this.remainderByIndex.remove(index);
                    return this.recordedBindings.byIndex.get(index);
                }
                return null;
            });
        }

        public String getSource() {
            return StringBasedR2dbcQuery.this.expressionQuery.getQuery();
        }

        public void bindTo(BindTarget target) {
            BindTargetBinder binder = new BindTargetBinder(target);
            this.expanded.bindTo(target);
            this.remainderByName.forEach(binder::bind);
            this.remainderByIndex.forEach(binder::bind);
        }

        public String toQuery() {
            return this.expanded.toQuery();
        }

        public String toString() {
            return String.format("Original: [%s], Expanded: [%s]", StringBasedR2dbcQuery.this.expressionQuery.getQuery(), this.expanded.toQuery());
        }
    }

    private static class BindTargetRecorder
    implements BindTarget {
        final Map<Integer, Parameter> byIndex = new LinkedHashMap<Integer, Parameter>();
        final Map<String, Parameter> byName = new LinkedHashMap<String, Parameter>();

        private BindTargetRecorder() {
        }

        public void bind(String identifier, Object value) {
            this.byName.put(identifier, this.toParameter(value));
        }

        private Parameter toParameter(Object value) {
            return value instanceof Parameter ? (Parameter)value : Parameter.from((Object)value);
        }

        public void bind(int index, Object value) {
            this.byIndex.put(index, this.toParameter(value));
        }

        public void bindNull(String identifier, Class<?> type) {
            this.byName.put(identifier, Parameter.empty(type));
        }

        public void bindNull(int index, Class<?> type) {
            this.byIndex.put(index, Parameter.empty(type));
        }
    }
}

