/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.ReactiveDeleteOperation;
import org.springframework.data.r2dbc.core.ReactiveDeleteOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveInsertOperation;
import org.springframework.data.r2dbc.core.ReactiveInsertOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveSelectOperation;
import org.springframework.data.r2dbc.core.ReactiveSelectOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveUpdateOperation;
import org.springframework.data.r2dbc.core.ReactiveUpdateOperationSupport;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.event.AfterConvertCallback;
import org.springframework.data.r2dbc.mapping.event.AfterSaveCallback;
import org.springframework.data.r2dbc.mapping.event.BeforeConvertCallback;
import org.springframework.data.r2dbc.mapping.event.BeforeSaveCallback;
import org.springframework.data.relational.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class R2dbcEntityTemplate
implements R2dbcEntityOperations,
BeanFactoryAware,
ApplicationContextAware {
    private final DatabaseClient databaseClient;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final R2dbcConverter converter;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    @Nullable
    private ReactiveEntityCallbacks entityCallbacks;

    public R2dbcEntityTemplate(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        R2dbcDialect dialect = DialectResolver.getDialect(connectionFactory);
        this.databaseClient = DatabaseClient.builder().connectionFactory(connectionFactory).bindMarkers(dialect.getBindMarkersFactory()).build();
        this.dataAccessStrategy = new DefaultReactiveDataAccessStrategy(dialect);
        this.converter = this.dataAccessStrategy.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
    }

    public R2dbcEntityTemplate(DatabaseClient databaseClient, R2dbcDialect dialect) {
        this(databaseClient, new DefaultReactiveDataAccessStrategy(dialect));
    }

    public R2dbcEntityTemplate(DatabaseClient databaseClient, R2dbcDialect dialect, R2dbcConverter converter) {
        this(databaseClient, new DefaultReactiveDataAccessStrategy(dialect, converter));
    }

    public R2dbcEntityTemplate(DatabaseClient databaseClient, ReactiveDataAccessStrategy strategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        Assert.notNull((Object)strategy, (String)"ReactiveDataAccessStrategy must not be null");
        this.databaseClient = databaseClient;
        this.dataAccessStrategy = strategy;
        this.converter = this.dataAccessStrategy.getConverter();
        this.mappingContext = strategy.getConverter().getMappingContext();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    @Override
    public ReactiveDataAccessStrategy getDataAccessStrategy() {
        return this.dataAccessStrategy;
    }

    @Override
    public R2dbcConverter getConverter() {
        return this.converter;
    }

    @Deprecated
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(ReactiveEntityCallbacks.create((BeanFactory)applicationContext));
        }
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    public void setEntityCallbacks(ReactiveEntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> select(Class<T> domainType) {
        return new ReactiveSelectOperationSupport(this).select(domainType);
    }

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        return new ReactiveInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ReactiveUpdateOperation.ReactiveUpdate update(Class<?> domainType) {
        return new ReactiveUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        return new ReactiveDeleteOperationSupport(this).delete(domainType);
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return this.doCount(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Long> doCount(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).withProjection(new Expression[]{Functions.count((Expression[])new Expression[]{Expressions.just((String)"*")})});
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.sql(operation).map((r, md) -> (Long)r.get(0, Long.class)).first().defaultIfEmpty((Object)0L);
    }

    @Override
    public Mono<Boolean> exists(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return this.doExists(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Boolean> doExists(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).limit(1).withProjection(Expressions.just((String)"1"));
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.sql(operation).map((r, md) -> r).first().hasElement();
    }

    @Override
    public <T> Flux<T> select(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        SqlIdentifier tableName = this.getTableName(entityClass);
        return this.doSelect(query, entityClass, tableName, entityClass, RowsFetchSpec::all);
    }

    <T, P extends Publisher<T>> P doSelect(Query query, Class<?> entityClass, SqlIdentifier tableName, Class<T> returnType, Function<RowsFetchSpec<T>, P> resultHandler) {
        RowsFetchSpec<T> fetchSpec = this.doSelect(query, entityClass, tableName, returnType);
        Publisher result = (Publisher)resultHandler.apply(fetchSpec);
        if (result instanceof Mono) {
            return (P)((Mono)result).flatMap(it -> this.maybeCallAfterConvert(it, tableName));
        }
        return (P)((Flux)result).concatMap(it -> this.maybeCallAfterConvert(it, tableName));
    }

    private <T> RowsFetchSpec<T> doSelect(Query query, Class<?> entityType, SqlIdentifier tableName, Class<T> returnType) {
        Optional criteria;
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityType);
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).doWithTable((table, spec) -> spec.withProjection(this.getSelectProjection((Table)table, query, entityType, returnType)));
        if (query.getLimit() > 0) {
            selectSpec = selectSpec.limit(query.getLimit());
        }
        if (query.getOffset() > 0L) {
            selectSpec = selectSpec.offset(query.getOffset());
        }
        if (query.isSorted()) {
            selectSpec = selectSpec.withSort(query.getSort());
        }
        if ((criteria = query.getCriteria()).isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.getRowsFetchSpec(this.databaseClient.sql(operation), entityType, returnType);
    }

    @Override
    public <T> Mono<T> selectOne(Query query, Class<T> entityClass) throws DataAccessException {
        return this.doSelect(query.isLimited() ? query : query.limit(2), entityClass, this.getTableName(entityClass), entityClass, RowsFetchSpec::one);
    }

    @Override
    public Mono<Long> update(Query query, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return this.doUpdate(query, update, entityClass, this.getTableName(entityClass));
    }

    Mono<Long> doUpdate(Query query, Update update, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.UpdateSpec selectSpec = statementMapper.createUpdate(tableName, update);
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.sql(operation).fetch().rowsUpdated();
    }

    @Override
    public Mono<Long> delete(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return this.doDelete(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Long> doDelete(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.DeleteSpec deleteSpec = statementMapper.createDelete(tableName);
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            deleteSpec = criteria.map(deleteSpec::withCriteria).orElse(deleteSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(deleteSpec);
        return this.databaseClient.sql(operation).fetch().rowsUpdated().defaultIfEmpty((Object)0L);
    }

    @Override
    public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, Class<T> entityClass) {
        return this.query(operation, entityClass, entityClass);
    }

    @Override
    public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, Class<?> entityClass, Class<T> resultType) throws DataAccessException {
        Assert.notNull(operation, (String)"PreparedOperation must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new EntityCallbackAdapter<T>(this.getRowsFetchSpec(this.databaseClient.sql(operation), entityClass, resultType), this.getTableNameOrEmpty(entityClass));
    }

    @Override
    public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, BiFunction<Row, RowMetadata, T> rowMapper) {
        Assert.notNull(operation, (String)"PreparedOperation must not be null");
        Assert.notNull(rowMapper, (String)"Row mapper must not be null");
        return new EntityCallbackAdapter(this.databaseClient.sql(operation).map(rowMapper), SqlIdentifier.EMPTY);
    }

    @Override
    public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, Class<?> entityClass, BiFunction<Row, RowMetadata, T> rowMapper) {
        Assert.notNull(operation, (String)"PreparedOperation must not be null");
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        Assert.notNull(rowMapper, (String)"Row mapper must not be null");
        return new EntityCallbackAdapter(this.databaseClient.sql(operation).map(rowMapper), this.getTableNameOrEmpty(entityClass));
    }

    @Override
    public <T> Mono<T> insert(T entity) throws DataAccessException {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.doInsert(entity, this.getRequiredEntity(entity).getQualifiedTableName());
    }

    <T> Mono<T> doInsert(T entity, SqlIdentifier tableName) {
        RelationalPersistentEntity persistentEntity = this.getRequiredEntity(entity);
        return this.maybeCallBeforeConvert(entity, tableName).flatMap(onBeforeConvert -> {
            Object initializedEntity = this.setVersionIfNecessary(persistentEntity, onBeforeConvert);
            OutboundRow outboundRow = this.dataAccessStrategy.getOutboundRow(initializedEntity);
            this.potentiallyRemoveId(persistentEntity, outboundRow);
            return this.maybeCallBeforeSave(initializedEntity, outboundRow, tableName).flatMap(entityToSave -> this.doInsert(entityToSave, tableName, outboundRow));
        });
    }

    private void potentiallyRemoveId(RelationalPersistentEntity<?> persistentEntity, OutboundRow outboundRow) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return;
        }
        SqlIdentifier columnName = idProperty.getColumnName();
        Parameter parameter = outboundRow.get(columnName);
        if (this.shouldSkipIdValue(parameter, idProperty)) {
            outboundRow.remove(columnName);
        }
    }

    private boolean shouldSkipIdValue(@Nullable Parameter value, RelationalPersistentProperty property) {
        if (value == null || value.getValue() == null) {
            return true;
        }
        if (value.getValue() instanceof Number) {
            return ((Number)value.getValue()).longValue() == 0L;
        }
        return false;
    }

    private <T> Mono<T> doInsert(T entity, SqlIdentifier tableName, OutboundRow outboundRow) {
        StatementMapper mapper = this.dataAccessStrategy.getStatementMapper();
        StatementMapper.InsertSpec insert = mapper.createInsert(tableName);
        for (SqlIdentifier column : outboundRow.keySet()) {
            Parameter settableValue = outboundRow.get(column);
            if (!settableValue.hasValue()) continue;
            insert = insert.withColumn(column, settableValue);
        }
        PreparedOperation<?> operation = mapper.getMappedObject(insert);
        List<SqlIdentifier> identifierColumns = this.dataAccessStrategy.getIdentifierColumns(entity.getClass());
        return this.databaseClient.sql(operation).filter(statement -> {
            if (identifierColumns.isEmpty()) {
                return statement.returnGeneratedValues(new String[0]);
            }
            return statement.returnGeneratedValues(new String[]{this.dataAccessStrategy.renderForGeneratedValues((SqlIdentifier)identifierColumns.get(0))});
        }).map(this.dataAccessStrategy.getConverter().populateIdIfNecessary(entity)).all().last(entity).flatMap(saved -> this.maybeCallAfterSave(saved, outboundRow, tableName));
    }

    private <T> T setVersionIfNecessary(RelationalPersistentEntity<T> persistentEntity, T entity) {
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        if (versionProperty == null) {
            return entity;
        }
        Class versionPropertyType = versionProperty.getType();
        Long version = versionPropertyType.isPrimitive() ? 1L : 0L;
        ConversionService conversionService = this.dataAccessStrategy.getConverter().getConversionService();
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        propertyAccessor.setProperty((PersistentProperty)versionProperty, conversionService.convert((Object)version, versionPropertyType));
        return (T)propertyAccessor.getBean();
    }

    @Override
    public <T> Mono<T> update(T entity) throws DataAccessException {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.doUpdate(entity, this.getRequiredEntity(entity).getQualifiedTableName());
    }

    private <T> Mono<T> doUpdate(T entity, SqlIdentifier tableName) {
        RelationalPersistentEntity persistentEntity = this.getRequiredEntity(entity);
        return this.maybeCallBeforeConvert(entity, tableName).flatMap(onBeforeConvert -> {
            Object entityToUse;
            Criteria matchingVersionCriteria;
            if (persistentEntity.hasVersionProperty()) {
                matchingVersionCriteria = this.createMatchingVersionCriteria(onBeforeConvert, persistentEntity);
                entityToUse = this.incrementVersion(persistentEntity, onBeforeConvert);
            } else {
                entityToUse = onBeforeConvert;
                matchingVersionCriteria = null;
            }
            OutboundRow outboundRow = this.dataAccessStrategy.getOutboundRow(entityToUse);
            return this.maybeCallBeforeSave(entityToUse, outboundRow, tableName).flatMap(onBeforeSave -> {
                SqlIdentifier idColumn = ((RelationalPersistentProperty)persistentEntity.getRequiredIdProperty()).getColumnName();
                Parameter id = outboundRow.remove(idColumn);
                persistentEntity.forEach(p -> {
                    if (p.isInsertOnly()) {
                        outboundRow.remove(p.getColumnName());
                    }
                });
                Criteria criteria = Criteria.where((String)this.dataAccessStrategy.toSql(idColumn)).is((Object)id);
                if (matchingVersionCriteria != null) {
                    criteria = criteria.and((CriteriaDefinition)matchingVersionCriteria);
                }
                return this.doUpdate(onBeforeSave, tableName, persistentEntity, criteria, outboundRow);
            });
        });
    }

    private <T> Mono<T> doUpdate(T entity, SqlIdentifier tableName, RelationalPersistentEntity<T> persistentEntity, Criteria criteria, OutboundRow outboundRow) {
        Update update = Update.from((Map)outboundRow);
        StatementMapper mapper = this.dataAccessStrategy.getStatementMapper();
        StatementMapper.UpdateSpec updateSpec = mapper.createUpdate(tableName, update).withCriteria((CriteriaDefinition)criteria);
        PreparedOperation<?> operation = mapper.getMappedObject(updateSpec);
        return this.databaseClient.sql(operation).fetch().rowsUpdated().handle((rowsUpdated, sink) -> {
            if (rowsUpdated != 0L) {
                return;
            }
            if (persistentEntity.hasVersionProperty()) {
                sink.error((Throwable)new OptimisticLockingFailureException(this.formatOptimisticLockingExceptionMessage(entity, persistentEntity)));
            } else {
                sink.error((Throwable)new TransientDataAccessResourceException(this.formatTransientEntityExceptionMessage(entity, persistentEntity)));
            }
        }).then(this.maybeCallAfterSave(entity, outboundRow, tableName));
    }

    private <T> String formatOptimisticLockingExceptionMessage(T entity, RelationalPersistentEntity<T> persistentEntity) {
        return String.format("Failed to update table [%s]; Version does not match for row with Id [%s]", persistentEntity.getQualifiedTableName(), persistentEntity.getIdentifierAccessor(entity).getIdentifier());
    }

    private <T> String formatTransientEntityExceptionMessage(T entity, RelationalPersistentEntity<T> persistentEntity) {
        return String.format("Failed to update table [%s]; Row with Id [%s] does not exist", persistentEntity.getQualifiedTableName(), persistentEntity.getIdentifierAccessor(entity).getIdentifier());
    }

    private <T> T incrementVersion(RelationalPersistentEntity<T> persistentEntity, T entity) {
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        ConversionService conversionService = this.dataAccessStrategy.getConverter().getConversionService();
        Object currentVersionValue = propertyAccessor.getProperty((PersistentProperty)versionProperty);
        long newVersionValue = 1L;
        if (currentVersionValue != null) {
            newVersionValue = (Long)conversionService.convert(currentVersionValue, Long.class) + 1L;
        }
        Class versionPropertyType = versionProperty.getType();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, conversionService.convert((Object)newVersionValue, versionPropertyType));
        return (T)propertyAccessor.getBean();
    }

    private <T> Criteria createMatchingVersionCriteria(T entity, RelationalPersistentEntity<T> persistentEntity) {
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        Object version = propertyAccessor.getProperty((PersistentProperty)versionProperty);
        Criteria.CriteriaStep versionColumn = Criteria.where((String)this.dataAccessStrategy.toSql(versionProperty.getColumnName()));
        if (version == null) {
            return versionColumn.isNull();
        }
        return versionColumn.is(version);
    }

    @Override
    public <T> Mono<T> delete(T entity) throws DataAccessException {
        Assert.notNull(entity, (String)"Entity must not be null");
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredEntity(entity);
        return this.delete(this.getByIdQuery(entity, persistentEntity), persistentEntity.getType()).thenReturn(entity);
    }

    protected <T> Mono<T> maybeCallBeforeConvert(T object, SqlIdentifier table) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{table});
        }
        return Mono.just(object);
    }

    protected <T> Mono<T> maybeCallBeforeSave(T object, OutboundRow row, SqlIdentifier table) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(BeforeSaveCallback.class, object, new Object[]{row, table});
        }
        return Mono.just(object);
    }

    protected <T> Mono<T> maybeCallAfterSave(T object, OutboundRow row, SqlIdentifier table) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(AfterSaveCallback.class, object, new Object[]{row, table});
        }
        return Mono.just(object);
    }

    protected <T> Mono<T> maybeCallAfterConvert(T object, SqlIdentifier table) {
        if (this.entityCallbacks != null) {
            return this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{table});
        }
        return Mono.just(object);
    }

    private <T> Query getByIdQuery(T entity, RelationalPersistentEntity<?> persistentEntity) {
        if (!persistentEntity.hasIdProperty()) {
            throw new MappingException("No id property found for object of type " + persistentEntity.getType());
        }
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(entity);
        Object id = identifierAccessor.getRequiredIdentifier();
        return Query.query((CriteriaDefinition)Criteria.where((String)((RelationalPersistentProperty)persistentEntity.getRequiredIdProperty()).getName()).is(id));
    }

    SqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredEntity((Object)entityClass).getQualifiedTableName();
    }

    SqlIdentifier getTableNameOrEmpty(Class<?> entityClass) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return entity != null ? entity.getQualifiedTableName() : SqlIdentifier.EMPTY;
    }

    private RelationalPersistentEntity<?> getRequiredEntity(Class<?> entityClass) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
    }

    private <T> RelationalPersistentEntity<T> getRequiredEntity(T entity) {
        Class entityType = ProxyUtils.getUserClass(entity);
        return this.getRequiredEntity((T)entityType);
    }

    private <T> List<Expression> getSelectProjection(Table table, Query query, Class<?> entityType, Class<T> returnType) {
        if (query.getColumns().isEmpty()) {
            EntityProjection projection = this.converter.introspectProjection(returnType, entityType);
            if (projection.isProjection() && projection.isClosedProjection()) {
                return this.computeProjectedFields(table, returnType, projection);
            }
            return Collections.singletonList(table.asterisk());
        }
        return query.getColumns().stream().map(arg_0 -> ((Table)table).column(arg_0)).collect(Collectors.toList());
    }

    private <T> List<Expression> computeProjectedFields(Table table, Class<T> returnType, EntityProjection<T, ?> projection) {
        if (returnType.isInterface()) {
            LinkedHashSet properties = new LinkedHashSet();
            projection.forEach(it -> properties.add(it.getPropertyPath().getSegment()));
            return properties.stream().map(arg_0 -> ((Table)table).column(arg_0)).collect(Collectors.toList());
        }
        LinkedHashSet<SqlIdentifier> properties = new LinkedHashSet<SqlIdentifier>();
        PersistentPropertyTranslator translator = PersistentPropertyTranslator.create((RelationalPersistentEntity)((RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(projection.getDomainType())), (Predicate)Predicates.negate(RelationalPersistentProperty::hasExplicitColumnName));
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(projection.getMappedType());
        for (RelationalPersistentProperty property : persistentEntity) {
            properties.add(translator.translate(property).getColumnName());
        }
        return properties.stream().map(arg_0 -> ((Table)table).column(arg_0)).collect(Collectors.toList());
    }

    @Override
    public <T> RowsFetchSpec<T> getRowsFetchSpec(DatabaseClient.GenericExecuteSpec executeSpec, Class<?> entityType, Class<T> resultType) {
        BiFunction<Row, RowMetadata, Object> rowMapper;
        boolean simpleType = this.getConverter().isSimpleType(resultType);
        if (simpleType) {
            rowMapper = this.dataAccessStrategy.getRowMapper(resultType);
        } else {
            EntityProjection projection = this.converter.introspectProjection(resultType, entityType);
            Class typeToRead = projection.isProjection() ? resultType : (resultType.isInterface() ? entityType : resultType);
            rowMapper = (row, rowMetadata) -> {
                RowDocument document = this.dataAccessStrategy.toRowDocument(typeToRead, (Readable)row, rowMetadata.getColumnMetadatas());
                return this.converter.project(projection, document);
            };
        }
        if (simpleType) {
            return new UnwrapOptionalFetchSpecAdapter(executeSpec.map((row, metadata) -> Optional.ofNullable(rowMapper.apply((Row)row, (RowMetadata)metadata))));
        }
        return executeSpec.map(rowMapper);
    }

    private class EntityCallbackAdapter<T>
    implements RowsFetchSpec<T> {
        private final RowsFetchSpec<T> delegate;
        private final SqlIdentifier tableName;

        private EntityCallbackAdapter(RowsFetchSpec<T> delegate, SqlIdentifier tableName) {
            this.delegate = delegate;
            this.tableName = tableName;
        }

        public Mono<T> one() {
            return this.delegate.one().flatMap(it -> R2dbcEntityTemplate.this.maybeCallAfterConvert(it, this.tableName));
        }

        public Mono<T> first() {
            return this.delegate.first().flatMap(it -> R2dbcEntityTemplate.this.maybeCallAfterConvert(it, this.tableName));
        }

        public Flux<T> all() {
            return this.delegate.all().concatMap(it -> R2dbcEntityTemplate.this.maybeCallAfterConvert(it, this.tableName));
        }
    }

    private static class UnwrapOptionalFetchSpecAdapter<T>
    implements RowsFetchSpec<T> {
        private final RowsFetchSpec<Optional<T>> delegate;

        private UnwrapOptionalFetchSpecAdapter(RowsFetchSpec<Optional<T>> delegate) {
            this.delegate = delegate;
        }

        public Mono<T> one() {
            return this.delegate.one().handle((optional, sink) -> optional.ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
        }

        public Mono<T> first() {
            return this.delegate.first().handle((optional, sink) -> optional.ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
        }

        public Flux<T> all() {
            return this.delegate.all().handle((optional, sink) -> optional.ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
        }
    }
}

