/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.ReactiveSelectOperation;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import org.springframework.data.r2dbc.repository.support.ReactiveFluentQuerySupport;
import org.springframework.data.r2dbc.repository.support.ReactivePageableExecutionUtils;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.query.RelationalExampleMapper;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Transactional(readOnly=true)
public class SimpleR2dbcRepository<T, ID>
implements R2dbcRepository<T, ID> {
    private final RelationalEntityInformation<T, ID> entity;
    private final R2dbcEntityOperations entityOperations;
    private final Lazy<RelationalPersistentProperty> idProperty;
    private final RelationalExampleMapper exampleMapper;

    public SimpleR2dbcRepository(RelationalEntityInformation<T, ID> entity, R2dbcEntityOperations entityOperations, R2dbcConverter converter) {
        this.entity = entity;
        this.entityOperations = entityOperations;
        this.idProperty = Lazy.of(() -> (RelationalPersistentProperty)((RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty());
        this.exampleMapper = new RelationalExampleMapper(converter.getMappingContext());
    }

    public SimpleR2dbcRepository(RelationalEntityInformation<T, ID> entity, org.springframework.r2dbc.core.DatabaseClient databaseClient, R2dbcConverter converter, ReactiveDataAccessStrategy accessStrategy) {
        this.entity = entity;
        this.entityOperations = new R2dbcEntityTemplate(databaseClient, accessStrategy);
        this.idProperty = Lazy.of(() -> (RelationalPersistentProperty)((RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty());
        this.exampleMapper = new RelationalExampleMapper(converter.getMappingContext());
    }

    @Deprecated
    public SimpleR2dbcRepository(RelationalEntityInformation<T, ID> entity, DatabaseClient databaseClient, R2dbcConverter converter, ReactiveDataAccessStrategy accessStrategy) {
        this.entity = entity;
        this.entityOperations = new R2dbcEntityTemplate(databaseClient, accessStrategy);
        this.idProperty = Lazy.of(() -> (RelationalPersistentProperty)((RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty());
        this.exampleMapper = new RelationalExampleMapper(converter.getMappingContext());
    }

    @Transactional
    public <S extends T> Mono<S> save(S objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        if (this.entity.isNew(objectToSave)) {
            return this.entityOperations.insert(objectToSave);
        }
        return this.entityOperations.update(objectToSave);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Iterable<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Objects to save must not be null!");
        return Flux.fromIterable(objectsToSave).concatMap(this::save);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Publisher<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Object publisher must not be null!");
        return Flux.from(objectsToSave).concatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.selectOne(this.getIdQuery(id), this.entity.getJavaType());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.exists(this.getIdQuery(id), this.entity.getJavaType());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById).hasElement();
    }

    public Flux<T> findAll() {
        return this.entityOperations.select(Query.empty(), this.entity.getJavaType());
    }

    public Flux<T> findAllById(Iterable<ID> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(iterable));
    }

    public Flux<T> findAllById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            String idProperty = this.getIdProperty().getName();
            return this.entityOperations.select(Query.query((CriteriaDefinition)Criteria.where((String)idProperty).in((Collection)ids)), this.entity.getJavaType());
        });
    }

    public Mono<Long> count() {
        return this.entityOperations.count(Query.empty(), this.entity.getJavaType());
    }

    @Transactional
    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.delete(this.getIdQuery(id), this.entity.getJavaType()).then();
    }

    @Transactional
    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            String idProperty = this.getIdProperty().getName();
            return this.entityOperations.delete(Query.query((CriteriaDefinition)Criteria.where((String)idProperty).in((Collection)ids)), this.entity.getJavaType());
        }).then();
    }

    @Transactional
    public Mono<Void> delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        return this.deleteById(this.entity.getRequiredId(objectToDelete));
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The iterable of Id's must not be null!");
        List idsList = Streamable.of(ids).toList();
        String idProperty = this.getIdProperty().getName();
        return this.entityOperations.delete(Query.query((CriteriaDefinition)Criteria.where((String)idProperty).in((Collection)idsList)), this.entity.getJavaType()).then();
    }

    @Transactional
    public Mono<Void> deleteAll(Iterable<? extends T> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(iterable));
    }

    @Transactional
    public Mono<Void> deleteAll(Publisher<? extends T> objectPublisher) {
        Assert.notNull(objectPublisher, (String)"The Object Publisher must not be null!");
        Flux idPublisher = Flux.from(objectPublisher).map(arg_0 -> this.entity.getRequiredId(arg_0));
        return this.deleteById((Publisher<ID>)idPublisher);
    }

    @Transactional
    public Mono<Void> deleteAll() {
        return this.entityOperations.delete(Query.empty(), this.entity.getJavaType()).then();
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.entityOperations.select(Query.empty().sort(sort), this.entity.getJavaType());
    }

    public <S extends T> Mono<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        Query query = this.exampleMapper.getMappedExample(example);
        return this.entityOperations.selectOne(query, example.getProbeType());
    }

    public <S extends T> Flux<S> findAll(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        return this.findAll(example, Sort.unsorted());
    }

    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Example must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Query query = this.exampleMapper.getMappedExample(example).sort(sort);
        return this.entityOperations.select(query, example.getProbeType());
    }

    public <S extends T> Mono<Long> count(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        Query query = this.exampleMapper.getMappedExample(example);
        return this.entityOperations.count(query, example.getProbeType());
    }

    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        Query query = this.exampleMapper.getMappedExample(example);
        return this.entityOperations.exists(query, example.getProbeType());
    }

    public <S extends T, R, P extends Publisher<R>> P findBy(Example<S> example, Function<FluentQuery.ReactiveFluentQuery<S>, P> queryFunction) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Assert.notNull(queryFunction, (String)"Query function must not be null!");
        return (P)((Publisher)queryFunction.apply(new ReactiveFluentQueryByExample(example, example.getProbeType())));
    }

    private RelationalPersistentProperty getIdProperty() {
        return (RelationalPersistentProperty)this.idProperty.get();
    }

    private Query getIdQuery(Object id) {
        return Query.query((CriteriaDefinition)Criteria.where((String)this.getIdProperty().getName()).is(id));
    }

    class ReactiveFluentQueryByExample<S, T>
    extends ReactiveFluentQuerySupport<Example<S>, T> {
        ReactiveFluentQueryByExample(Example<S> example, Class<T> resultType) {
            this(example, Sort.unsorted(), resultType, Collections.emptyList());
        }

        ReactiveFluentQueryByExample(Example<S> example, Sort sort, Class<T> resultType, List<String> fieldsToInclude) {
            super(example, sort, resultType, fieldsToInclude);
        }

        @Override
        protected <R> ReactiveFluentQueryByExample<S, R> create(Example<S> predicate, Sort sort, Class<R> resultType, List<String> fieldsToInclude) {
            return new ReactiveFluentQueryByExample<S, R>(predicate, sort, resultType, fieldsToInclude);
        }

        public Mono<T> one() {
            return this.createQuery().one();
        }

        public Mono<T> first() {
            return this.createQuery().first();
        }

        public Flux<T> all() {
            return this.createQuery().all();
        }

        public Mono<Page<T>> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            Mono items = this.createQuery(q -> q.with(pageable)).all().collectList();
            return items.flatMap(content -> ReactivePageableExecutionUtils.getPage(content, pageable, this.count()));
        }

        public Mono<Long> count() {
            return this.createQuery().count();
        }

        public Mono<Boolean> exists() {
            return this.createQuery().exists();
        }

        private ReactiveSelectOperation.TerminatingSelect<T> createQuery() {
            return this.createQuery(UnaryOperator.identity());
        }

        private ReactiveSelectOperation.TerminatingSelect<T> createQuery(UnaryOperator<Query> queryCustomizer) {
            Query query = SimpleR2dbcRepository.this.exampleMapper.getMappedExample((Example)this.getPredicate());
            if (this.getSort().isSorted()) {
                query = query.sort(this.getSort());
            }
            if (!this.getFieldsToInclude().isEmpty()) {
                query = query.columns(this.getFieldsToInclude().toArray(new String[0]));
            }
            query = (Query)queryCustomizer.apply(query);
            ReactiveSelectOperation.ReactiveSelect select = SimpleR2dbcRepository.this.entityOperations.select(((Example)this.getPredicate()).getProbeType());
            if (this.getResultType() != ((Example)this.getPredicate()).getProbeType()) {
                return select.as(this.getResultType()).matching(query);
            }
            return select.matching(query);
        }
    }
}

