/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.repository.reactive.ReactiveCrudRepository;
import org.springframework.data.util.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Transactional(readOnly=true)
public class SimpleR2dbcRepository<T, ID>
implements ReactiveCrudRepository<T, ID> {
    private final RelationalEntityInformation<T, ID> entity;
    private final R2dbcEntityOperations entityOperations;
    private final Lazy<RelationalPersistentProperty> idProperty;

    SimpleR2dbcRepository(RelationalEntityInformation<T, ID> entity, R2dbcEntityOperations entityOperations, R2dbcConverter converter) {
        this.entity = entity;
        this.entityOperations = entityOperations;
        this.idProperty = Lazy.of(() -> (RelationalPersistentProperty)((RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty());
    }

    public SimpleR2dbcRepository(RelationalEntityInformation<T, ID> entity, DatabaseClient databaseClient, R2dbcConverter converter, ReactiveDataAccessStrategy accessStrategy) {
        this.entity = entity;
        this.entityOperations = new R2dbcEntityTemplate(databaseClient);
        this.idProperty = Lazy.of(() -> (RelationalPersistentProperty)((RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty());
    }

    @Transactional
    public <S extends T> Mono<S> save(S objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        if (this.entity.isNew(objectToSave)) {
            return this.entityOperations.insert(objectToSave);
        }
        return this.entityOperations.update(objectToSave);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Iterable<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Objects to save must not be null!");
        return Flux.fromIterable(objectsToSave).concatMap(this::save);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Publisher<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Object publisher must not be null!");
        return Flux.from(objectsToSave).concatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.selectOne(this.getIdQuery(id), this.entity.getJavaType());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.exists(this.getIdQuery(id), this.entity.getJavaType());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById).hasElement();
    }

    public Flux<T> findAll() {
        return this.entityOperations.select(Query.empty(), this.entity.getJavaType());
    }

    public Flux<T> findAllById(Iterable<ID> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(iterable));
    }

    public Flux<T> findAllById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            String idProperty = this.getIdProperty().getName();
            return this.entityOperations.select(Query.query((CriteriaDefinition)Criteria.where((String)idProperty).in((Collection)ids)), this.entity.getJavaType());
        });
    }

    public Mono<Long> count() {
        return this.entityOperations.count(Query.empty(), this.entity.getJavaType());
    }

    @Transactional
    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.entityOperations.delete(this.getIdQuery(id), this.entity.getJavaType()).then();
    }

    @Transactional
    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            String idProperty = this.getIdProperty().getName();
            return this.entityOperations.delete(Query.query((CriteriaDefinition)Criteria.where((String)idProperty).in((Collection)ids)), this.entity.getJavaType());
        }).then();
    }

    @Transactional
    public Mono<Void> delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        return this.deleteById(this.entity.getRequiredId(objectToDelete));
    }

    @Transactional
    public Mono<Void> deleteAll(Iterable<? extends T> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(iterable));
    }

    @Transactional
    public Mono<Void> deleteAll(Publisher<? extends T> objectPublisher) {
        Assert.notNull(objectPublisher, (String)"The Object Publisher must not be null!");
        Flux idPublisher = Flux.from(objectPublisher).map(arg_0 -> this.entity.getRequiredId(arg_0));
        return this.deleteById((Publisher<ID>)idPublisher);
    }

    @Transactional
    public Mono<Void> deleteAll() {
        return this.entityOperations.delete(Query.empty(), this.entity.getJavaType()).then();
    }

    private RelationalPersistentProperty getIdProperty() {
        return (RelationalPersistentProperty)this.idProperty.get();
    }

    private Query getIdQuery(Object id) {
        return Query.query((CriteriaDefinition)Criteria.where((String)this.getIdProperty().getName()).is(id));
    }
}

