/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.DtoInstantiatingConverter;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;

interface R2dbcQueryExecution {
    public Object execute(FetchSpec<?> var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
        private final EntityInstantiators instantiators;

        ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (Void.class == returnedType.getReturnedType() || ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }

    public static final class ResultProcessingExecution
    implements R2dbcQueryExecution {
        private final R2dbcQueryExecution delegate;
        private final Converter<Object, Object> converter;

        ResultProcessingExecution(R2dbcQueryExecution delegate, Converter<Object, Object> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Object execute(FetchSpec<?> query, Class<?> type, String tableName) {
            return this.converter.convert(this.delegate.execute(query, type, tableName));
        }
    }
}

