/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.UncategorizedR2dbcException;
import org.springframework.data.r2dbc.connectionfactory.ConnectionFactoryUtils;
import org.springframework.data.r2dbc.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.convert.ColumnMapRowMapper;
import org.springframework.data.r2dbc.core.ConnectionAccessor;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.core.DefaultSqlResult;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.SqlProvider;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.core.UpdatedRowsFetchSpec;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultDatabaseClient
implements DatabaseClient,
ConnectionAccessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConnectionFactory connector;
    private final R2dbcExceptionTranslator exceptionTranslator;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final boolean namedParameters;
    private final DefaultDatabaseClientBuilder builder;

    DefaultDatabaseClient(ConnectionFactory connector, R2dbcExceptionTranslator exceptionTranslator, ReactiveDataAccessStrategy dataAccessStrategy, boolean namedParameters, DefaultDatabaseClientBuilder builder) {
        this.connector = connector;
        this.exceptionTranslator = exceptionTranslator;
        this.dataAccessStrategy = dataAccessStrategy;
        this.namedParameters = namedParameters;
        this.builder = builder;
    }

    @Override
    public DatabaseClient.Builder mutate() {
        return this.builder;
    }

    @Override
    public DatabaseClient.SelectFromSpec select() {
        return new DefaultSelectFromSpec();
    }

    @Override
    public DatabaseClient.InsertIntoSpec insert() {
        return new DefaultInsertIntoSpec();
    }

    @Override
    public DatabaseClient.UpdateTableSpec update() {
        return new DefaultUpdateTableSpec();
    }

    @Override
    public DatabaseClient.DeleteFromSpec delete() {
        return new DefaultDeleteFromSpec();
    }

    @Override
    public DatabaseClient.GenericExecuteSpec execute(String sql) {
        Assert.hasText((String)sql, (String)"SQL must not be null or empty!");
        return this.execute(() -> sql);
    }

    @Override
    public DatabaseClient.GenericExecuteSpec execute(Supplier<String> sqlSupplier) {
        Assert.notNull(sqlSupplier, (String)"SQL Supplier must not be null!");
        return this.createGenericExecuteSpec(sqlSupplier);
    }

    @Override
    public <T> Mono<T> inConnection(Function<Connection, Mono<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(it -> new ConnectionCloseHolder((Connection)it, this::closeConnection));
        return Mono.usingWhen((Publisher)connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy(it.connection);
            return DefaultDatabaseClient.doInConnection(connectionToUse, action);
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> this.translateException("execute", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    @Override
    public <T> Flux<T> inConnectionMany(Function<Connection, Flux<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(it -> new ConnectionCloseHolder((Connection)it, this::closeConnection));
        return Flux.usingWhen((Publisher)connectionMono, it -> {
            Connection connectionToUse = this.createConnectionProxy(it.connection);
            return DefaultDatabaseClient.doInConnectionMany(connectionToUse, action);
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> this.translateException("executeMany", DefaultDatabaseClient.getSql(action), (R2dbcException)ex));
    }

    protected Mono<Connection> getConnection() {
        return ConnectionFactoryUtils.getConnection(this.obtainConnectionFactory());
    }

    protected Publisher<Void> closeConnection(Connection connection) {
        return ConnectionFactoryUtils.currentConnectionFactory(this.obtainConnectionFactory()).then().onErrorResume(Exception.class, e -> Mono.from((Publisher)connection.close()));
    }

    protected ConnectionFactory obtainConnectionFactory() {
        return this.connector;
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    protected DataAccessException translateException(String task, @Nullable String sql, R2dbcException ex) {
        DataAccessException dae = this.exceptionTranslator.translate(task, sql, ex);
        return dae != null ? dae : new UncategorizedR2dbcException(task, sql, ex);
    }

    protected <T> DefaultTypedExecuteSpec<T> createTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, Class<T> typeToRead) {
        return new DefaultTypedExecuteSpec<T>(byIndex, byName, sqlSupplier, typeToRead);
    }

    protected <T> DefaultTypedExecuteSpec<T> createTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
        return new DefaultTypedExecuteSpec<T>(byIndex, byName, sqlSupplier, mappingFunction);
    }

    protected ExecuteSpecSupport createGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
        return new DefaultGenericExecuteSpec(byIndex, byName, sqlSupplier);
    }

    protected DefaultGenericExecuteSpec createGenericExecuteSpec(Supplier<String> sqlSupplier) {
        return new DefaultGenericExecuteSpec(sqlSupplier);
    }

    private static void bindByName(Statement statement, Map<String, SettableValue> byName) {
        byName.forEach((name, o) -> {
            if (o.getValue() != null) {
                statement.bind(name, o.getValue());
            } else {
                statement.bindNull(name, o.getType());
            }
        });
    }

    private static void bindByIndex(Statement statement, Map<Integer, SettableValue> byIndex) {
        byIndex.forEach((i, o) -> {
            if (o.getValue() != null) {
                statement.bind(i.intValue(), o.getValue());
            } else {
                statement.bindNull(i.intValue(), o.getType());
            }
        });
    }

    private <R> FetchSpec<R> exchangeInsert(BiFunction<Row, RowMetadata, R> mappingFunction, PreparedOperation<?> operation) {
        String sql = DefaultDatabaseClient.getRequiredSql(operation);
        Function<Connection, Statement> insertFunction = this.wrapPreparedOperation(sql, operation).andThen(statement -> statement.returnGeneratedValues(new String[0]));
        Function<Connection, Flux<Result>> resultFunction = DefaultDatabaseClient.toExecuteFunction(sql, insertFunction);
        return new DefaultSqlResult<R>(this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), mappingFunction);
    }

    private UpdatedRowsFetchSpec exchangeUpdate(PreparedOperation<?> operation) {
        String sql = DefaultDatabaseClient.getRequiredSql(operation);
        Function<Connection, Statement> executeFunction = this.wrapPreparedOperation(sql, operation);
        Function<Connection, Flux<Result>> resultFunction = DefaultDatabaseClient.toExecuteFunction(sql, executeFunction);
        return new DefaultSqlResult<RowMetadata>(this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), (row, rowMetadata) -> rowMetadata);
    }

    private static Mono<Integer> sumRowsUpdated(Function<Connection, Flux<Result>> resultFunction, Connection it) {
        return resultFunction.apply(it).flatMap(Result::getRowsUpdated).collect(Collectors.summingInt(Integer::intValue));
    }

    private Function<Connection, Statement> wrapPreparedOperation(String sql, PreparedOperation<?> operation) {
        return it -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
            }
            Statement statement = it.createStatement(sql);
            operation.bindTo(new StatementWrapper(statement));
            return statement;
        };
    }

    private static Function<Connection, Flux<Result>> toExecuteFunction(String sql, Function<Connection, Statement> executeFunction) {
        return it -> {
            Flux from = Flux.defer(() -> ((Statement)executeFunction.apply((Connection)it)).execute()).cast(Result.class);
            return from.checkpoint("SQL \"" + sql + "\" [DatabaseClient]");
        };
    }

    private static <T> Flux<T> doInConnectionMany(Connection connection, Function<Connection, Flux<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Flux.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnectionMany", sql, e)));
        }
    }

    private static <T> Mono<T> doInConnection(Connection connection, Function<Connection, Mono<T>> action) {
        try {
            return action.apply(connection);
        }
        catch (R2dbcException e) {
            String sql = DefaultDatabaseClient.getSql(action);
            return Mono.error((Throwable)((Object)new UncategorizedR2dbcException("doInConnection", sql, e)));
        }
    }

    @Nullable
    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static String getRequiredSql(Supplier<String> sqlSupplier) {
        String sql = sqlSupplier.get();
        Assert.state((boolean)StringUtils.hasText((String)sql), (String)"SQL returned by SQL supplier must not be empty!");
        return sql;
    }

    static class StatementWrapper
    implements BindTarget {
        final Statement statement;

        StatementWrapper(Statement statement) {
            this.statement = statement;
        }

        @Override
        public void bind(String identifier, Object value) {
            this.statement.bind(identifier, value);
        }

        @Override
        public void bind(int index, Object value) {
            this.statement.bind(index, value);
        }

        @Override
        public void bindNull(String identifier, Class<?> type) {
            this.statement.bindNull(identifier, type);
        }

        @Override
        public void bindNull(int index, Class<?> type) {
            this.statement.bindNull(index, type);
        }
    }

    static class ConnectionCloseHolder
    extends AtomicBoolean {
        private static final long serialVersionUID = -8994138383301201380L;
        final Connection connection;
        final Function<Connection, Publisher<Void>> closeFunction;

        ConnectionCloseHolder(Connection connection, Function<Connection, Publisher<Void>> closeFunction) {
            this.connection = connection;
            this.closeFunction = closeFunction;
        }

        Mono<Void> close() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    return Mono.from(this.closeFunction.apply(this.connection));
                }
                return Mono.empty();
            });
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                return this.target;
            }
            if (method.getName().equals("close")) {
                return Mono.error((Throwable)new UnsupportedOperationException("Close is not supported!"));
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    class DefaultDeleteSpec<T>
    implements DatabaseClient.DeleteMatchingSpec,
    DatabaseClient.TypedDeleteSpec<T> {
        @Nullable
        private final Class<T> typeToDelete;
        @Nullable
        private final String table;
        private final Criteria where;

        DefaultDeleteSpec(@Nullable Class<T> typeToDelete, String table, Criteria where) {
            this.typeToDelete = typeToDelete;
            this.table = table;
            this.where = where;
        }

        @Override
        public DatabaseClient.DeleteSpec matching(Criteria criteria) {
            Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
            return new DefaultDeleteSpec<T>(this.typeToDelete, this.table, criteria);
        }

        @Override
        public DatabaseClient.TypedDeleteSpec<T> table(String tableName) {
            Assert.hasText((String)tableName, (String)"Table name must not be null or empty!");
            return new DefaultDeleteSpec<T>(this.typeToDelete, tableName, this.where);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            String table = StringUtils.isEmpty((Object)this.table) ? DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToDelete) : this.table;
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(String table) {
            StatementMapper.TypedStatementMapper<T> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            if (this.typeToDelete != null) {
                mapper = mapper.forType(this.typeToDelete);
            }
            StatementMapper.DeleteSpec delete = mapper.createDelete(table);
            if (this.where != null) {
                delete = delete.withCriteria(this.where);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(delete);
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultDeleteFromSpec
    implements DatabaseClient.DeleteFromSpec {
        DefaultDeleteFromSpec() {
        }

        @Override
        public DefaultDeleteSpec<?> from(String table) {
            return new DefaultDeleteSpec(null, table, null);
        }

        public <T> DefaultDeleteSpec<T> from(Class<T> table) {
            return new DefaultDeleteSpec<T>(table, null, null);
        }
    }

    class DefaultTypedUpdateSpec<T>
    implements DatabaseClient.TypedUpdateSpec<T>,
    DatabaseClient.UpdateSpec {
        @Nullable
        private final Class<T> typeToUpdate;
        @Nullable
        private final String table;
        private final T objectToUpdate;

        DefaultTypedUpdateSpec(@Nullable Class<T> typeToUpdate, String table, T objectToUpdate) {
            this.typeToUpdate = typeToUpdate;
            this.table = table;
            this.objectToUpdate = objectToUpdate;
        }

        @Override
        public DatabaseClient.UpdateSpec using(T objectToUpdate) {
            Assert.notNull(objectToUpdate, (String)"Object to update must not be null");
            return new DefaultTypedUpdateSpec<T>(this.typeToUpdate, this.table, objectToUpdate);
        }

        @Override
        public DatabaseClient.TypedUpdateSpec<T> table(String tableName) {
            Assert.hasText((String)tableName, (String)"Table name must not be null or empty!");
            return new DefaultTypedUpdateSpec<T>(this.typeToUpdate, tableName, this.objectToUpdate);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            String table = StringUtils.isEmpty((Object)this.table) ? DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToUpdate) : this.table;
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(String table) {
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            OutboundRow columns = DefaultDatabaseClient.this.dataAccessStrategy.getOutboundRow(this.objectToUpdate);
            List<String> ids = DefaultDatabaseClient.this.dataAccessStrategy.getIdentifierColumns(this.typeToUpdate);
            if (ids.isEmpty()) {
                throw new IllegalStateException("No identifier columns in " + this.typeToUpdate.getName() + "!");
            }
            Object id = columns.remove(ids.get(0));
            Update update = null;
            for (String column : columns.keySet()) {
                if (update == null) {
                    update = Update.update(column, columns.get(column));
                    continue;
                }
                update = update.set(column, columns.get(column));
            }
            PreparedOperation<?> operation = mapper.getMappedObject(mapper.createUpdate(table, update).withCriteria(Criteria.where(ids.get(0)).is(id)));
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultGenericUpdateSpec
    implements DatabaseClient.GenericUpdateSpec,
    DatabaseClient.UpdateMatchingSpec {
        @Nullable
        private final Class<?> typeToUpdate;
        @Nullable
        private final String table;
        private final Update assignments;
        private final Criteria where;

        DefaultGenericUpdateSpec(@Nullable Class<?> typeToUpdate, String table, Update assignments, Criteria where) {
            this.typeToUpdate = typeToUpdate;
            this.table = table;
            this.assignments = assignments;
            this.where = where;
        }

        @Override
        public DatabaseClient.UpdateMatchingSpec using(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return new DefaultGenericUpdateSpec(this.typeToUpdate, this.table, update, this.where);
        }

        @Override
        public DatabaseClient.UpdateSpec matching(Criteria criteria) {
            Assert.notNull((Object)criteria, (String)"Criteria must not be null");
            return new DefaultGenericUpdateSpec(this.typeToUpdate, this.table, this.assignments, criteria);
        }

        @Override
        public UpdatedRowsFetchSpec fetch() {
            String table = StringUtils.isEmpty((Object)this.table) ? DefaultDatabaseClient.this.dataAccessStrategy.getTableName(this.typeToUpdate) : this.table;
            return this.exchange(table);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private UpdatedRowsFetchSpec exchange(String table) {
            StatementMapper.TypedStatementMapper<?> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            if (this.typeToUpdate != null) {
                mapper = mapper.forType(this.typeToUpdate);
            }
            StatementMapper.UpdateSpec update = mapper.createUpdate(table, this.assignments);
            if (this.where != null) {
                update = update.withCriteria(this.where);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(update);
            return DefaultDatabaseClient.this.exchangeUpdate(operation);
        }
    }

    class DefaultUpdateTableSpec
    implements DatabaseClient.UpdateTableSpec {
        DefaultUpdateTableSpec() {
        }

        @Override
        public DatabaseClient.GenericUpdateSpec table(String table) {
            return new DefaultGenericUpdateSpec(null, table, null, null);
        }

        @Override
        public <T> DatabaseClient.TypedUpdateSpec<T> table(Class<T> table) {
            return new DefaultTypedUpdateSpec<Object>(table, null, null);
        }
    }

    class DefaultTypedInsertSpec<T, R>
    implements DatabaseClient.TypedInsertSpec<T>,
    DatabaseClient.InsertSpec<R> {
        private final Class<?> typeToInsert;
        private final String table;
        private final Publisher<T> objectToInsert;
        private final BiFunction<Row, RowMetadata, R> mappingFunction;

        DefaultTypedInsertSpec(Class<?> typeToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToInsert);
            this.objectToInsert = Mono.empty();
            this.mappingFunction = mappingFunction;
        }

        DefaultTypedInsertSpec(Class<?> typeToInsert, String table, Publisher<T> objectToInsert, BiFunction<Row, RowMetadata, R> mappingFunction) {
            this.typeToInsert = typeToInsert;
            this.table = table;
            this.objectToInsert = objectToInsert;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public DatabaseClient.TypedInsertSpec<T> table(String tableName) {
            Assert.hasText((String)tableName, (String)"Table name must not be null or empty!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, tableName, this.objectToInsert, this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(T objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Object to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, Mono.just(objectToInsert), this.mappingFunction);
        }

        @Override
        public DatabaseClient.InsertSpec using(Publisher<T> objectToInsert) {
            Assert.notNull(objectToInsert, (String)"Publisher to insert must not be null!");
            return new DefaultTypedInsertSpec<T, R>(this.typeToInsert, this.table, objectToInsert, this.mappingFunction);
        }

        @Override
        public <MR> FetchSpec<MR> map(Function<Row, MR> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <MR> FetchSpec<MR> map(BiFunction<Row, RowMetadata, MR> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<R> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return Mono.from(this.objectToInsert).flatMapMany(toInsert -> this.exchange(toInsert, (row, md) -> row).all()).then();
        }

        private <MR> FetchSpec<MR> exchange(final BiFunction<Row, RowMetadata, MR> mappingFunction) {
            return new FetchSpec<MR>(){

                @Override
                public Mono<MR> one() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).one());
                }

                @Override
                public Mono<MR> first() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).first());
                }

                @Override
                public Flux<MR> all() {
                    return Flux.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMap(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).all());
                }

                @Override
                public Mono<Integer> rowsUpdated() {
                    return Mono.from((Publisher)DefaultTypedInsertSpec.this.objectToInsert).flatMapMany(toInsert -> DefaultTypedInsertSpec.this.exchange(toInsert, mappingFunction).rowsUpdated()).collect(Collectors.summingInt(Integer::intValue));
                }
            };
        }

        private <MR> FetchSpec<MR> exchange(Object toInsert, BiFunction<Row, RowMetadata, MR> mappingFunction) {
            OutboundRow outboundRow = DefaultDatabaseClient.this.dataAccessStrategy.getOutboundRow(toInsert);
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.InsertSpec insert = mapper.createInsert(this.table);
            for (String column : outboundRow.keySet()) {
                SettableValue settableValue = outboundRow.get(column);
                if (!settableValue.hasValue()) continue;
                insert = insert.withColumn(column, settableValue);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(insert);
            return DefaultDatabaseClient.this.exchangeInsert(mappingFunction, operation);
        }
    }

    class DefaultGenericInsertSpec<T>
    implements DatabaseClient.GenericInsertSpec<T> {
        private final String table;
        private final Map<String, SettableValue> byName;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultGenericInsertSpec(String table, Map<String, SettableValue> byName, BiFunction<Row, RowMetadata, T> mappingFunction) {
            this.table = table;
            this.byName = byName;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public DatabaseClient.GenericInsertSpec<T> value(String field, Object value) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            if (value instanceof SettableValue) {
                byName.put(field, (SettableValue)value);
            } else {
                byName.put(field, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return new DefaultGenericInsertSpec<T>(this.table, byName, this.mappingFunction);
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            if (this.byName.isEmpty()) {
                throw new IllegalStateException("Insert fields is empty!");
            }
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.InsertSpec insert = mapper.createInsert(this.table);
            for (String column : this.byName.keySet()) {
                insert = insert.withColumn(column, this.byName.get(column));
            }
            PreparedOperation<?> operation = mapper.getMappedObject(insert);
            return DefaultDatabaseClient.this.exchangeInsert(mappingFunction, operation);
        }
    }

    class DefaultInsertIntoSpec
    implements DatabaseClient.InsertIntoSpec {
        DefaultInsertIntoSpec() {
        }

        @Override
        public DatabaseClient.GenericInsertSpec<Map<String, Object>> into(String table) {
            return new DefaultGenericInsertSpec<Map<String, Object>>(table, Collections.emptyMap(), ColumnMapRowMapper.INSTANCE);
        }

        @Override
        public <T> DatabaseClient.TypedInsertSpec<T> into(Class<T> table) {
            return new DefaultTypedInsertSpec(table, ColumnMapRowMapper.INSTANCE);
        }
    }

    private class DefaultTypedSelectSpec<T>
    extends DefaultSelectSpecSupport
    implements DatabaseClient.TypedSelectSpec<T> {
        @Nullable
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedSelectSpec(Class<T> typeToRead) {
            super(DefaultDatabaseClient.this.dataAccessStrategy.getTableName(typeToRead));
            this.typeToRead = typeToRead;
            this.mappingFunction = DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        DefaultTypedSelectSpec(String table, List<String> projectedFields, Criteria criteria, Sort sort, @Nullable Pageable page, Class<T> typeToRead, BiFunction<Row, RowMetadata, T> mappingFunction) {
            super(table, projectedFields, criteria, sort, page);
            this.typeToRead = typeToRead;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public <R> FetchSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return this.exchange(DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType));
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultTypedSelectSpec<T> project(String ... selectedFields) {
            return (DefaultTypedSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultTypedSelectSpec<T> matching(Criteria criteria) {
            return (DefaultTypedSelectSpec)super.where(criteria);
        }

        @Override
        public DefaultTypedSelectSpec<T> orderBy(Sort sort) {
            return (DefaultTypedSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultTypedSelectSpec<T> page(Pageable pageable) {
            return (DefaultTypedSelectSpec)super.page(pageable);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.mappingFunction);
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            StatementMapper.TypedStatementMapper<T> mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper().forType(this.typeToRead);
            List<String> columns = this.projectedFields.isEmpty() ? DefaultDatabaseClient.this.dataAccessStrategy.getAllColumns(this.typeToRead) : this.projectedFields;
            StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.table).withProjection(columns).withPage(this.page).withSort(this.sort);
            if (this.criteria != null) {
                selectSpec = selectSpec.withCriteria(this.criteria);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
            return this.execute(operation, mappingFunction);
        }

        @Override
        protected DefaultTypedSelectSpec<T> createInstance(String table, List<String> projectedFields, Criteria criteria, Sort sort, Pageable page) {
            return new DefaultTypedSelectSpec<T>(table, projectedFields, criteria, sort, page, this.typeToRead, this.mappingFunction);
        }
    }

    private class DefaultGenericSelectSpec
    extends DefaultSelectSpecSupport
    implements DatabaseClient.GenericSelectSpec {
        DefaultGenericSelectSpec(String table, List<String> projectedFields, Criteria criteria, Sort sort, Pageable page) {
            super(table, projectedFields, criteria, sort, page);
        }

        DefaultGenericSelectSpec(String table) {
            super(table);
        }

        @Override
        public <R> DatabaseClient.TypedSelectSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return new DefaultTypedSelectSpec<R>(this.table, this.projectedFields, this.criteria, this.sort, this.page, resultType, DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(resultType));
        }

        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange((row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(mappingFunction);
        }

        @Override
        public DefaultGenericSelectSpec project(String ... selectedFields) {
            return (DefaultGenericSelectSpec)super.project(selectedFields);
        }

        @Override
        public DefaultGenericSelectSpec matching(Criteria criteria) {
            return (DefaultGenericSelectSpec)super.where(criteria);
        }

        @Override
        public DefaultGenericSelectSpec orderBy(Sort sort) {
            return (DefaultGenericSelectSpec)super.orderBy(sort);
        }

        @Override
        public DefaultGenericSelectSpec page(Pageable pageable) {
            return (DefaultGenericSelectSpec)super.page(pageable);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange(ColumnMapRowMapper.INSTANCE);
        }

        private <R> FetchSpec<R> exchange(BiFunction<Row, RowMetadata, R> mappingFunction) {
            StatementMapper mapper = DefaultDatabaseClient.this.dataAccessStrategy.getStatementMapper();
            StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.table).withProjection(this.projectedFields).withSort(this.sort).withPage(this.page);
            if (this.criteria != null) {
                selectSpec = selectSpec.withCriteria(this.criteria);
            }
            PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
            return this.execute(operation, mappingFunction);
        }

        @Override
        protected DefaultGenericSelectSpec createInstance(String table, List<String> projectedFields, Criteria criteria, Sort sort, Pageable page) {
            return new DefaultGenericSelectSpec(table, projectedFields, criteria, sort, page);
        }
    }

    private abstract class DefaultSelectSpecSupport {
        final String table;
        final List<String> projectedFields;
        @Nullable
        final Criteria criteria;
        final Sort sort;
        final Pageable page;

        DefaultSelectSpecSupport(String table) {
            Assert.hasText((String)table, (String)"Table name must not be null!");
            this.table = table;
            this.projectedFields = Collections.emptyList();
            this.criteria = null;
            this.sort = Sort.unsorted();
            this.page = Pageable.unpaged();
        }

        DefaultSelectSpecSupport(String table, List<String> projectedFields, Criteria criteria, Sort sort, Pageable page) {
            this.table = table;
            this.projectedFields = projectedFields;
            this.criteria = criteria;
            this.sort = sort;
            this.page = page;
        }

        public DefaultSelectSpecSupport project(String ... selectedFields) {
            Assert.notNull((Object)selectedFields, (String)"Projection fields must not be null!");
            ArrayList<String> projectedFields = new ArrayList<String>(this.projectedFields.size() + selectedFields.length);
            projectedFields.addAll(this.projectedFields);
            projectedFields.addAll(Arrays.asList(selectedFields));
            return this.createInstance(this.table, projectedFields, this.criteria, this.sort, this.page);
        }

        public DefaultSelectSpecSupport where(Criteria whereCriteria) {
            Assert.notNull((Object)whereCriteria, (String)"Criteria must not be null!");
            return this.createInstance(this.table, this.projectedFields, whereCriteria, this.sort, this.page);
        }

        public DefaultSelectSpecSupport orderBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null!");
            return this.createInstance(this.table, this.projectedFields, this.criteria, sort, this.page);
        }

        public DefaultSelectSpecSupport page(Pageable page) {
            Assert.notNull((Object)page, (String)"Pageable must not be null!");
            return this.createInstance(this.table, this.projectedFields, this.criteria, this.sort, page);
        }

        <R> FetchSpec<R> execute(PreparedOperation<?> preparedOperation, BiFunction<Row, RowMetadata, R> mappingFunction) {
            String sql = DefaultDatabaseClient.getRequiredSql(preparedOperation);
            Function selectFunction = DefaultDatabaseClient.this.wrapPreparedOperation(sql, preparedOperation);
            Function resultFunction = DefaultDatabaseClient.toExecuteFunction(sql, selectFunction);
            return new DefaultSqlResult<R>(DefaultDatabaseClient.this, sql, resultFunction, it -> Mono.error((Throwable)new UnsupportedOperationException("Not available for SELECT")), mappingFunction);
        }

        protected abstract DefaultSelectSpecSupport createInstance(String var1, List<String> var2, Criteria var3, Sort var4, Pageable var5);
    }

    class DefaultSelectFromSpec
    implements DatabaseClient.SelectFromSpec {
        DefaultSelectFromSpec() {
        }

        @Override
        public DatabaseClient.GenericSelectSpec from(String table) {
            return new DefaultGenericSelectSpec(table);
        }

        @Override
        public <T> DatabaseClient.TypedSelectSpec<T> from(Class<T> table) {
            return new DefaultTypedSelectSpec<T>(table);
        }
    }

    protected class DefaultTypedExecuteSpec<T>
    extends ExecuteSpecSupport
    implements DatabaseClient.TypedExecuteSpec<T> {
        private final Class<T> typeToRead;
        private final BiFunction<Row, RowMetadata, T> mappingFunction;

        DefaultTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, Class<T> typeToRead) {
            super(byIndex, byName, sqlSupplier);
            this.typeToRead = typeToRead;
            this.mappingFunction = DefaultDatabaseClient.this.dataAccessStrategy.getRowMapper(typeToRead);
        }

        DefaultTypedExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
            super(byIndex, byName, sqlSupplier);
            this.typeToRead = null;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec((Map<Integer, SettableValue>)this.byIndex, (Map<String, SettableValue>)this.byName, (Supplier<String>)this.sqlSupplier, resultType);
        }

        @Override
        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, (row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        @Override
        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, mappingFunction);
        }

        @Override
        public FetchSpec<T> fetch() {
            return this.exchange(this.sqlSupplier, this.mappingFunction);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(int index, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(int index, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bind(String name, Object value) {
            return (DefaultTypedExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultTypedExecuteSpec<T> bindNull(String name, Class<?> type) {
            return (DefaultTypedExecuteSpec)super.bindNull(name, type);
        }

        @Override
        protected DefaultTypedExecuteSpec<T> createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return DefaultDatabaseClient.this.createTypedExecuteSpec(byIndex, byName, sqlSupplier, this.typeToRead);
        }
    }

    protected class DefaultGenericExecuteSpec
    extends ExecuteSpecSupport
    implements DatabaseClient.GenericExecuteSpec {
        DefaultGenericExecuteSpec(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            super(byIndex, byName, sqlSupplier);
        }

        DefaultGenericExecuteSpec(Supplier<String> sqlSupplier) {
            super(sqlSupplier);
        }

        @Override
        public <R> DatabaseClient.TypedExecuteSpec<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null!");
            return DefaultDatabaseClient.this.createTypedExecuteSpec((Map<Integer, SettableValue>)this.byIndex, (Map<String, SettableValue>)this.byName, (Supplier<String>)this.sqlSupplier, resultType);
        }

        public <R> FetchSpec<R> map(Function<Row, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, (row, rowMetadata) -> mappingFunction.apply((Row)row));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null!");
            return this.exchange(this.sqlSupplier, mappingFunction);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.exchange(this.sqlSupplier, ColumnMapRowMapper.INSTANCE);
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        @Override
        public DefaultGenericExecuteSpec bind(int index, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(index, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(int index, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(index, type);
        }

        @Override
        public DefaultGenericExecuteSpec bind(String name, Object value) {
            return (DefaultGenericExecuteSpec)super.bind(name, value);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(String name, Class<?> type) {
            return (DefaultGenericExecuteSpec)super.bindNull(name, type);
        }

        @Override
        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return DefaultDatabaseClient.this.createGenericExecuteSpec(byIndex, byName, sqlSupplier);
        }
    }

    class ExecuteSpecSupport {
        final Map<Integer, SettableValue> byIndex;
        final Map<String, SettableValue> byName;
        final Supplier<String> sqlSupplier;

        ExecuteSpecSupport(Supplier<String> sqlSupplier) {
            this.byIndex = Collections.emptyMap();
            this.byName = Collections.emptyMap();
            this.sqlSupplier = sqlSupplier;
        }

        ExecuteSpecSupport(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            this.byIndex = byIndex;
            this.byName = byName;
            this.sqlSupplier = sqlSupplier;
        }

        <T> FetchSpec<T> exchange(Supplier<String> sqlSupplier, BiFunction<Row, RowMetadata, T> mappingFunction) {
            String sql = DefaultDatabaseClient.getRequiredSql(sqlSupplier);
            Function<Connection, Statement> executeFunction = it -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                if (sqlSupplier instanceof PreparedOperation) {
                    Statement statement = it.createStatement(sql);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    ((PreparedOperation)sqlSupplier).bindTo(bindTarget);
                    return statement;
                }
                if (DefaultDatabaseClient.this.namedParameters) {
                    LinkedHashMap<String, SettableValue> remainderByName = new LinkedHashMap<String, SettableValue>(this.byName);
                    LinkedHashMap<Integer, SettableValue> remainderByIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
                    PreparedOperation<?> operation = DefaultDatabaseClient.this.dataAccessStrategy.processNamedParameters(sql, (index, name) -> {
                        if (this.byName.containsKey(name)) {
                            remainderByName.remove(name);
                            return this.byName.get(name);
                        }
                        if (this.byIndex.containsKey(index)) {
                            remainderByIndex.remove(index);
                            return this.byIndex.get(index);
                        }
                        return null;
                    });
                    String expanded = DefaultDatabaseClient.getRequiredSql(operation);
                    if (DefaultDatabaseClient.this.logger.isTraceEnabled()) {
                        DefaultDatabaseClient.this.logger.trace((Object)("Expanded SQL [" + expanded + "]"));
                    }
                    Statement statement = it.createStatement(expanded);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    operation.bindTo(bindTarget);
                    DefaultDatabaseClient.bindByName(statement, remainderByName);
                    DefaultDatabaseClient.bindByIndex(statement, remainderByIndex);
                    return statement;
                }
                Statement statement = it.createStatement(sql);
                DefaultDatabaseClient.bindByIndex(statement, this.byIndex);
                DefaultDatabaseClient.bindByName(statement, this.byName);
                return statement;
            };
            Function resultFunction = DefaultDatabaseClient.toExecuteFunction(sql, executeFunction);
            return new DefaultSqlResult<T>(DefaultDatabaseClient.this, sql, resultFunction, it -> DefaultDatabaseClient.sumRowsUpdated(resultFunction, it), mappingFunction);
        }

        public ExecuteSpecSupport bind(int index, Object value) {
            this.assertNotPreparedOperation();
            Assert.notNull((Object)value, () -> String.format("Value at index %d must not be null. Use bindNull(\u2026) instead.", index));
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            if (value instanceof SettableValue) {
                byIndex.put(index, (SettableValue)value);
            } else {
                byIndex.put(index, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return this.createInstance(byIndex, this.byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bindNull(int index, Class<?> type) {
            this.assertNotPreparedOperation();
            LinkedHashMap<Integer, SettableValue> byIndex = new LinkedHashMap<Integer, SettableValue>(this.byIndex);
            byIndex.put(index, SettableValue.empty(type));
            return this.createInstance(byIndex, this.byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bind(String name, Object value) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            Assert.notNull((Object)value, () -> String.format("Value for parameter %s must not be null. Use bindNull(\u2026) instead.", name));
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            if (value instanceof SettableValue) {
                byName.put(name, (SettableValue)value);
            } else {
                byName.put(name, SettableValue.fromOrEmpty(value, value.getClass()));
            }
            return this.createInstance(this.byIndex, byName, this.sqlSupplier);
        }

        public ExecuteSpecSupport bindNull(String name, Class<?> type) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty!");
            LinkedHashMap<String, SettableValue> byName = new LinkedHashMap<String, SettableValue>(this.byName);
            byName.put(name, SettableValue.empty(type));
            return this.createInstance(this.byIndex, byName, this.sqlSupplier);
        }

        private void assertNotPreparedOperation() {
            if (this.sqlSupplier instanceof PreparedOperation) {
                throw new InvalidDataAccessApiUsageException("Cannot add bindings to a PreparedOperation");
            }
        }

        protected ExecuteSpecSupport createInstance(Map<Integer, SettableValue> byIndex, Map<String, SettableValue> byName, Supplier<String> sqlSupplier) {
            return new ExecuteSpecSupport(byIndex, byName, sqlSupplier);
        }
    }
}

