/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.R2dbcConverters;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;

public class R2dbcCustomConversions
extends CustomConversions {
    public static final List<Object> STORE_CONVERTERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public R2dbcCustomConversions(Collection<?> converters) {
        super(STORE_CONVERSIONS, R2dbcCustomConversions.appendOverrides(converters));
    }

    public R2dbcCustomConversions(CustomConversions.StoreConversions storeConversions, Collection<?> converters) {
        super(storeConversions, R2dbcCustomConversions.appendOverrides(converters));
    }

    private static Collection<?> appendOverrides(Collection<?> converters) {
        ArrayList objects = new ArrayList(converters);
        objects.addAll(R2dbcConverters.getOverrideConvertersToRegister());
        return objects;
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(R2dbcConverters.getConvertersToRegister());
        converters.addAll(JodaTimeConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)R2dbcSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
    }
}

