/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;

@API(status=API.Status.INTERNAL, since="6.2")
final class FetchableFluentQueryByPredicate<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Predicate predicate;
    private final Neo4jPersistentEntity<S> metaData;
    private final FluentFindOperation findOperation;
    private final Function<Predicate, Long> countOperation;
    private final Function<Predicate, Boolean> existsOperation;
    private final Neo4jMappingContext mappingContext;

    FetchableFluentQueryByPredicate(Predicate predicate, Neo4jMappingContext mappingContext, Neo4jPersistentEntity<S> metaData, Class<R> resultType, FluentFindOperation findOperation, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation) {
        this(predicate, mappingContext, metaData, resultType, findOperation, countOperation, existsOperation, Sort.unsorted(), null, null);
    }

    FetchableFluentQueryByPredicate(Predicate predicate, Neo4jMappingContext mappingContext, Neo4jPersistentEntity<S> metaData, Class<R> resultType, FluentFindOperation findOperation, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, Sort sort, @Nullable Integer limit, @Nullable Collection<String> properties) {
        super(resultType, sort, limit, properties);
        this.predicate = predicate;
        this.mappingContext = mappingContext;
        this.metaData = metaData;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.limit, this.properties);
    }

    public FluentQuery.FetchableFluentQuery<R> limit(int limit) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, limit, this.properties);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        return new FetchableFluentQueryByPredicate<S, NR>(this.predicate, this.mappingContext, this.metaData, resultType, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.limit, this.mergeProperties(this.extractAllPaths(properties)));
    }

    public @Nullable R oneValue() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndSort(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), this.sort, this.limit, this.createIncludedFieldsPredicate())).oneValue();
    }

    public @Nullable R firstValue() {
        List<R> all = this.all();
        return all.isEmpty() ? null : (R)all.get(0);
    }

    public List<R> all() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndSort(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), this.sort, this.limit, this.createIncludedFieldsPredicate())).all();
    }

    public Page<R> page(Pageable pageable) {
        List page = this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndPageable(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), pageable, this.createIncludedFieldsPredicate())).all();
        LongSupplier totalCountSupplier = this::count;
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Condition condition;
        Condition condition2 = Cypher.adapt((Object)this.predicate).asCondition();
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            condition = CypherAdapterUtils.combineKeysetIntoCondition(this.metaData, keysetScrollPosition, this.sort, this.mappingContext.getConversionService());
        } else {
            condition = null;
        }
        QueryFragmentsAndParameters queryFragmentsAndParameters = QueryFragmentsAndParameters.forConditionWithScrollPosition(this.metaData, condition2, condition, scrollPosition, this.sort, this.limit != null ? this.limit + 1 : 1, this.createIncludedFieldsPredicate());
        List rawResult = this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(queryFragmentsAndParameters).all();
        return this.scroll(scrollPosition, rawResult, this.metaData);
    }

    public Stream<R> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.countOperation.apply(this.predicate);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.predicate);
    }
}

