/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping.callback;

import org.apiguardian.api.API;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.callback.PostLoadInvocation;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveBeforeBindCallback;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveIdGeneratingBeforeBindCallback;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.0.2")
public final class ReactiveEventSupport {
    private final ReactiveEntityCallbacks entityCallbacks;

    private ReactiveEventSupport(ReactiveEntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    public static ReactiveEventSupport discoverCallbacks(Neo4jMappingContext context, BeanFactory beanFactory) {
        ReactiveEntityCallbacks entityCallbacks = ReactiveEntityCallbacks.create((BeanFactory)beanFactory);
        ReactiveEventSupport.addDefaultEntityCallbacks(context, entityCallbacks);
        return new ReactiveEventSupport(entityCallbacks);
    }

    public static ReactiveEventSupport useExistingCallbacks(Neo4jMappingContext context, ReactiveEntityCallbacks entityCallbacks) {
        ReactiveEventSupport.addDefaultEntityCallbacks(context, entityCallbacks);
        return new ReactiveEventSupport(entityCallbacks);
    }

    private static void addDefaultEntityCallbacks(Neo4jMappingContext context, ReactiveEntityCallbacks entityCallbacks) {
        entityCallbacks.addEntityCallback((EntityCallback)new ReactiveIdGeneratingBeforeBindCallback(context));
        entityCallbacks.addEntityCallback((EntityCallback)new PostLoadInvocation(context));
    }

    public <T> Mono<T> maybeCallBeforeBind(T object) {
        if (object == null) {
            return Mono.empty();
        }
        return this.entityCallbacks.callback(ReactiveBeforeBindCallback.class, object, new Object[0]);
    }
}

