/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.apiguardian.api.API;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.neo4j.repository.support.ReactivePersistenceExceptionTranslationInterceptor;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE, since="6.0")
public final class ReactivePersistenceExceptionTranslationPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor {
    private static final long serialVersionUID = -8597336297033105680L;
    private final transient Class<? extends Annotation> repositoryAnnotationType;

    public ReactivePersistenceExceptionTranslationPostProcessor() {
        this(Repository.class);
    }

    public ReactivePersistenceExceptionTranslationPostProcessor(Class<? extends Annotation> repositoryAnnotationType) {
        Assert.notNull(repositoryAnnotationType, (String)"'repositoryAnnotationType' must not be null");
        this.repositoryAnnotationType = repositoryAnnotationType;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
        }
        this.advisor = new ReactivePersistenceExceptionTranslationAdvisor((ListableBeanFactory)beanFactory, Objects.requireNonNullElse(this.repositoryAnnotationType, Repository.class));
    }

    static final class ReactivePersistenceExceptionTranslationAdvisor
    extends AbstractPointcutAdvisor {
        private static final long serialVersionUID = 849460320459940956L;
        private final transient ReactivePersistenceExceptionTranslationInterceptor advice;
        private final transient AnnotationMatchingPointcut pointcut;

        ReactivePersistenceExceptionTranslationAdvisor(ListableBeanFactory beanFactory, Class<? extends Annotation> repositoryAnnotationType) {
            this.advice = new ReactivePersistenceExceptionTranslationInterceptor(beanFactory);
            this.pointcut = new AnnotationMatchingPointcut(repositoryAnnotationType, true){

                public MethodMatcher getMethodMatcher() {
                    return new StaticMethodMatcher(){

                        public boolean matches(Method method, Class<?> targetClass) {
                            Class<?> returnType = method.getReturnType();
                            return returnType == Mono.class || returnType == Flux.class;
                        }
                    };
                }
            };
        }

        public Advice getAdvice() {
            return this.advice;
        }

        public Pointcut getPointcut() {
            return this.pointcut;
        }
    }
}

