/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;

final class DateStringConverter
implements Neo4jPersistentPropertyConverter<Date> {
    private final String format;

    DateStringConverter(String format) {
        this.format = format;
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    @Override
    public Value write(@Nullable Date source) {
        return source != null ? Values.value((String)this.getFormat().format(source)) : Values.NULL;
    }

    @Override
    public @Nullable Date read(@Nullable Value source) {
        try {
            return source == null || TypeSystem.getDefault().NULL().isTypeOf(source) ? null : this.getFormat().parse(source.asString());
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }
}

