/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

final class DynamicLabels
implements UnaryOperator<StatementBuilder.OngoingMatchAndUpdate> {
    public static final DynamicLabels EMPTY = new DynamicLabels(null, Collections.emptyList(), Collections.emptyList());
    private final Node rootNode;
    private final List<String> oldLabels;
    private final List<String> newLabels;

    DynamicLabels(@Nullable NodeDescription<?> nodeDescription, Collection<String> oldLabels, @Nullable Collection<String> newLabels) {
        this.oldLabels = new ArrayList<String>(oldLabels);
        this.newLabels = newLabels != null ? new ArrayList<String>(newLabels) : List.of();
        this.rootNode = Cypher.anyNode((SymbolicName)Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription));
    }

    @Override
    public StatementBuilder.OngoingMatchAndUpdate apply(StatementBuilder.OngoingMatchAndUpdate ongoingMatchAndUpdate) {
        StatementBuilder.OngoingMatchAndUpdate decoratedMatchAndUpdate = ongoingMatchAndUpdate;
        if (!this.oldLabels.isEmpty()) {
            decoratedMatchAndUpdate = decoratedMatchAndUpdate.remove(this.rootNode, this.oldLabels.toArray(new String[0]));
        }
        if (!this.newLabels.isEmpty()) {
            decoratedMatchAndUpdate = (StatementBuilder.OngoingMatchAndUpdate)decoratedMatchAndUpdate.set(this.rootNode, this.newLabels.toArray(new String[0]));
        }
        return decoratedMatchAndUpdate;
    }
}

