/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.Optional;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherdslConditionExecutorImpl;
import org.springframework.data.neo4j.repository.query.Neo4jQueryLookupStrategy;
import org.springframework.data.neo4j.repository.query.QuerydslNeo4jPredicateExecutor;
import org.springframework.data.neo4j.repository.query.SimpleQueryByExampleExecutor;
import org.springframework.data.neo4j.repository.support.CypherdslConditionExecutor;
import org.springframework.data.neo4j.repository.support.DefaultNeo4jEntityInformation;
import org.springframework.data.neo4j.repository.support.EntityAndGraphPropertyAccessingMethodInterceptor;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactorySupport;
import org.springframework.data.neo4j.repository.support.SimpleNeo4jRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ValueExpressionDelegate;

final class Neo4jRepositoryFactory
extends RepositoryFactorySupport {
    private final Neo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private Configuration cypherDSLConfiguration = Configuration.defaultConfig();

    Neo4jRepositoryFactory(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
    }

    public Neo4jEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
        return new DefaultNeo4jEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        EntityInformation entityInformation = this.getEntityInformation((RepositoryMetadata)metadata);
        Neo4jRepositoryFactorySupport.assertIdentifierType(metadata.getIdType(), entityInformation.getIdType());
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.neo4jOperations, entityInformation});
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        boolean isQueryDslRepository;
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        Object byExampleExecutor = this.instantiateClass(SimpleQueryByExampleExecutor.class, new Object[]{this.neo4jOperations, this.mappingContext});
        fragments = fragments.append(RepositoryFragment.implemented((Object)byExampleExecutor));
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            fragments = fragments.append(this.createDSLPredicateExecutorFragment(metadata, QuerydslNeo4jPredicateExecutor.class));
        }
        if (CypherdslConditionExecutor.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            fragments = fragments.append(this.createDSLExecutorFragment(metadata, CypherdslConditionExecutorImpl.class));
        }
        return fragments;
    }

    private RepositoryFragment<Object> createDSLPredicateExecutorFragment(RepositoryMetadata metadata, Class<?> implementor) {
        EntityInformation entityInformation = this.getEntityInformation(metadata);
        Object querydslFragment = this.instantiateClass(implementor, new Object[]{this.mappingContext, entityInformation, this.neo4jOperations});
        return RepositoryFragment.implemented((Object)querydslFragment);
    }

    private RepositoryFragment<Object> createDSLExecutorFragment(RepositoryMetadata metadata, Class<?> implementor) {
        EntityInformation entityInformation = this.getEntityInformation(metadata);
        Object querydslFragment = this.instantiateClass(implementor, new Object[]{entityInformation, this.neo4jOperations});
        return RepositoryFragment.implemented((Object)querydslFragment);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleNeo4jRepository.class;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        this.cypherDSLConfiguration = (Configuration)beanFactory.getBeanProvider(Configuration.class).getIfAvailable(Configuration::defaultConfig);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new Neo4jQueryLookupStrategy(this.neo4jOperations, this.mappingContext, valueExpressionDelegate, this.cypherDSLConfiguration));
    }

    protected ProjectionFactory getProjectionFactory() {
        ProjectionFactory projectionFactory = super.getProjectionFactory();
        if (projectionFactory instanceof SpelAwareProxyProjectionFactory) {
            ((SpelAwareProxyProjectionFactory)projectionFactory).registerMethodInvokerFactory(EntityAndGraphPropertyAccessingMethodInterceptor.createMethodInterceptorFactory(this.mappingContext));
        }
        return projectionFactory;
    }
}

