/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ResultSummary;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.lang.Nullable;

final class ResultSummaries {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final LogAccessor cypherPerformanceNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.performance"));
    private static final LogAccessor cypherHintNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.hint"));
    private static final LogAccessor cypherUnrecognizedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unrecognized"));
    private static final LogAccessor cypherUnsupportedNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.unsupported"));
    private static final LogAccessor cypherDeprecationNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.deprecation"));
    private static final LogAccessor cypherGenericNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.generic"));
    private static final LogAccessor cypherSecurityNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.security"));
    private static final LogAccessor cypherTopologyNotificationLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher.topology"));
    private static final Pattern DEPRECATED_ID_PATTERN = Pattern.compile("(?im)The query used a deprecated function: `id`\\.");

    static ResultSummary process(ResultSummary resultSummary) {
        ResultSummaries.logNotifications(resultSummary);
        ResultSummaries.logPlan(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        Predicate<Notification> isDeprecationWarningForId;
        if (resultSummary.notifications().isEmpty() || !Neo4jClient.cypherLog.isWarnEnabled()) {
            return;
        }
        boolean supressIdDeprecations = Neo4jClient.SUPPRESS_ID_DEPRECATIONS.getAcquire();
        try {
            isDeprecationWarningForId = notification -> supressIdDeprecations && notification.classification().orElse(NotificationClassification.UNRECOGNIZED) == NotificationClassification.DEPRECATION && DEPRECATED_ID_PATTERN.matcher(notification.description()).matches();
        }
        finally {
            Neo4jClient.SUPPRESS_ID_DEPRECATIONS.setRelease(supressIdDeprecations);
        }
        String query = resultSummary.query().text();
        resultSummary.notifications().stream().filter(Predicate.not(isDeprecationWarningForId)).forEach(notification -> notification.severityLevel().ifPresent(severityLevel -> {
            NotificationClassification category = notification.classification().orElse(null);
            LogAccessor logger = ResultSummaries.getLogAccessor(category);
            Consumer<String> logFunction = severityLevel == NotificationSeverity.WARNING ? arg_0 -> ((LogAccessor)logger).warn(arg_0) : (severityLevel == NotificationSeverity.INFORMATION ? arg_0 -> ((LogAccessor)logger).info(arg_0) : (severityLevel == NotificationSeverity.OFF ? message -> {} : arg_0 -> ((LogAccessor)logger).debug(arg_0)));
            logFunction.accept(ResultSummaries.format(notification, query));
        }));
    }

    private static LogAccessor getLogAccessor(@Nullable NotificationClassification category) {
        if (category == null) {
            return Neo4jClient.cypherLog;
        }
        return switch (category) {
            case NotificationClassification.HINT -> cypherHintNotificationLog;
            case NotificationClassification.DEPRECATION -> cypherDeprecationNotificationLog;
            case NotificationClassification.PERFORMANCE -> cypherPerformanceNotificationLog;
            case NotificationClassification.GENERIC -> cypherGenericNotificationLog;
            case NotificationClassification.UNSUPPORTED -> cypherUnsupportedNotificationLog;
            case NotificationClassification.UNRECOGNIZED -> cypherUnrecognizedNotificationLog;
            case NotificationClassification.SECURITY -> cypherSecurityNotificationLog;
            case NotificationClassification.TOPOLOGY -> cypherTopologyNotificationLog;
            default -> Neo4jClient.cypherLog;
        };
    }

    static String format(Notification notification, String forQuery) {
        InputPosition position = notification.position();
        boolean hasPosition = position != null;
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (!hasPosition || i2 + 1 != position.line()) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(position.column() - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s: %s%n%s%s", notification.code(), notification.title(), queryHint, notification.description());
    }

    private static void logPlan(ResultSummary resultSummary) {
        if (!resultSummary.hasPlan() || !Neo4jClient.cypherLog.isDebugEnabled()) {
            return;
        }
        Consumer<String> log = arg_0 -> ((LogAccessor)Neo4jClient.cypherLog).debug(arg_0);
        log.accept("Plan:");
        ResultSummaries.printPlan(log, resultSummary.plan(), 0);
    }

    private static void printPlan(Consumer<String> log, Plan plan, int level) {
        String tabs = Stream.generate(() -> "\t").limit(level).collect(Collectors.joining());
        log.accept(tabs + "operatorType: " + plan.operatorType());
        log.accept(tabs + "identifiers: " + String.join((CharSequence)",", plan.identifiers()));
        log.accept(tabs + "arguments: ");
        plan.arguments().forEach((k, v) -> log.accept(tabs + "\t" + k + "=" + v));
        if (!plan.children().isEmpty()) {
            log.accept(tabs + "children: ");
            for (Plan childPlan : plan.children()) {
                ResultSummaries.printPlan(log, childPlan, level + 1);
            }
        }
    }

    private ResultSummaries() {
    }
}

