/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.PropertyFilterSupport;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.DtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryExecution;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.OptionalUnwrappingConverter;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

abstract class AbstractReactiveNeo4jQuery
extends Neo4jQuerySupport
implements RepositoryQuery {
    protected final ReactiveNeo4jOperations neo4jOperations;
    private ProjectionFactory factory;

    AbstractReactiveNeo4jQuery(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType, ProjectionFactory factory) {
        super(mappingContext, queryMethod, queryType);
        Assert.notNull((Object)neo4jOperations, (String)"The Neo4j operations are required");
        this.neo4jOperations = neo4jOperations;
        this.factory = factory;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    boolean isGeoNearQuery() {
        Method repositoryMethod = this.queryMethod.getMethod();
        Class<?> returnType = repositoryMethod.getReturnType();
        for (Class<? extends Serializable> type : Neo4jQueryMethod.GEO_NEAR_RESULTS) {
            if (!type.isAssignableFrom(returnType)) continue;
            return true;
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            TypeInformation from = TypeInformation.fromReturnTypeOf((Method)repositoryMethod);
            return GeoResult.class.equals((Object)from.getComponentType().getType());
        }
        return false;
    }

    public final Object execute(Object[] parameters) {
        boolean incrementLimit = this.queryMethod.incrementLimit();
        boolean geoNearQuery = this.isGeoNearQuery();
        Neo4jParameterAccessor parameterAccessor = new Neo4jParameterAccessor((Neo4jQueryMethod.Neo4jParameters)this.queryMethod.getParameters(), parameters);
        ResultProcessor resultProcessor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        ReturnedType returnedType = resultProcessor.getReturnedType();
        PreparedQuery preparedQuery = this.prepareQuery(returnedType.getReturnedType(), PropertyFilterSupport.getInputProperties(resultProcessor, this.factory, this.mappingContext), parameterAccessor, null, this.getMappingFunction(resultProcessor, geoNearQuery), incrementLimit ? l -> l + 1 : UnaryOperator.identity());
        Object rawResult = new Neo4jQueryExecution.ReactiveQueryExecution(this.neo4jOperations).execute(preparedQuery, this.queryMethod.asCollectionQuery());
        OptionalUnwrappingConverter preparingConverter = OptionalUnwrappingConverter.INSTANCE;
        if (returnedType.isProjecting()) {
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext);
            preparingConverter = source -> converter.convert((EntityInstanceWithSource)OptionalUnwrappingConverter.INSTANCE.convert(source));
        }
        if (this.queryMethod.isScrollQuery()) {
            rawResult = ((Flux)rawResult).collectList().map(rawResultList -> this.createWindow(resultProcessor, incrementLimit, parameterAccessor, (List<?>)rawResultList, preparedQuery.getQueryFragmentsAndParameters()));
        }
        return resultProcessor.processResult(rawResult, (Converter)preparingConverter);
    }

    protected abstract <T> PreparedQuery<T> prepareQuery(Class<T> var1, Collection<PropertyFilter.ProjectedPath> var2, Neo4jParameterAccessor var3, @Nullable Neo4jQueryType var4, @Nullable Supplier<BiFunction<TypeSystem, MapAccessor, ?>> var5, @Nullable UnaryOperator<Integer> var6);
}

