/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.FetchableFluentQueryByExample;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.support.PageableExecutionUtils;

@API(status=API.Status.INTERNAL, since="6.0")
public final class SimpleQueryByExampleExecutor<T>
implements QueryByExampleExecutor<T> {
    private final Neo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private final CypherGenerator cypherGenerator;

    public SimpleQueryByExampleExecutor(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExample(this.mappingContext, example)).getSingleResult();
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExample(this.mappingContext, example)).getResults();
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExampleWithSort(this.mappingContext, example, sort, null, PropertyFilter.NO_FILTER)).getResults();
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        List page = this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExampleWithPageable(this.mappingContext, example, pageable, PropertyFilter.NO_FILTER)).getResults();
        LongSupplier totalCountSupplier = () -> this.count(example);
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public <S extends T> long count(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{Cypher.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, predicate.getParameters());
    }

    public <S extends T> boolean exists(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{Cypher.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, predicate.getParameters()) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Neo4jOperations neo4jOperations = this.neo4jOperations;
        if (neo4jOperations instanceof FluentFindOperation) {
            FluentFindOperation ops = (FluentFindOperation)((Object)neo4jOperations);
            FetchableFluentQueryByExample fluentQuery = new FetchableFluentQueryByExample(example, example.getProbeType(), this.mappingContext, ops, this::count, this::exists);
            return queryFunction.apply(fluentQuery);
        }
        throw new UnsupportedOperationException("Fluent find by example not supported with standard Neo4jOperations, must support fluent queries too");
    }
}

