/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.FluentNeo4jOperations;
import org.springframework.data.neo4j.core.FluentOperationSupport;
import org.springframework.data.neo4j.core.FluentSaveOperation;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.PropertyFilterSupport;
import org.springframework.data.neo4j.core.PropertyPathWalkStep;
import org.springframework.data.neo4j.core.RelationshipHandler;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.core.mapping.AssociationHandlerSupport;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.DtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityFromDtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.IdentitySupport;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.SpringDataCypherDsl;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.NoResultException;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jTemplate
implements Neo4jOperations,
FluentNeo4jOperations,
BeanClassLoaderAware,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final TransactionDefinition readOnlyTransactionDefinition = new TransactionDefinition(){

        public boolean isReadOnly() {
            return true;
        }
    };
    private final Neo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private ClassLoader beanClassLoader;
    private EventSupport eventSupport;
    private ProjectionFactory projectionFactory;
    private Renderer renderer;
    private Function<Named, FunctionInvocation> elementIdOrIdFunction;
    private TransactionTemplate transactionTemplate;
    private TransactionTemplate transactionTemplateReadOnly;

    public Neo4jTemplate(Neo4jClient neo4jClient) {
        this(neo4jClient, new Neo4jMappingContext());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext) {
        this(neo4jClient, neo4jMappingContext, EntityCallbacks.create());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, PlatformTransactionManager transactionManager) {
        this(neo4jClient, neo4jMappingContext, EntityCallbacks.create(), transactionManager);
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, EntityCallbacks entityCallbacks) {
        this(neo4jClient, neo4jMappingContext, entityCallbacks, null);
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, EntityCallbacks entityCallbacks, @Nullable PlatformTransactionManager platformTransactionManager) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = EventSupport.useExistingCallbacks(neo4jMappingContext, entityCallbacks);
        this.renderer = Renderer.getDefaultRenderer();
        this.elementIdOrIdFunction = SpringDataCypherDsl.elementIdOrIdFunction.apply(null);
        this.setTransactionManager(platformTransactionManager);
    }

    ProjectionFactory getProjectionFactory() {
        return Objects.requireNonNull(this.projectionFactory, "Projection support for the Neo4j template is only available when the template is a proper and fully initialized Spring bean.");
    }

    @Override
    public long count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public long count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public long count(Statement statement, Map<String, Object> parameters) {
        return this.count(this.renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    @Override
    public long count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public long count(String cypherQuery, Map<String, Object> parameters) {
        return (Long)this.transactionTemplateReadOnly.execute(tx -> {
            PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
            return this.toExecutableQuery(preparedQuery).getRequiredSingleResult();
        });
    }

    @Override
    public <T> List<T> findAll(Class<T> domainType) {
        return this.doFindAll(domainType, null);
    }

    private <T> List<T> doFindAll(Class<T> domainType, @Nullable Class<?> resultType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            return this.createExecutableQuery(domainType, resultType, QueryFragmentsAndParameters.forFindAll(entityMetaData)).getResults();
        });
    }

    @Override
    public <T> List<T> findAll(Statement statement, Class<T> domainType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, statement).getResults());
    }

    @Override
    public <T> List<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, null, statement, parameters).getResults());
    }

    @Override
    public <T> Optional<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return (Optional)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, null, statement, parameters).getSingleResult());
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Class<T> domainType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, cypherQuery).getResults());
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, null, cypherQuery, parameters).getResults());
    }

    @Override
    public <T> Optional<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return (Optional)this.transactionTemplateReadOnly.execute(tx -> this.createExecutableQuery(domainType, null, cypherQuery, parameters).getSingleResult());
    }

    @Override
    public <T> FluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        return (FluentFindOperation.ExecutableFind)this.transactionTemplateReadOnly.execute(tx -> new FluentOperationSupport(this).find(domainType));
    }

    <T, R> List<R> doFind(@Nullable String cypherQuery, @Nullable Map<String, Object> parameters, Class<T> domainType, Class<R> resultType, TemplateSupport.FetchType fetchType, @Nullable QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> {
            List intermediaResults = Collections.emptyList();
            if (cypherQuery == null && queryFragmentsAndParameters == null && fetchType == TemplateSupport.FetchType.ALL) {
                intermediaResults = this.doFindAll(domainType, resultType);
            } else {
                Neo4jOperations.ExecutableQuery executableQuery = queryFragmentsAndParameters == null ? this.createExecutableQuery(domainType, resultType, cypherQuery, (Map<String, Object>)(parameters == null ? Collections.emptyMap() : parameters)) : this.createExecutableQuery(domainType, resultType, queryFragmentsAndParameters);
                switch (fetchType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ALL: {
                        List list = executableQuery.getResults();
                        break;
                    }
                    case ONE: {
                        List list = intermediaResults = executableQuery.getSingleResult().map(Collections::singletonList).orElseGet(Collections::emptyList);
                    }
                }
            }
            if (resultType.isAssignableFrom(domainType)) {
                return intermediaResults;
            }
            if (resultType.isInterface()) {
                return intermediaResults.stream().map(instance -> this.getProjectionFactory().createProjection(resultType, instance)).collect(Collectors.toList());
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext);
            return intermediaResults.stream().map(EntityInstanceWithSource.class::cast).map(converter::convert).map(v -> v).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        Map<String, Object> parameters;
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        QueryFragmentsAndParameters fragmentsAndParameters = QueryFragmentsAndParameters.forExistsById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        Statement statement = fragmentsAndParameters.getQueryFragments().toStatement();
        return this.count(statement, parameters = fragmentsAndParameters.getParameters()) > 0L;
    }

    @Override
    public <T> Optional<T> findById(Object id, Class<T> domainType) {
        return (Optional)this.transactionTemplateReadOnly.execute(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).getSingleResult();
        });
    }

    @Override
    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return (List)this.transactionTemplateReadOnly.execute(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindByAllId(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).getResults();
        });
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, @Nullable Object idValues) {
        if (idProperty != null && ((Neo4jPersistentEntity)idProperty.getOwner()).isUsingInternalIds()) {
            return idValues;
        }
        if (idValues != null) {
            return this.neo4jMappingContext.getConversionService().writeValue(idValues, TypeInformation.of(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalConverter());
        }
        if (idProperty != null) {
            return this.neo4jMappingContext.getConversionService().writeValue(idValues, idProperty.getTypeInformation(), idProperty.getOptionalConverter());
        }
        return Values.NULL;
    }

    @Override
    public <T> T save(T instance) {
        return (T)this.transactionTemplate.execute(tx -> this.saveImpl(instance, Collections.emptySet(), null));
    }

    @Override
    public <T> T saveAs(T instance, BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        if (instance == null) {
            return null;
        }
        return (T)this.transactionTemplate.execute(tx -> this.saveImpl(instance, TemplateSupport.computeIncludedPropertiesFromPredicate(this.neo4jMappingContext, instance.getClass(), includeProperty), null));
    }

    @Override
    public <T, R> R saveAs(T instance, Class<R> resultType) {
        return (R)this.transactionTemplate.execute(tx -> {
            Assert.notNull((Object)resultType, (String)"ResultType must not be null");
            if (instance == null) {
                return null;
            }
            if (resultType.equals(instance.getClass())) {
                return resultType.cast(this.save(instance));
            }
            ProjectionFactory localProjectionFactory = this.getProjectionFactory();
            ProjectionInformation projectionInformation = localProjectionFactory.getProjectionInformation(resultType);
            Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(instance.getClass(), resultType, localProjectionFactory, this.neo4jMappingContext);
            Object savedInstance = this.saveImpl(instance, pps, null);
            if (!resultType.isInterface()) {
                Object result = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext).convertDirectly(savedInstance);
                return result;
            }
            if (projectionInformation.isClosed()) {
                return localProjectionFactory.createProjection(resultType, savedInstance);
            }
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(savedInstance.getClass());
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
            return localProjectionFactory.createProjection(resultType, this.findById(propertyAccessor.getProperty((PersistentProperty)idProperty), savedInstance.getClass()).get());
        });
    }

    private <T> T saveImpl(T instance, @Nullable Collection<PropertyFilter.ProjectedPath> includedProperties, @Nullable NestedRelationshipProcessingStateMachine stateMachine) {
        if (stateMachine != null && stateMachine.hasProcessedValue(instance)) {
            return instance;
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(instance.getClass());
        boolean isEntityNew = entityMetaData.isNew(instance);
        T entityToBeSaved = this.eventSupport.maybeCallBeforeBind(instance);
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entityToBeSaved, entityMetaData);
        TemplateSupport.FilteredBinderFunction binderFunction = TemplateSupport.createAndApplyPropertyFilter(includedProperties, entityMetaData, this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()));
        Optional<Entity> newOrUpdatedNode = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels, TemplateSupport.rendererRendersElementId(this.renderer)))).bind(entityToBeSaved).with(binderFunction)).fetchAs(Entity.class).one();
        if (newOrUpdatedNode.isEmpty()) {
            if (entityMetaData.hasVersionProperty()) {
                throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
            }
            throw new IllegalStateException("Could not retrieve an internal id while saving");
        }
        Serializable elementId = newOrUpdatedNode.map(node -> {
            if (!entityMetaData.isUsingDeprecatedInternalId() && TemplateSupport.rendererRendersElementId(this.renderer)) {
                return IdentitySupport.getElementId(node);
            }
            return Long.valueOf(node.id());
        }).get();
        PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
        TemplateSupport.setGeneratedIdIfNecessary(entityMetaData, propertyAccessor, elementId, newOrUpdatedNode);
        TemplateSupport.updateVersionPropertyIfPossible(entityMetaData, propertyAccessor, newOrUpdatedNode.get());
        if (stateMachine == null) {
            stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext, instance, elementId);
        }
        stateMachine.markEntityAsProcessed(instance, elementId);
        this.processRelations(entityMetaData, propertyAccessor, isEntityNew, stateMachine, binderFunction.filter);
        Object bean = propertyAccessor.getBean();
        stateMachine.markAsAliased(instance, bean);
        return (T)bean;
    }

    private <T> DynamicLabels determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            Neo4jClient.RunnableSpec runnableQuery = (Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).bind(this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty))).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (Neo4jClient.RunnableSpec)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty())).to("__version__");
            }
            Optional<Map<String, Object>> optionalResult = runnableQuery.fetch().one();
            return new DynamicLabels(entityMetaData, optionalResult.map(r -> (Collection)r.get("__nodeLabels__")).orElseGet(Collections::emptyList), (Collection)propertyAccessor.getProperty((PersistentProperty)p));
        }).orElse(DynamicLabels.EMPTY);
    }

    @Override
    public <T> List<T> saveAll(Iterable<T> instances) {
        return (List)this.transactionTemplate.execute(tx -> this.saveAllImpl(instances, Collections.emptySet(), null));
    }

    private <T> List<T> saveAllImpl(Iterable<T> instances, @Nullable Collection<PropertyFilter.ProjectedPath> includedProperties, @Nullable BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        class Tuple3<T> {
            final T originalInstance;
            final boolean wasNew;
            final T modifiedInstance;

            Tuple3(T originalInstance, boolean wasNew, T modifiedInstance) {
                this.originalInstance = originalInstance;
                this.wasNew = wasNew;
                this.modifiedInstance = modifiedInstance;
            }
        }
        HashSet types = new HashSet();
        ArrayList entities = new ArrayList();
        instances.forEach(instance -> {
            entities.add(instance);
            types.add(instance.getClass());
        });
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        boolean heterogeneousCollection = types.size() > 1;
        Class domainClass = (Class)types.iterator().next();
        Collection<PropertyFilter.ProjectedPath> pps = includeProperty == null ? includedProperties : TemplateSupport.computeIncludedPropertiesFromPredicate(this.neo4jMappingContext, domainClass, includeProperty);
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainClass);
        if (heterogeneousCollection || entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
            return entities.stream().map(e -> this.saveImpl(e, pps, stateMachine)).collect(Collectors.toList());
        }
        List entitiesToBeSaved = entities.stream().map(e -> new Tuple3<Object>(e, entityMetaData.isNew(e), this.eventSupport.maybeCallBeforeBind(e))).collect(Collectors.toList());
        TemplateSupport.FilteredBinderFunction binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        binderFunction = TemplateSupport.createAndApplyPropertyFilter(pps, entityMetaData, binderFunction);
        List entityList = entitiesToBeSaved.stream().map(h -> h.modifiedInstance).map(binderFunction).collect(Collectors.toList());
        Map<Value, String> idToInternalIdMapping = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).bind(entityList).to("__entities__")).fetchAs(Map.Entry.class).mappedBy((t, r) -> new AbstractMap.SimpleEntry<Value, String>(r.get("__id__"), TemplateSupport.convertIdOrElementIdToString(r.get("__elementId__")))).all().stream().collect(Collectors.toMap(m -> (Value)m.getKey(), m -> (String)m.getValue()));
        NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext, null, null);
        return entitiesToBeSaved.stream().map(t -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(t.modifiedInstance);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            Object id = this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty));
            String internalId = (String)idToInternalIdMapping.get(id);
            stateMachine.registerInitialObject(t.originalInstance, internalId);
            return this.processRelations(entityMetaData, propertyAccessor, t.wasNew, stateMachine, TemplateSupport.computeIncludePropertyPredicate(pps, entityMetaData));
        }).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> saveAllAs(Iterable<T> instances, BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        return (List)this.transactionTemplate.execute(tx -> this.saveAllImpl(instances, null, includeProperty));
    }

    @Override
    public <T, R> List<R> saveAllAs(Iterable<T> instances, Class<R> resultType) {
        return (List)this.transactionTemplate.execute(tx -> {
            Assert.notNull((Object)resultType, (String)"ResultType must not be null");
            Class<?> commonElementType = TemplateSupport.findCommonElementType(instances);
            if (commonElementType == null) {
                throw new IllegalArgumentException("Could not determine a common element of an heterogeneous collection");
            }
            if (commonElementType == TemplateSupport.EmptyIterable.class) {
                return Collections.emptyList();
            }
            if (resultType.isAssignableFrom(commonElementType)) {
                List saveElements = this.saveAll(instances);
                return saveElements;
            }
            ProjectionFactory localProjectionFactory = this.getProjectionFactory();
            ProjectionInformation projectionInformation = localProjectionFactory.getProjectionInformation(resultType);
            Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(commonElementType, resultType, localProjectionFactory, this.neo4jMappingContext);
            List savedInstances = this.saveAllImpl(instances, pps, null);
            if (projectionInformation.isClosed()) {
                return savedInstances.stream().map(instance -> localProjectionFactory.createProjection(resultType, instance)).collect(Collectors.toList());
            }
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(commonElementType);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
            List ids = savedInstances.stream().map(savedInstance -> {
                PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
                return propertyAccessor.getProperty((PersistentProperty)idProperty);
            }).collect(Collectors.toList());
            return this.findAllById(ids, commonElementType).stream().map(instance -> localProjectionFactory.createProjection(resultType, instance)).collect(Collectors.toList());
        });
    }

    @Override
    public <T> void deleteById(Object id, Class<T> domainType) {
        this.transactionTemplate.executeWithoutResult(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            String nameOfParameter = "id";
            Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
            log.debug(() -> String.format("Deleting entity with id %s ", id));
            Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
            ResultSummary summary = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run();
            log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
        });
    }

    @Override
    public <T> void deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        this.transactionTemplate.executeWithoutResult(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            String nameOfParameter = "id";
            Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)), (String[])new String[]{versionProperty.getPropertyName()}).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)), (String[])new String[]{versionProperty.getPropertyName()}).isNull()));
            Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{(Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)}).build();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
            parameters.put("__version__", versionValue);
            this.createExecutableQuery(domainType, null, statement, parameters).getSingleResult().orElseThrow(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            this.deleteById(id, domainType);
        });
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> domainType) {
        this.transactionTemplate.executeWithoutResult(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            String nameOfParameter = "ids";
            Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
            log.debug(() -> String.format("Deleting all entities with the following ids: %s ", ids));
            Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
            ResultSummary summary = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run();
            log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
        });
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        this.transactionTemplate.executeWithoutResult(tx -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
            log.debug(() -> String.format("Deleting all nodes with primary label %s", entityMetaData.getPrimaryLabel()));
            Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
            ResultSummary summary = this.neo4jClient.query(this.renderer.render(statement)).run();
            log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
        });
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, null, statement, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherQuery) {
        return this.createExecutableQuery(domainType, null, cypherQuery, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, resultType, this.renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, @Nullable String cypherStatement, Map<String, Object> parameters) {
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction = TemplateSupport.getAndDecorateMappingFunction(this.neo4jMappingContext, domainType, resultType);
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherStatement).withParameters(parameters).usingMappingFunction(mappingFunction).build();
        return this.toExecutableQuery(preparedQuery);
    }

    private <T> T processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, PersistentPropertyAccessor<?> parentPropertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty) {
        PropertyFilter.RelaxedPropertyPath startingPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(neo4jPersistentEntity.getUnderlyingClass());
        return this.processNestedRelations(neo4jPersistentEntity, parentPropertyAccessor, isParentObjectNew, stateMachine, includeProperty, startingPropertyPath);
    }

    private <T> T processNestedRelations(Neo4jPersistentEntity<?> sourceEntity, PersistentPropertyAccessor<?> propertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath previousPath) {
        Object fromId = propertyAccessor.getProperty(sourceEntity.getRequiredIdProperty());
        AssociationHandlerSupport.of(sourceEntity).doWithAssociations((AssociationHandler<Neo4jPersistentProperty>)((AssociationHandler)association -> {
            Neo4jPersistentProperty idProperty;
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, sourceEntity);
            if (relationshipContext.isReadOnly()) {
                return;
            }
            Object rawValue = relationshipContext.getValue();
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), rawValue);
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            PropertyFilter.RelaxedPropertyPath currentPropertyPath = previousPath.append(relationshipDescription.getFieldName());
            if (!includeProperty.isNotFiltering() && !includeProperty.contains(currentPropertyPath)) {
                return;
            }
            if (!relationshipDescription.hasInternalIdProperty()) {
                idProperty = null;
            } else {
                Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                idProperty = (Neo4jPersistentProperty)relationshipPropertiesEntity.getIdProperty();
            }
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(fromId, relationshipDescription, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS || processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_BOTH) {
                return;
            }
            boolean canUseElementId = TemplateSupport.rendererRendersElementId(this.renderer);
            if (!isParentObjectNew && !stateMachine.hasProcessedRelationship(fromId, relationshipDescription)) {
                ArrayList<Object> knownRelationshipsIds = new ArrayList<Object>();
                if (idProperty != null) {
                    for (Object relatedValueToStore : relatedValuesToStore) {
                        Object id;
                        if (relatedValueToStore == null || (id = relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty)) == null) continue;
                        knownRelationshipsIds.add(id);
                    }
                }
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(sourceEntity, relationshipDescription, canUseElementId);
                ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(relationshipRemoveQuery)).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getIdProperty(), fromId)).to("fromId")).bind(knownRelationshipsIds).to("__knownRelationShipIds__")).run();
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            stateMachine.markRelationshipAsProcessed(fromId, relationshipDescription);
            Neo4jPersistentProperty relationshipProperty = (Neo4jPersistentProperty)association.getInverse();
            RelationshipHandler relationshipHandler = RelationshipHandler.forProperty(relationshipProperty, rawValue);
            ArrayList<Object> plainRelationshipRows = new ArrayList<Object>();
            ArrayList<Map<String, Object>> relationshipPropertiesRows = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> newRelationshipPropertiesRows = new ArrayList<Map<String, Object>>();
            ArrayList updateRelatedValuesToStore = new ArrayList();
            ArrayList newRelatedValuesToStore = new ArrayList();
            for (Object relatedValueToStore : relatedValuesToStore) {
                boolean isNewRelationship;
                Object relatedInternalId;
                Object relatedObjectBeforeCallbacksApplied = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(relatedObjectBeforeCallbacksApplied.getClass());
                boolean isEntityNew = targetEntity.isNew(relatedObjectBeforeCallbacksApplied);
                Object newRelatedObject = stateMachine.hasProcessedValue(relatedObjectBeforeCallbacksApplied) ? stateMachine.getProcessedAs(relatedObjectBeforeCallbacksApplied) : this.eventSupport.maybeCallBeforeBind(relatedObjectBeforeCallbacksApplied);
                Entity savedEntity = null;
                if (stateMachine.hasProcessedValue(relatedValueToStore)) {
                    relatedInternalId = stateMachine.getObjectId(relatedValueToStore);
                } else {
                    savedEntity = this.saveRelatedNode(newRelatedObject, targetEntity, includeProperty, currentPropertyPath);
                    relatedInternalId = TemplateSupport.rendererCanUseElementIdIfPresent(this.renderer, targetEntity) ? savedEntity.elementId() : Long.valueOf(savedEntity.id());
                    stateMachine.markEntityAsProcessed(relatedValueToStore, relatedInternalId);
                    if (relatedValueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder) {
                        Object entity = ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValueToStore).getRelatedEntity();
                        stateMachine.markAsAliased(entity, relatedInternalId);
                    }
                }
                Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)targetEntity.getRequiredIdProperty();
                PersistentPropertyAccessor targetPropertyAccessor = targetEntity.getPropertyAccessor(newRelatedObject);
                Object possibleInternalLongId = targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
                relatedInternalId = TemplateSupport.retrieveOrSetRelatedId(targetEntity, targetPropertyAccessor, Optional.ofNullable(savedEntity), relatedInternalId);
                if (savedEntity != null) {
                    TemplateSupport.updateVersionPropertyIfPossible(targetEntity, targetPropertyAccessor, savedEntity);
                }
                stateMachine.markAsAliased(relatedObjectBeforeCallbacksApplied, targetPropertyAccessor.getBean());
                stateMachine.markRelationshipAsProcessed(possibleInternalLongId == null ? relatedInternalId : possibleInternalLongId, relationshipDescription.getRelationshipObverse());
                Object idValue = idProperty != null ? relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty) : null;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("fromId", this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId));
                properties.put("toId", relatedInternalId);
                properties.put("__knownRelationShipId__", idValue);
                boolean bl = isNewRelationship = idValue == null;
                if (relationshipDescription.isDynamic()) {
                    if (relationshipDescription.hasRelationshipProperties() && isNewRelationship && idProperty != null) {
                        statementHolder = this.neo4jMappingContext.createStatementForSingleRelationship(sourceEntity, relationshipDescription, relatedValueToStore, true, canUseElementId);
                        row = Collections.singletonList(properties);
                        statementHolder = statementHolder.addProperty("__relationships__", row);
                        Optional<Object> relationshipInternalId = ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder.getProperties())).fetchAs(Object.class).mappedBy((t, r) -> IdentitySupport.mapperForRelatedIdValues(idProperty).apply((MapAccessor)r)).one();
                        this.assignIdToRelationshipProperties(relationshipContext, relatedValueToStore, idProperty, relationshipInternalId.orElseThrow());
                    } else {
                        statementHolder = this.neo4jMappingContext.createStatementForSingleRelationship(sourceEntity, relationshipDescription, relatedValueToStore, false, canUseElementId);
                        row = Collections.singletonList(properties);
                        statementHolder = statementHolder.addProperty("__relationships__", row);
                        ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder.getProperties())).run();
                    }
                } else if (relationshipDescription.hasRelationshipProperties() && isNewRelationship && idProperty != null) {
                    newRelationshipPropertiesRows.add(properties);
                    newRelatedValuesToStore.add(relatedValueToStore);
                } else if (relationshipDescription.hasRelationshipProperties()) {
                    this.neo4jMappingContext.getEntityConverter().write(((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValueToStore).getRelationshipProperties(), properties);
                    relationshipPropertiesRows.add(properties);
                } else {
                    plainRelationshipRows.add(properties);
                }
                if (processState != NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) {
                    this.processNestedRelations(targetEntity, targetPropertyAccessor, isEntityNew, stateMachine, includeProperty, currentPropertyPath);
                }
                Object potentiallyRecreatedNewRelatedObject = MappingSupport.getRelationshipOrRelationshipPropertiesObject(this.neo4jMappingContext, relationshipDescription.hasRelationshipProperties(), relationshipProperty.isDynamicAssociation(), relatedValueToStore, targetPropertyAccessor);
                relationshipHandler.handle(relatedValueToStore, relatedObjectBeforeCallbacksApplied, potentiallyRecreatedNewRelatedObject);
            }
            if (!(relationshipDescription.hasRelationshipProperties() || relationshipDescription.isDynamic() || plainRelationshipRows.isEmpty())) {
                statementHolder = this.neo4jMappingContext.createStatementForImperativeSimpleRelationshipBatch(sourceEntity, relationshipDescription, plainRelationshipRows, canUseElementId);
                statementHolder = statementHolder.addProperty("__relationships__", plainRelationshipRows);
                ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).run();
            } else if (relationshipDescription.hasRelationshipProperties()) {
                if (!relationshipPropertiesRows.isEmpty()) {
                    statementHolder = this.neo4jMappingContext.createStatementForImperativeRelationshipsWithPropertiesBatch(false, sourceEntity, relationshipDescription, updateRelatedValuesToStore, relationshipPropertiesRows, canUseElementId);
                    statementHolder = statementHolder.addProperty("__relationships__", relationshipPropertiesRows);
                    ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).run();
                }
                if (!newRelatedValuesToStore.isEmpty()) {
                    statementHolder = this.neo4jMappingContext.createStatementForImperativeRelationshipsWithPropertiesBatch(true, sourceEntity, relationshipDescription, newRelatedValuesToStore, newRelationshipPropertiesRows, canUseElementId);
                    ArrayList<Object> all = new ArrayList<Object>(((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).fetchAs(Object.class).mappedBy((t, r) -> IdentitySupport.mapperForRelatedIdValues(idProperty).apply((MapAccessor)r)).all());
                    for (int i2 = 0; i2 < all.size(); ++i2) {
                        Object anId = all.get(i2);
                        this.assignIdToRelationshipProperties(relationshipContext, newRelatedValuesToStore.get(i2), idProperty, anId);
                    }
                }
            }
            relationshipHandler.applyFinalResultToOwner(propertyAccessor);
        }));
        Object finalSubgraphRoot = propertyAccessor.getBean();
        return (T)finalSubgraphRoot;
    }

    private void assignIdToRelationshipProperties(NestedRelationshipContext relationshipContext, Object relatedValueToStore, Neo4jPersistentProperty idProperty, Object relationshipInternalId) {
        relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).setProperty((PersistentProperty)idProperty, relationshipInternalId);
    }

    private Entity saveRelatedNode(Object entity, NodeDescription<?> targetNodeDescription, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath currentPropertyPath) {
        Neo4jPersistentEntity targetPersistentEntity = (Neo4jPersistentEntity)targetNodeDescription;
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entity, targetPersistentEntity);
        Class entityType = targetPersistentEntity.getType();
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType);
        binderFunction = binderFunction.andThen(tree -> {
            boolean assignedId;
            Map properties = (Map)tree.get("__properties__");
            String idPropertyName = ((Neo4jPersistentProperty)targetPersistentEntity.getIdProperty()).getPropertyName();
            IdDescription idDescription = targetPersistentEntity.getIdDescription();
            boolean bl = assignedId = idDescription.isAssignedId() || idDescription.isExternallyGeneratedId();
            if (!includeProperty.isNotFiltering()) {
                properties.entrySet().removeIf(e -> {
                    boolean isIdProperty = ((String)e.getKey()).equals(idPropertyName);
                    return (!assignedId || !isIdProperty) && !includeProperty.contains(currentPropertyPath.append((String)e.getKey()));
                });
            }
            return tree;
        });
        Optional optionalSavedNode = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels, TemplateSupport.rendererRendersElementId(this.renderer)))).bind(entity).with(binderFunction)).fetchAs(Entity.class).one();
        if (targetPersistentEntity.hasVersionProperty() && !optionalSavedNode.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        return (Entity)optionalSavedNode.get();
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader == null ? ClassUtils.getDefaultClassLoader() : beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = EventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
        SpelAwareProxyProjectionFactory spelAwareProxyProjectionFactory = new SpelAwareProxyProjectionFactory();
        spelAwareProxyProjectionFactory.setBeanClassLoader(this.beanClassLoader);
        spelAwareProxyProjectionFactory.setBeanFactory(beanFactory);
        this.projectionFactory = spelAwareProxyProjectionFactory;
        Configuration cypherDslConfiguration = (Configuration)beanFactory.getBeanProvider(Configuration.class).getIfAvailable(Configuration::defaultConfig);
        this.renderer = Renderer.getRenderer((Configuration)cypherDslConfiguration);
        this.elementIdOrIdFunction = SpringDataCypherDsl.elementIdOrIdFunction.apply(cypherDslConfiguration.getDialect());
        this.cypherGenerator.setElementIdOrIdFunction(this.elementIdOrIdFunction);
        if (this.transactionTemplate != null && this.transactionTemplateReadOnly != null) {
            return;
        }
        Neo4jTransactionManager transactionManager = null;
        Iterator it = beanFactory.getBeanProvider(PlatformTransactionManager.class).stream().iterator();
        while (it.hasNext()) {
            PlatformTransactionManager transactionManagerCandidate = (PlatformTransactionManager)it.next();
            if (!(transactionManagerCandidate instanceof Neo4jTransactionManager)) continue;
            Neo4jTransactionManager neo4jTransactionManager = (Neo4jTransactionManager)transactionManagerCandidate;
            if (transactionManager != null) {
                throw new IllegalStateException("Multiple Neo4jTransactionManagers are defined in this context. If this in intended, please pass the transaction manager to use with this Neo4jTemplate in the constructor");
            }
            transactionManager = neo4jTransactionManager;
        }
        this.setTransactionManager((PlatformTransactionManager)transactionManager);
    }

    public void setCypherRenderer(Renderer rendererFromCdiConfiguration) {
        this.renderer = rendererFromCdiConfiguration;
    }

    public void setTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
        if (transactionManager == null) {
            return;
        }
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplateReadOnly = new TransactionTemplate(transactionManager, readOnlyTransactionDefinition);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return this.createExecutableQuery(domainType, null, queryFragmentsAndParameters);
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction = TemplateSupport.getAndDecorateMappingFunction(this.neo4jMappingContext, domainType, resultType);
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withQueryFragmentsAndParameters(queryFragmentsAndParameters).usingMappingFunction(mappingFunction).build();
        return this.toExecutableQuery(preparedQuery);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return new DefaultExecutableQuery<T>(preparedQuery);
    }

    @Override
    public <T> FluentSaveOperation.ExecutableSave<T> save(Class<T> domainType) {
        return new FluentOperationSupport(this).save(domainType);
    }

    <T, R> List<R> doSave(Iterable<R> instances, Class<T> domainType) {
        return (List)this.transactionTemplate.execute(tx -> {
            if (!instances.iterator().hasNext()) {
                return Collections.emptyList();
            }
            Class<?> resultType = TemplateSupport.findCommonElementType(instances);
            Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(domainType, resultType, this.getProjectionFactory(), this.neo4jMappingContext);
            NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
            ArrayList<Object> results = new ArrayList<Object>();
            EntityFromDtoInstantiatingConverter converter = new EntityFromDtoInstantiatingConverter(domainType, this.neo4jMappingContext);
            for (Object instance : instances) {
                Object domainObject = converter.convert(instance);
                Object savedEntity = this.saveImpl(domainObject, pps, stateMachine);
                Object convertedBack = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext).convertDirectly(savedEntity);
                results.add(convertedBack);
            }
            return results;
        });
    }

    String render(Statement statement) {
        return this.renderer.render(statement);
    }

    final class DefaultExecutableQuery<T>
    implements Neo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;

        DefaultExecutableQuery(PreparedQuery<T> preparedQuery) {
            this.preparedQuery = preparedQuery;
        }

        @Override
        public List<T> getResults() {
            return (List)Neo4jTemplate.this.transactionTemplate.execute(tx -> {
                Collection all = this.createFetchSpec().map(Neo4jClient.RecordFetchSpec::all).orElse(Collections.emptyList());
                if (this.preparedQuery.resultsHaveBeenAggregated()) {
                    return all.stream().flatMap(nested -> ((Collection)nested).stream()).distinct().collect(Collectors.toList());
                }
                return all.stream().collect(Collectors.toList());
            });
        }

        @Override
        public Optional<T> getSingleResult() {
            return (Optional)Neo4jTemplate.this.transactionTemplate.execute(tx -> {
                try {
                    Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
                    if (this.preparedQuery.resultsHaveBeenAggregated()) {
                        return one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
                    }
                    return one;
                }
                catch (NoSuchRecordException e) {
                    throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
                }
            });
        }

        @Override
        public T getRequiredSingleResult() {
            return (T)Neo4jTemplate.this.transactionTemplate.execute(tx -> {
                Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
                if (this.preparedQuery.resultsHaveBeenAggregated()) {
                    one = one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
                }
                return one.orElseThrow(() -> new NoResultException(1, this.preparedQuery.getQueryFragmentsAndParameters().getCypherQuery()));
            });
        }

        /*
         * Unable to fully structure code
         */
        private Optional<Neo4jClient.RecordFetchSpec<T>> createFetchSpec() {
            queryFragmentsAndParameters = this.preparedQuery.getQueryFragmentsAndParameters();
            cypherQuery = queryFragmentsAndParameters.getCypherQuery();
            finalParameters = queryFragmentsAndParameters.getParameters();
            queryFragments = queryFragmentsAndParameters.getQueryFragments();
            entityMetaData = (Neo4jPersistentEntity)queryFragmentsAndParameters.getNodeDescription();
            if (entityMetaData == null) ** GOTO lbl-1000
            if (entityMetaData.containsPossibleCircles((Predicate<PropertyFilter.RelaxedPropertyPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(org.springframework.data.neo4j.core.mapping.PropertyFilter$RelaxedPropertyPath ), (Lorg/springframework/data/neo4j/core/mapping/PropertyFilter$RelaxedPropertyPath;)Z)((QueryFragments)queryFragments))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = containsPossibleCircles = false;
            }
            if (cypherQuery == null || containsPossibleCircles) {
                if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
                    nodesAndRelationshipsById = this.createNodesAndRelationshipsByIdStatementProvider(entityMetaData, queryFragments, queryFragmentsAndParameters.getParameters());
                    if (nodesAndRelationshipsById.hasRootNodeIds()) {
                        return Optional.empty();
                    }
                    cypherQuery = Neo4jTemplate.this.renderer.render(nodesAndRelationshipsById.toStatement(entityMetaData));
                    finalParameters = nodesAndRelationshipsById.getParameters();
                } else {
                    statement = queryFragments.toStatement();
                    cypherQuery = Neo4jTemplate.this.renderer.render(statement);
                    finalParameters = TemplateSupport.mergeParameters(statement, finalParameters);
                }
            }
            newMappingSpec = ((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(cypherQuery).bindAll(finalParameters)).fetchAs(this.preparedQuery.getResultType());
            return Optional.of((Neo4jClient.RecordFetchSpec)this.preparedQuery.getOptionalMappingFunction().map((Function<BiFunction, Neo4jClient.RecordFetchSpec>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, mappedBy(java.util.function.BiFunction<org.neo4j.driver.types.TypeSystem, org.neo4j.driver.Record, T> ), (Ljava/util/function/BiFunction;)Lorg/springframework/data/neo4j/core/Neo4jClient$RecordFetchSpec;)(newMappingSpec)).orElse(newMappingSpec));
        }

        private TemplateSupport.NodesAndRelationshipsByIdStatementProvider createNodesAndRelationshipsByIdStatementProvider(Neo4jPersistentEntity<?> entityMetaData, QueryFragments queryFragments, Map<String, Object> parameters) {
            Statement rootNodesStatement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(new String[]{"__sn__"}).build();
            HashMap<String, Object> usedParameters = new HashMap<String, Object>(parameters);
            usedParameters.putAll(rootNodesStatement.getCatalog().getParameters());
            HashSet<String> rootNodeIds = new HashSet<String>(((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(rootNodesStatement)).bindAll(usedParameters)).fetchAs(Value.class).mappedBy((t, r) -> r.get("__sn__")).one().map(value -> value.asList(TemplateSupport::convertIdOrElementIdToString)).get());
            if (rootNodeIds.isEmpty()) {
                return TemplateSupport.NodesAndRelationshipsByIdStatementProvider.EMPTY;
            }
            HashMap<String, Set<String>> relationshipsToRelatedNodeIds = new HashMap<String, Set<String>>();
            for (RelationshipDescription relationshipDescription : entityMetaData.getRelationshipsInHierarchy(queryFragments::includeField)) {
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, relationshipDescription, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(Neo4jTemplate.this.cypherGenerator.createReturnStatementForMatch(entityMetaData)).build();
                usedParameters = new HashMap<String, Object>(parameters);
                usedParameters.putAll(statement.getCatalog().getParameters());
                ((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(statement)).bindAll(usedParameters)).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipsToRelatedNodeIds, relationshipDescription, PropertyPathWalkStep.empty()));
            }
            return new TemplateSupport.NodesAndRelationshipsByIdStatementProvider(rootNodeIds, relationshipsToRelatedNodeIds.keySet(), relationshipsToRelatedNodeIds.values().stream().flatMap(Collection::stream).toList(), queryFragments, Neo4jTemplate.this.elementIdOrIdFunction);
        }

        private void iterateNextLevel(Collection<String> nodeIds, RelationshipDescription sourceRelationshipDescription, Map<String, Set<String>> relationshipsToRelatedNodes, PropertyPathWalkStep currentPathStep) {
            Neo4jPersistentEntity target = (Neo4jPersistentEntity)sourceRelationshipDescription.getTarget();
            String fieldName = ((Neo4jPersistentProperty)((Association)sourceRelationshipDescription).getInverse()).getFieldName();
            PropertyPathWalkStep nextPathStep = currentPathStep.with((String)(sourceRelationshipDescription.hasRelationshipProperties() ? fieldName + "." + ((Neo4jPersistentProperty)((Neo4jPersistentEntity)sourceRelationshipDescription.getRelationshipPropertiesEntity()).getPersistentProperty(TargetNode.class)).getFieldName() : fieldName));
            Collection relationships = target.getRelationshipsInHierarchy(relaxedPropertyPath -> {
                PropertyFilter.RelaxedPropertyPath prepend = relaxedPropertyPath.prepend(nextPathStep.path);
                prepend = PropertyFilter.RelaxedPropertyPath.withRootType(this.preparedQuery.getResultType()).append(prepend.toDotPath());
                return this.preparedQuery.getQueryFragmentsAndParameters().getQueryFragments().includeField(prepend);
            });
            for (RelationshipDescription relationshipDescription : relationships) {
                Node node = Cypher.anyNode((SymbolicName)Constants.NAME_OF_TYPED_ROOT_NODE.apply(target));
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(target, relationshipDescription, null, Neo4jTemplate.this.elementIdOrIdFunction.apply((Named)node).in((Expression)Cypher.parameter((String)"__ids__"))).returning(Neo4jTemplate.this.cypherGenerator.createGenericReturnStatement()).build();
                ((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(statement)).bindAll(Collections.singletonMap("__ids__", TemplateSupport.convertToLongIdOrStringElementId(nodeIds)))).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipsToRelatedNodes, relationshipDescription, nextPathStep));
            }
        }

        @NonNull
        private Consumer<Map<String, Object>> iterateAndMapNextLevel(Map<String, Set<String>> relationshipsToRelatedNodes, RelationshipDescription relationshipDescription, PropertyPathWalkStep currentPathStep) {
            return record -> {
                HashMap relatedNodesVisited = new HashMap(relationshipsToRelatedNodes);
                List<String> newRelationshipIds = ((List)record.get("__sr__")).stream().map(TemplateSupport::convertIdOrElementIdToString).toList();
                HashSet<String> relatedIds = new HashSet<String>(((List)record.get("__srn__")).stream().map(TemplateSupport::convertIdOrElementIdToString).toList());
                for (String newRelationshipId : newRelationshipIds) {
                    relatedNodesVisited.put(newRelationshipId, relatedIds);
                    Set knownRelatedNodesBefore = (Set)relationshipsToRelatedNodes.get(newRelationshipId);
                    if (knownRelatedNodesBefore == null) continue;
                    HashSet<String> mergedKnownRelatedNodes = new HashSet<String>(knownRelatedNodesBefore);
                    mergedKnownRelatedNodes.addAll(relatedIds);
                    relatedNodesVisited.put(newRelationshipId, mergedKnownRelatedNodes);
                    relatedIds.removeAll(knownRelatedNodesBefore);
                }
                relationshipsToRelatedNodes.putAll(relatedNodesVisited);
                if (!relatedIds.isEmpty()) {
                    this.iterateNextLevel(relatedIds, relationshipDescription, relationshipsToRelatedNodes, currentPathStep);
                }
            };
        }
    }
}

