/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.2")
final class FetchableFluentQueryByExample<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Neo4jMappingContext mappingContext;
    private final Example<S> example;
    private final FluentFindOperation findOperation;
    private final Function<Example<S>, Long> countOperation;
    private final Function<Example<S>, Boolean> existsOperation;

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, FluentFindOperation findOperation, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation) {
        this(example, resultType, mappingContext, findOperation, countOperation, existsOperation, Sort.unsorted(), null, null);
    }

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, FluentFindOperation findOperation, Function<Example<S>, Long> countOperation, Function<Example<S>, Boolean> existsOperation, Sort sort, @Nullable Integer limit, @Nullable Collection<String> properties) {
        super(resultType, sort, limit, properties);
        this.mappingContext = mappingContext;
        this.example = example;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.limit, this.properties);
    }

    public FluentQuery.FetchableFluentQuery<R> limit(int limit) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort, limit, this.properties);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        return new FetchableFluentQueryByExample<S, NR>(this.example, resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.limit, this.mergeProperties(this.extractAllPaths(properties)));
    }

    public R oneValue() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithSort(this.mappingContext, this.example, this.sort, this.limit, this.createIncludedFieldsPredicate())).oneValue();
    }

    public R firstValue() {
        List<R> all = this.all();
        return all.isEmpty() ? null : (R)all.get(0);
    }

    public List<R> all() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithSort(this.mappingContext, this.example, this.sort, this.limit, this.createIncludedFieldsPredicate())).all();
    }

    public Page<R> page(Pageable pageable) {
        List page = this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithPageable(this.mappingContext, this.example, pageable, this.createIncludedFieldsPredicate())).all();
        LongSupplier totalCountSupplier = this::count;
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Condition condition;
        long skip;
        Class domainType = this.example.getProbeType();
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(domainType);
        if (scrollPosition.isInitial()) {
            v0 = 0L;
        } else if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition;
            v0 = offsetScrollPosition.getOffset();
        } else {
            v0 = skip = 0L;
        }
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            condition = CypherAdapterUtils.combineKeysetIntoCondition((Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(this.example.getProbeType()), keysetScrollPosition, this.sort, this.mappingContext.getConversionService());
        } else {
            condition = null;
        }
        Condition condition2 = condition;
        List rawResult = this.findOperation.find(domainType).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithScrollPosition(this.mappingContext, this.example, condition2, this.sort, this.limit == null ? 1 : this.limit + 1, skip, scrollPosition, this.createIncludedFieldsPredicate())).all();
        return this.scroll(scrollPosition, rawResult, entity);
    }

    public Stream<R> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.countOperation.apply(this.example);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.example);
    }
}

