/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.Neo4jPropertyValueTransformers;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.repository.query.PropertyPathWrapper;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

final class Predicate {
    private final Neo4jPersistentEntity neo4jPersistentEntity;
    private Condition condition = Conditions.noCondition();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Set<PropertyPathWrapper> relationshipFields = new HashSet<PropertyPathWrapper>();

    static <S> Predicate create(Neo4jMappingContext mappingContext, Example<S> example) {
        Neo4jPersistentEntity nodeDescription = (Neo4jPersistentEntity)mappingContext.getRequiredPersistentEntity(example.getProbeType());
        Collection graphProperties = nodeDescription.getGraphProperties();
        DirectFieldAccessFallbackBeanWrapper beanWrapper = new DirectFieldAccessFallbackBeanWrapper(example.getProbe());
        ExampleMatcher matcher = example.getMatcher();
        ExampleMatcher.MatchMode mode = matcher.getMatchMode();
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(matcher);
        AtomicInteger relationshipPatternCount = new AtomicInteger();
        Predicate predicate = new Predicate(nodeDescription);
        for (GraphPropertyDescription graphProperty : graphProperties) {
            PropertyPath propertyPath = PropertyPath.from((String)graphProperty.getFieldName(), (TypeInformation)nodeDescription.getTypeInformation());
            PropertyPathWrapper propertyPathWrapper = new PropertyPathWrapper(relationshipPatternCount.incrementAndGet(), mappingContext.getPersistentPropertyPath(propertyPath), true);
            Predicate.addConditionAndParameters(mappingContext, nodeDescription, beanWrapper, mode, matcherAccessor, predicate, graphProperty, propertyPathWrapper);
        }
        Predicate.processRelationships(mappingContext, example, nodeDescription, beanWrapper, mode, relationshipPatternCount, null, predicate);
        return predicate;
    }

    private static <S> void processRelationships(Neo4jMappingContext mappingContext, Example<S> example, NodeDescription<?> currentNodeDescription, DirectFieldAccessFallbackBeanWrapper beanWrapper, ExampleMatcher.MatchMode mode, AtomicInteger relationshipPatternCount, @Nullable PropertyPath propertyPath, Predicate predicate) {
        for (RelationshipDescription relationship : currentNodeDescription.getRelationships()) {
            String relationshipFieldName = relationship.getFieldName();
            Object relationshipObject = beanWrapper.getPropertyValue(relationshipFieldName);
            if (relationshipObject == null) continue;
            if (relationshipObject instanceof Collection) {
                Collection collection = (Collection)relationshipObject;
                int collectionSize = collection.size();
                if (collectionSize > 1) {
                    throw new IllegalArgumentException("Cannot have more than one related node per collection.");
                }
                if (collectionSize == 0) continue;
                relationshipObject = collection.iterator().next();
            }
            NodeDescription<?> relatedNodeDescription = mappingContext.getNodeDescription(relationshipObject.getClass());
            PropertyPath nestedPropertyPath = propertyPath == null ? PropertyPath.from((String)relationshipFieldName, currentNodeDescription.getUnderlyingClass()) : propertyPath.nested(relationshipFieldName);
            PropertyPathWrapper nestedPropertyPathWrapper = new PropertyPathWrapper(relationshipPatternCount.incrementAndGet(), mappingContext.getPersistentPropertyPath(nestedPropertyPath), false);
            predicate.addRelationship(nestedPropertyPathWrapper);
            for (GraphPropertyDescription graphProperty : relatedNodeDescription.getGraphProperties()) {
                Predicate.addConditionAndParameters(mappingContext, (Neo4jPersistentEntity)relatedNodeDescription, new DirectFieldAccessFallbackBeanWrapper(relationshipObject), mode, new ExampleMatcherAccessor(example.getMatcher()), predicate, graphProperty, nestedPropertyPathWrapper);
            }
            Predicate.processRelationships(mappingContext, example, relatedNodeDescription, new DirectFieldAccessFallbackBeanWrapper(relationshipObject), mode, relationshipPatternCount, nestedPropertyPath, predicate);
        }
    }

    private static void addConditionAndParameters(Neo4jMappingContext mappingContext, Neo4jPersistentEntity<?> nodeDescription, DirectFieldAccessFallbackBeanWrapper beanWrapper, ExampleMatcher.MatchMode mode, ExampleMatcherAccessor matcherAccessor, Predicate predicate, GraphPropertyDescription graphProperty, PropertyPathWrapper wrapper) {
        Condition condition;
        String currentPath = graphProperty.getFieldName();
        if (matcherAccessor.isIgnoredPath(currentPath)) {
            return;
        }
        boolean internalId = graphProperty.isIdProperty() && nodeDescription.isUsingInternalIds();
        String propertyName = graphProperty.getPropertyName();
        ExampleMatcher.PropertyValueTransformer transformer = matcherAccessor.getValueTransformerForPath(currentPath);
        Optional optionalValue = (Optional)transformer.apply(Optional.ofNullable(beanWrapper.getPropertyValue(currentPath)));
        if (optionalValue.isEmpty()) {
            if (!internalId && matcherAccessor.getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE)) {
                predicate.add(mode, Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription)), (String[])new String[]{propertyName}).isNull());
            }
            return;
        }
        Neo4jConversionService conversionService = mappingContext.getConversionService();
        boolean isRootNode = predicate.neo4jPersistentEntity.equals(nodeDescription);
        Object theValue = optionalValue.map(v -> {
            Object object;
            if (v instanceof Neo4jPropertyValueTransformers.NegatedValue) {
                Neo4jPropertyValueTransformers.NegatedValue negatedValue = (Neo4jPropertyValueTransformers.NegatedValue)v;
                object = negatedValue.value();
            } else {
                object = v;
            }
            return object;
        }).get();
        if (graphProperty.isIdProperty() && nodeDescription.isUsingInternalIds()) {
            condition = isRootNode ? predicate.neo4jPersistentEntity.getIdExpression().isEqualTo((Expression)Cypher.literalOf((Object)theValue)) : nodeDescription.getIdExpression().isEqualTo((Expression)Cypher.literalOf((Object)theValue));
        } else {
            Property property = !isRootNode ? Cypher.property((String)wrapper.getNodeName(), (String[])new String[]{propertyName}) : Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription)), (String[])new String[]{propertyName});
            Parameter parameter = Cypher.parameter((String)(wrapper.getNodeName() + propertyName));
            condition = property.isEqualTo((Expression)parameter);
            if (String.class.equals(graphProperty.getActualType())) {
                if (matcherAccessor.isIgnoreCaseForPath(currentPath)) {
                    property = Functions.toLower((Expression)property);
                    parameter = Functions.toLower((Expression)parameter);
                }
                condition = switch (matcherAccessor.getStringMatcherForPath(currentPath)) {
                    default -> throw new IncompatibleClassChangeError();
                    case ExampleMatcher.StringMatcher.DEFAULT, ExampleMatcher.StringMatcher.EXACT -> property.isEqualTo((Expression)parameter);
                    case ExampleMatcher.StringMatcher.CONTAINING -> property.contains((Expression)parameter);
                    case ExampleMatcher.StringMatcher.STARTING -> property.startsWith((Expression)parameter);
                    case ExampleMatcher.StringMatcher.ENDING -> property.endsWith((Expression)parameter);
                    case ExampleMatcher.StringMatcher.REGEX -> property.matches((Expression)parameter);
                };
            }
            Neo4jPersistentProperty neo4jPersistentProperty = (Neo4jPersistentProperty)graphProperty;
            predicate.parameters.put(wrapper.getNodeName() + propertyName, conversionService.writeValue(theValue, neo4jPersistentProperty.getTypeInformation(), neo4jPersistentProperty.getOptionalConverter()));
        }
        predicate.add(mode, Predicate.postProcess(condition, optionalValue.get()));
    }

    private static Condition postProcess(Condition condition, Object transformedValue) {
        if (transformedValue instanceof Neo4jPropertyValueTransformers.NegatedValue) {
            return condition.not();
        }
        return condition;
    }

    private Predicate(Neo4jPersistentEntity neo4jPersistentEntity) {
        this.neo4jPersistentEntity = neo4jPersistentEntity;
    }

    public Condition getCondition() {
        return this.condition;
    }

    StatementBuilder.OrderableOngoingReadingAndWith useWithReadingFragment(BiFunction<NodeDescription<?>, Condition, StatementBuilder.OrderableOngoingReadingAndWith> readingFragmentSupplier) {
        return readingFragmentSupplier.apply(this.neo4jPersistentEntity, this.condition);
    }

    private void add(ExampleMatcher.MatchMode matchMode, Condition additionalCondition) {
        this.condition = switch (matchMode) {
            default -> throw new IncompatibleClassChangeError();
            case ExampleMatcher.MatchMode.ALL -> this.condition.and(additionalCondition);
            case ExampleMatcher.MatchMode.ANY -> this.condition.or(additionalCondition);
        };
    }

    private void addRelationship(PropertyPathWrapper propertyPathWrapper) {
        this.relationshipFields.add(propertyPathWrapper);
    }

    public NodeDescription<?> getNeo4jPersistentEntity() {
        return this.neo4jPersistentEntity;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Set<PropertyPathWrapper> getPropertyPathWrappers() {
        return this.relationshipFields;
    }
}

