/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.Optional;
import org.aopalliance.aop.Advice;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.ReactiveCypherdslConditionExecutorImpl;
import org.springframework.data.neo4j.repository.query.ReactiveNeo4jQueryLookupStrategy;
import org.springframework.data.neo4j.repository.query.ReactiveQuerydslNeo4jPredicateExecutor;
import org.springframework.data.neo4j.repository.query.SimpleReactiveQueryByExampleExecutor;
import org.springframework.data.neo4j.repository.support.DefaultNeo4jEntityInformation;
import org.springframework.data.neo4j.repository.support.EntityAndGraphPropertyAccessingMethodInterceptor;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactorySupport;
import org.springframework.data.neo4j.repository.support.ReactiveCypherdslConditionExecutor;
import org.springframework.data.neo4j.repository.support.ReactivePersistenceExceptionTranslationInterceptor;
import org.springframework.data.neo4j.repository.support.SimpleReactiveNeo4jRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;

final class ReactiveNeo4jRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;

    ReactiveNeo4jRepositoryFactory(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
    }

    public <T, ID> Neo4jEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new DefaultNeo4jEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        Neo4jRepositoryFactorySupport.assertIdentifierType(metadata.getIdType(), entityInformation.getIdType());
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.neo4jOperations, entityInformation});
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        boolean isQueryDslRepository;
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        SimpleReactiveQueryByExampleExecutor byExampleExecutor = (SimpleReactiveQueryByExampleExecutor)this.instantiateClass(SimpleReactiveQueryByExampleExecutor.class, new Object[]{this.neo4jOperations, this.mappingContext});
        fragments = fragments.append(RepositoryFragment.implemented((Object)byExampleExecutor));
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && ReactiveQuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            fragments = fragments.append(this.createDSLPredicateExecutorFragment(metadata, ReactiveQuerydslNeo4jPredicateExecutor.class));
        }
        if (ReactiveCypherdslConditionExecutor.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            fragments = fragments.append(this.createDSLExecutorFragment(metadata, ReactiveCypherdslConditionExecutorImpl.class));
        }
        return fragments;
    }

    private RepositoryFragment<Object> createDSLPredicateExecutorFragment(RepositoryMetadata metadata, Class<?> implementor) {
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        Object querydslFragment = this.instantiateClass(implementor, new Object[]{this.mappingContext, entityInformation, this.neo4jOperations});
        return RepositoryFragment.implemented((Object)querydslFragment);
    }

    private RepositoryFragment<Object> createDSLExecutorFragment(RepositoryMetadata metadata, Class<?> implementor) {
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        Object querydslFragment = this.instantiateClass(implementor, new Object[]{entityInformation, this.neo4jOperations});
        return RepositoryFragment.implemented((Object)querydslFragment);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveNeo4jRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new ReactiveNeo4jQueryLookupStrategy(this.neo4jOperations, this.mappingContext, evaluationContextProvider));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ListableBeanFactory) {
            this.addRepositoryProxyPostProcessor((factory, repositoryInformation) -> {
                ReactivePersistenceExceptionTranslationInterceptor advice = new ReactivePersistenceExceptionTranslationInterceptor((ListableBeanFactory)beanFactory);
                factory.addAdvice((Advice)advice);
            });
        }
    }

    protected ProjectionFactory getProjectionFactory() {
        ProjectionFactory projectionFactory = super.getProjectionFactory();
        if (projectionFactory instanceof SpelAwareProxyProjectionFactory) {
            ((SpelAwareProxyProjectionFactory)projectionFactory).registerMethodInvokerFactory(EntityAndGraphPropertyAccessingMethodInterceptor.createMethodInterceptorFactory(this.mappingContext));
        }
        return projectionFactory;
    }
}

