/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.TargetNode;

@API(status=API.Status.INTERNAL, since="6.3")
public final class PropertyHandlerSupport {
    private static final Map<Neo4jPersistentEntity<?>, PropertyHandlerSupport> CACHE = new ConcurrentHashMap();
    private final Neo4jPersistentEntity<?> entity;

    public static PropertyHandlerSupport of(Neo4jPersistentEntity<?> entity) {
        return CACHE.computeIfAbsent(entity, PropertyHandlerSupport::new);
    }

    private PropertyHandlerSupport(Neo4jPersistentEntity<?> entity) {
        this.entity = entity;
    }

    public Neo4jPersistentEntity<?> doWithProperties(PropertyHandler<Neo4jPersistentProperty> handler) {
        this.entity.doWithProperties(handler);
        this.entity.doWithAssociations(association -> {
            if (((Neo4jPersistentProperty)association.getInverse()).isAnnotationPresent(TargetNode.class)) {
                handler.doWithPersistentProperty((PersistentProperty)((Neo4jPersistentProperty)association.getInverse()));
            }
        });
        return this.entity;
    }
}

