/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.lang.Nullable;

final class NodeDescriptionStore {
    private final Map<String, NodeDescription<?>> nodeDescriptionsByPrimaryLabel = new ConcurrentHashMap();
    private final Map<NodeDescription<?>, Map<List<String>, NodeDescriptionAndLabels>> nodeDescriptionAndLabelsCache = new ConcurrentHashMap();
    private final BiFunction<NodeDescription<?>, List<String>, NodeDescriptionAndLabels> nodeDescriptionAndLabels = (nodeDescription, labels) -> {
        NodeDescriptionAndLabels cachedNodeDescriptionAndLabels;
        Map<List<String>, NodeDescriptionAndLabels> listNodeDescriptionAndLabelsMap = this.nodeDescriptionAndLabelsCache.get(nodeDescription);
        if (listNodeDescriptionAndLabelsMap == null) {
            this.nodeDescriptionAndLabelsCache.put((NodeDescription<?>)nodeDescription, new ConcurrentHashMap());
            listNodeDescriptionAndLabelsMap = this.nodeDescriptionAndLabelsCache.get(nodeDescription);
        }
        if ((cachedNodeDescriptionAndLabels = listNodeDescriptionAndLabelsMap.get(labels)) == null) {
            cachedNodeDescriptionAndLabels = this.computeConcreteNodeDescription((NodeDescription<?>)nodeDescription, (List<String>)labels);
            listNodeDescriptionAndLabelsMap.put((List<String>)labels, cachedNodeDescriptionAndLabels);
        }
        return cachedNodeDescriptionAndLabels;
    };

    NodeDescriptionStore() {
    }

    public boolean containsKey(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.containsKey(primaryLabel);
    }

    public <T> boolean containsValue(DefaultNeo4jPersistentEntity<T> newEntity) {
        return this.nodeDescriptionsByPrimaryLabel.containsValue(newEntity);
    }

    public <T> void put(String primaryLabel, DefaultNeo4jPersistentEntity<T> newEntity) {
        this.nodeDescriptionsByPrimaryLabel.put(primaryLabel, newEntity);
    }

    public Set<Map.Entry<String, NodeDescription<?>>> entrySet() {
        return this.nodeDescriptionsByPrimaryLabel.entrySet();
    }

    public Collection<NodeDescription<?>> values() {
        return this.nodeDescriptionsByPrimaryLabel.values();
    }

    @Nullable
    public NodeDescription<?> get(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.get(primaryLabel);
    }

    @Nullable
    public NodeDescription<?> getNodeDescription(Class<?> targetType) {
        for (NodeDescription<?> nodeDescription : this.values()) {
            if (!nodeDescription.getUnderlyingClass().equals(targetType)) continue;
            return nodeDescription;
        }
        return null;
    }

    public NodeDescriptionAndLabels deriveConcreteNodeDescription(NodeDescription<?> entityDescription, List<String> labels) {
        return this.nodeDescriptionAndLabels.apply(entityDescription, labels);
    }

    private NodeDescriptionAndLabels computeConcreteNodeDescription(NodeDescription<?> entityDescription, List<String> labels) {
        boolean isConcreteClassThatFulfillsEverything;
        boolean bl = isConcreteClassThatFulfillsEverything = !Modifier.isAbstract(entityDescription.getUnderlyingClass().getModifiers()) && entityDescription.getStaticLabels().containsAll(labels);
        if (labels == null || labels.isEmpty() || isConcreteClassThatFulfillsEverything) {
            return new NodeDescriptionAndLabels(entityDescription, Collections.emptyList());
        }
        Collection<NodeDescription<?>> haystack = entityDescription.describesInterface() ? this.values() : entityDescription.getChildNodeDescriptionsInHierarchy();
        if (!haystack.isEmpty()) {
            NodeDescription<?> mostMatchingNodeDescription = null;
            HashMap unmatchedLabelsCache = new HashMap();
            List<String> mostMatchingStaticLabels = null;
            Function<NodeDescription, Integer> unmatchedLabelsCount = nodeDescription -> {
                HashSet staticLabelsClone = new HashSet(labels);
                nodeDescription.getStaticLabels().forEach(staticLabelsClone::remove);
                return staticLabelsClone.size();
            };
            for (NodeDescription<?> nd : haystack) {
                List<String> staticLabels = nd.getStaticLabels();
                if (staticLabels.containsAll(labels)) {
                    HashSet<String> surplusLabels = new HashSet<String>(labels);
                    staticLabels.forEach(surplusLabels::remove);
                    return new NodeDescriptionAndLabels(nd, surplusLabels);
                }
                unmatchedLabelsCache.put(nd, unmatchedLabelsCount.apply(nd));
                if (mostMatchingNodeDescription == null) {
                    mostMatchingNodeDescription = nd;
                    mostMatchingStaticLabels = staticLabels;
                    continue;
                }
                Integer newUnmatchedLabelCount = (Integer)unmatchedLabelsCache.get(nd);
                Integer existingUnmatchedLabelCount = (Integer)unmatchedLabelsCache.get(mostMatchingNodeDescription);
                if (newUnmatchedLabelCount >= existingUnmatchedLabelCount) continue;
                mostMatchingNodeDescription = nd;
            }
            HashSet<String> surplusLabels = new HashSet<String>(labels);
            mostMatchingStaticLabels.forEach(surplusLabels::remove);
            return new NodeDescriptionAndLabels(mostMatchingNodeDescription, surplusLabels);
        }
        HashSet<String> surplusLabels = new HashSet<String>(labels);
        surplusLabels.remove(entityDescription.getPrimaryLabel());
        entityDescription.getAdditionalLabels().forEach(surplusLabels::remove);
        return new NodeDescriptionAndLabels(entityDescription, surplusLabels);
    }
}

