/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.PropertyFilterSupport;
import org.springframework.data.neo4j.core.PropertyPathWalkStep;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.ReactiveFluentNeo4jOperations;
import org.springframework.data.neo4j.core.ReactiveFluentOperationSupport;
import org.springframework.data.neo4j.core.ReactiveFluentSaveOperation;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.RelationshipHandler;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.DtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityFromDtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveEventSupport;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@API(status=API.Status.STABLE, since="6.0")
public final class ReactiveNeo4jTemplate
implements ReactiveNeo4jOperations,
ReactiveFluentNeo4jOperations,
BeanClassLoaderAware,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(ReactiveNeo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final Renderer renderer = Renderer.getDefaultRenderer();
    private static final String CONTEXT_RELATIONSHIP_HANDLER = "RELATIONSHIP_HANDLER";
    private final ReactiveNeo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private ClassLoader beanClassLoader;
    private ReactiveEventSupport eventSupport;
    private ProjectionFactory projectionFactory;

    @Deprecated
    public ReactiveNeo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        this(neo4jClient, neo4jMappingContext);
        if (!Objects.equals(databaseSelectionProvider, neo4jClient.getDatabaseSelectionProvider())) {
            throw new IllegalStateException("The provided database selection provider differs from the ReactiveNeo4jClient's one.");
        }
    }

    public ReactiveNeo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = ReactiveEventSupport.useExistingCallbacks(neo4jMappingContext, ReactiveEntityCallbacks.create());
    }

    @Override
    public Mono<Long> count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public Mono<Long> count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(Statement statement, Map<String, Object> parameters) {
        return this.count(renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    @Override
    public Mono<Long> count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> domainType) {
        return this.doFindAll(domainType, null);
    }

    private <T> Flux<T> doFindAll(Class<T> domainType, @Nullable Class<?> resultType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, resultType, QueryFragmentsAndParameters.forFindAll(entityMetaData)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, statement, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, statement, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, cypherQuery, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, cypherQuery, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> ReactiveFluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        return new ReactiveFluentOperationSupport(this).find(domainType);
    }

    <T, R> Flux<R> doFind(@Nullable String cypherQuery, @Nullable Map<String, Object> parameters, Class<T> domainType, Class<R> resultType, TemplateSupport.FetchType fetchType) {
        Flux intermediaResults = null;
        if (cypherQuery == null && fetchType == TemplateSupport.FetchType.ALL) {
            intermediaResults = this.doFindAll(domainType, resultType);
        } else {
            Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> executableQuery = this.createExecutableQuery(domainType, resultType, cypherQuery, parameters == null ? Collections.emptyMap() : parameters);
            switch (fetchType) {
                case ALL: {
                    intermediaResults = executableQuery.flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
                    break;
                }
                case ONE: {
                    intermediaResults = executableQuery.flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult).flux();
                }
            }
        }
        if (resultType.isAssignableFrom(domainType)) {
            return intermediaResults;
        }
        if (resultType.isInterface()) {
            return intermediaResults.map(instance -> this.projectionFactory.createProjection(resultType, instance));
        }
        DtoInstantiatingConverter converter = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext);
        return intermediaResults.map(EntityInstanceWithSource.class::cast).map(converter::convert);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindByAllId(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> toExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return this.createExecutableQuery(domainType, null, queryFragmentsAndParameters);
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        if (((Neo4jPersistentEntity)idProperty.getOwner()).isUsingInternalIds()) {
            return idValues;
        }
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalConverter());
    }

    @Override
    public <T> Mono<T> save(T instance) {
        return this.saveImpl(instance, Collections.emptyMap(), null);
    }

    @Override
    public <T, R> Mono<R> saveAs(T instance, Class<R> resultType) {
        Assert.notNull(resultType, (String)"ResultType must not be null!");
        if (instance == null) {
            return null;
        }
        if (resultType.equals(instance.getClass())) {
            return this.save(instance);
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(resultType);
        Map<PropertyPath, Boolean> pps = PropertyFilterSupport.addPropertiesFrom(instance.getClass(), resultType, this.projectionFactory, this.neo4jMappingContext);
        Mono<T> savingPublisher = this.saveImpl(instance, pps, null);
        if (projectionInformation.isClosed()) {
            return savingPublisher.map(savedInstance -> this.projectionFactory.createProjection(resultType, savedInstance));
        }
        return savingPublisher.flatMap(savedInstance -> {
            Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(savedInstance.getClass());
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
            return this.findById(propertyAccessor.getProperty((PersistentProperty)idProperty), savedInstance.getClass()).map(loadedValue -> this.projectionFactory.createProjection(resultType, loadedValue));
        });
    }

    <T, R> Flux<R> doSave(Iterable<R> instances, Class<T> domainType) {
        if (!instances.iterator().hasNext()) {
            return Flux.empty();
        }
        Class<?> resultType = TemplateSupport.findCommonElementType(instances);
        Map<PropertyPath, Boolean> pps = PropertyFilterSupport.addPropertiesFrom(domainType, resultType, this.projectionFactory, this.neo4jMappingContext);
        NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
        EntityFromDtoInstantiatingConverter converter = new EntityFromDtoInstantiatingConverter(domainType, this.neo4jMappingContext);
        return Flux.fromIterable(instances).flatMap(instance -> {
            Object domainObject = converter.convert(instance);
            return this.saveImpl(domainObject, pps, stateMachine).map(savedEntity -> new DtoInstantiatingConverter(resultType, this.neo4jMappingContext).convertDirectly(savedEntity));
        });
    }

    private <T> Mono<T> saveImpl(T instance, @Nullable Map<PropertyPath, Boolean> includedProperties, @Nullable NestedRelationshipProcessingStateMachine stateMachine) {
        if (stateMachine != null && stateMachine.hasProcessedValue(instance)) {
            return Mono.just(instance);
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(instance.getClass());
        boolean isNewEntity = entityMetaData.isNew(instance);
        NestedRelationshipProcessingStateMachine finalStateMachine = stateMachine == null ? new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext) : stateMachine;
        return Mono.just(instance).flatMap(this.eventSupport::maybeCallBeforeBind).flatMap(entityToBeSaved -> this.determineDynamicLabels(entityToBeSaved, entityMetaData)).flatMap(t -> {
            Object entityToBeSaved = t.getT1();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            TemplateSupport.FilteredBinderFunction binderFunction = TemplateSupport.createAndApplyPropertyFilter(includedProperties, entityMetaData, this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()));
            Mono idMono = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels))).bind(entityToBeSaved).with(binderFunction)).fetchAs(Entity.class).one().switchIfEmpty(Mono.defer(() -> {
                if (entityMetaData.hasVersionProperty()) {
                    return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
                }
                return Mono.empty();
            }));
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            return idMono.doOnNext(newOrUpdatedNode -> {
                if (entityMetaData.isUsingInternalIds()) {
                    propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), (Object)newOrUpdatedNode.id());
                }
                TemplateSupport.updateVersionPropertyIfPossible(entityMetaData, propertyAccessor, newOrUpdatedNode);
                finalStateMachine.markValueAsProcessed(instance, newOrUpdatedNode.id());
            }).map(Entity::id).flatMap(internalId -> this.processRelations(entityMetaData, propertyAccessor, isNewEntity, finalStateMachine, binderFunction.filter));
        });
    }

    private <T> Mono<Tuple2<T, DynamicLabels>> determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            ReactiveNeo4jClient.RunnableSpecTightToDatabase runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).bind(this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty))).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty())).to("__version__");
            }
            return runnableQuery.fetch().one().map(m -> (Collection)m.get("__nodeLabels__")).switchIfEmpty(Mono.just(Collections.emptyList())).zipWith(Mono.just((Object)((Collection)propertyAccessor.getProperty((PersistentProperty)p)))).map(t -> Tuples.of((Object)entityToBeSaved, (Object)new DynamicLabels((Collection)t.getT1(), (Collection)t.getT2())));
        }).orElse(Mono.just((Object)Tuples.of(entityToBeSaved, (Object)DynamicLabels.EMPTY)));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> instances) {
        return this.saveAllImpl(instances, Collections.emptyMap());
    }

    @Override
    public <T, R> Flux<R> saveAllAs(Iterable<T> instances, Class<R> resultType) {
        Assert.notNull(resultType, (String)"ResultType must not be null!");
        Class<?> commonElementType = TemplateSupport.findCommonElementType(instances);
        if (resultType.isAssignableFrom(commonElementType)) {
            return this.saveAll(instances);
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(resultType);
        Map<PropertyPath, Boolean> pps = PropertyFilterSupport.addPropertiesFrom(commonElementType, resultType, this.projectionFactory, this.neo4jMappingContext);
        Flux<T> savedInstances = this.saveAllImpl(instances, pps);
        if (projectionInformation.isClosed()) {
            return savedInstances.map(instance -> this.projectionFactory.createProjection(resultType, instance));
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(commonElementType);
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
        return savedInstances.flatMap(savedInstance -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
            return this.findById(propertyAccessor.getProperty((PersistentProperty)idProperty), commonElementType);
        }).map(instance -> this.projectionFactory.createProjection(resultType, instance));
    }

    private <T> Flux<T> saveAllImpl(Iterable<T> instances, @Nullable Map<PropertyPath, Boolean> includedProperties) {
        HashSet types = new HashSet();
        ArrayList entities = new ArrayList();
        instances.forEach(instance -> {
            entities.add(instance);
            types.add(instance.getClass());
        });
        if (entities.isEmpty()) {
            return Flux.empty();
        }
        boolean heterogeneousCollection = types.size() > 1;
        Class domainClass = (Class)types.iterator().next();
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainClass);
        if (heterogeneousCollection || entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
            return Flux.fromIterable(entities).concatMap(e -> this.saveImpl(e, includedProperties, stateMachine));
        }
        TemplateSupport.FilteredBinderFunction binderFunction = TemplateSupport.createAndApplyPropertyFilter(includedProperties, entityMetaData, this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass));
        return Flux.fromIterable(entities).map(e -> Tuples.of((Object)e, (Object)entityMetaData.isNew(e))).zipWith((Publisher)Flux.fromIterable(entities).flatMapSequential(this.eventSupport::maybeCallBeforeBind)).map(nested -> Tuples.of((Object)((Tuple2)nested.getT1()).getT1(), (Object)((Tuple2)nested.getT1()).getT2(), (Object)nested.getT2())).collectList().flatMapMany(entitiesToBeSaved -> Mono.defer(() -> {
            List boundedEntityList = entitiesToBeSaved.stream().map(t -> t.getT3()).map(binderFunction).collect(Collectors.toList());
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).bind(boundedEntityList).to("__entities__")).fetchAs(Tuple2.class).mappedBy((t, r) -> Tuples.of((Object)r.get("__id__"), (Object)r.get("__internalNeo4jId__").asLong())).all().collectMap(m -> (Value)m.getT1(), m -> (Long)m.getT2());
        }).flatMapMany(idToInternalIdMapping -> Flux.fromIterable((Iterable)entitiesToBeSaved).flatMap(t -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(t.getT3());
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            Object id = this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty));
            Long internalId = (Long)idToInternalIdMapping.get(id);
            return this.processRelations(entityMetaData, propertyAccessor, (Boolean)t.getT2(), new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext, t.getT1(), internalId), TemplateSupport.computeIncludePropertyPredicate(includedProperties, entityMetaData));
        })));
    }

    @Override
    public <T> Mono<Void> deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return Mono.defer(() -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"The given id must not be null!");
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return Mono.defer(() -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        return Mono.defer(() -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).bindAll(parameters)).fetch().one().switchIfEmpty(Mono.defer(() -> {
            if (entityMetaData.hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }))).then(this.deleteById(id, domainType));
    }

    @Override
    public Mono<Void> deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        return Mono.defer(() -> this.neo4jClient.query(() -> renderer.render(statement)).run().then());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, null, statement, Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, String cypherQuery) {
        return this.createExecutableQuery(domainType, null, cypherQuery, Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, resultType, renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, @Nullable String cypherQuery, Map<String, Object> parameters) {
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction = TemplateSupport.getAndDecorateMappingFunction(this.neo4jMappingContext, domainType, resultType);
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherQuery).withParameters(parameters).usingMappingFunction(mappingFunction).build();
        return this.toExecutableQuery(preparedQuery);
    }

    /*
     * Unable to fully structure code
     */
    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        queryFragments = queryFragmentsAndParameters.getQueryFragments();
        if (entityMetaData == null) ** GOTO lbl-1000
        if (entityMetaData.containsPossibleCircles((Predicate<PropertyFilter.RelaxedPropertyPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(org.springframework.data.neo4j.core.mapping.PropertyFilter$RelaxedPropertyPath ), (Lorg/springframework/data/neo4j/core/mapping/PropertyFilter$RelaxedPropertyPath;)Z)((QueryFragments)queryFragments))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = containsPossibleCircles = false;
        }
        if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
            return this.createNodesAndRelationshipsByIdStatementProvider(entityMetaData, queryFragments, queryFragmentsAndParameters.getParameters()).flatMap((Function<TemplateSupport.NodesAndRelationshipsByIdStatementProvider, Mono>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createExecutableQuery$43(java.lang.Class java.lang.Class org.springframework.data.neo4j.core.TemplateSupport$NodesAndRelationshipsByIdStatementProvider ), (Lorg/springframework/data/neo4j/core/TemplateSupport$NodesAndRelationshipsByIdStatementProvider;)Lreactor/core/publisher/Mono;)((ReactiveNeo4jTemplate)this, domainType, resultType));
        }
        return this.createExecutableQuery(domainType, resultType, queryFragments.toStatement(), queryFragmentsAndParameters.getParameters());
    }

    private Mono<TemplateSupport.NodesAndRelationshipsByIdStatementProvider> createNodesAndRelationshipsByIdStatementProvider(Neo4jPersistentEntity<?> entityMetaData, QueryFragments queryFragments, Map<String, Object> parameters) {
        return Mono.deferContextual(ctx -> {
            Class rootClass = entityMetaData.getUnderlyingClass();
            Set rootNodeIds = (Set)ctx.get((Object)"rootNodes");
            Set processedRelationshipIds = (Set)ctx.get((Object)"processedRelationships");
            Set processedNodeIds = (Set)ctx.get((Object)"processedNodes");
            return Flux.fromIterable((Iterable)entityMetaData.getRelationshipsInHierarchy(fieldName -> queryFragments.includeField((PropertyFilter.RelaxedPropertyPath)fieldName))).flatMap(relationshipDescription -> {
                Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, (RelationshipDescription)relationshipDescription, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(this.cypherGenerator.createReturnStatementForMatch(entityMetaData)).build();
                HashMap<String, Object> usedParameters = new HashMap<String, Object>(parameters);
                usedParameters.putAll(statement.getParameters());
                return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).bindAll(usedParameters)).fetch().one().map(record -> {
                    List rootIds = (List)record.get("__sn__");
                    List newRelationshipIds = (List)record.get("__sr__");
                    List newRelatedNodeIds = (List)record.get("__srn__");
                    rootNodeIds.addAll(rootIds);
                    return Tuples.of((Object)newRelationshipIds, (Object)newRelatedNodeIds);
                }).expand(this.iterateAndMapNextLevel((RelationshipDescription)relationshipDescription, queryFragments, rootClass, PropertyPathWalkStep.empty()));
            }).then(Mono.fromSupplier(() -> new TemplateSupport.NodesAndRelationshipsByIdStatementProvider(rootNodeIds, processedRelationshipIds, processedNodeIds, queryFragments)));
        }).contextWrite(ctx -> ctx.put((Object)"rootNodes", ConcurrentHashMap.newKeySet()).put((Object)"processedNodes", ConcurrentHashMap.newKeySet()).put((Object)"processedRelationships", ConcurrentHashMap.newKeySet()));
    }

    private Flux<Tuple2<Collection<Long>, Collection<Long>>> iterateNextLevel(Collection<Long> relatedNodeIds, RelationshipDescription sourceRelationshipDescription, QueryFragments queryFragments, Class<?> rootClass, PropertyPathWalkStep currentPathStep) {
        NodeDescription<?> target = sourceRelationshipDescription.getTarget();
        String fieldName = ((Neo4jPersistentProperty)((Association)sourceRelationshipDescription).getInverse()).getFieldName();
        PropertyPathWalkStep nextPathStep = currentPathStep.with(sourceRelationshipDescription.hasRelationshipProperties() ? fieldName + "." + ((Neo4jPersistentProperty)((Neo4jPersistentEntity)sourceRelationshipDescription.getRelationshipPropertiesEntity()).getPersistentProperty(TargetNode.class)).getFieldName() : fieldName);
        return Flux.fromIterable(target.getRelationshipsInHierarchy(relaxedPropertyPath -> {
            PropertyFilter.RelaxedPropertyPath prepend = relaxedPropertyPath.prepend(nextPathStep.path);
            prepend = PropertyFilter.RelaxedPropertyPath.withRootType(rootClass).append(prepend.toDotPath());
            return queryFragments.includeField(prepend);
        })).flatMap(relDe -> {
            Node node = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
            Statement statement = this.cypherGenerator.prepareMatchOf(target, (RelationshipDescription)relDe, null, Functions.id((Node)node).in((Expression)Cypher.parameter((String)"__id__"))).returning(this.cypherGenerator.createGenericReturnStatement()).build();
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).bindAll(Collections.singletonMap("__id__", relatedNodeIds))).fetch().one().map(record -> {
                List newRelationshipIds = (List)record.get("__sr__");
                List newRelatedNodeIds = (List)record.get("__srn__");
                return Tuples.of((Object)newRelationshipIds, (Object)newRelatedNodeIds);
            }).expand(object -> this.iterateAndMapNextLevel((RelationshipDescription)relDe, queryFragments, rootClass, nextPathStep).apply((Tuple2<Collection<Long>, Collection<Long>>)object));
        });
    }

    @NonNull
    private Function<Tuple2<Collection<Long>, Collection<Long>>, Publisher<Tuple2<Collection<Long>, Collection<Long>>>> iterateAndMapNextLevel(RelationshipDescription relationshipDescription, QueryFragments queryFragments, Class<?> rootClass, PropertyPathWalkStep currentPathStep) {
        return newRelationshipAndRelatedNodeIds -> Flux.deferContextual(ctx -> {
            Set relationshipIds = (Set)ctx.get((Object)"processedRelationships");
            Set processedNodeIds = (Set)ctx.get((Object)"processedNodes");
            Collection newRelationshipIds = (Collection)newRelationshipAndRelatedNodeIds.getT1();
            ConcurrentHashMap.KeySetView tmpProcessedRels = ConcurrentHashMap.newKeySet(newRelationshipIds.size());
            tmpProcessedRels.addAll(newRelationshipIds);
            tmpProcessedRels.removeAll(relationshipIds);
            relationshipIds.addAll(newRelationshipIds);
            Collection newRelatedNodeIds = (Collection)newRelationshipAndRelatedNodeIds.getT2();
            ConcurrentHashMap.KeySetView tmpProcessedNodes = ConcurrentHashMap.newKeySet(newRelatedNodeIds.size());
            tmpProcessedNodes.addAll(newRelatedNodeIds);
            tmpProcessedNodes.removeAll(processedNodeIds);
            processedNodeIds.addAll(newRelatedNodeIds);
            if (tmpProcessedRels.isEmpty() && tmpProcessedNodes.isEmpty()) {
                return Mono.empty();
            }
            return this.iterateNextLevel(newRelatedNodeIds, relationshipDescription, queryFragments, rootClass, currentPathStep);
        });
    }

    private <T> Mono<T> processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, PersistentPropertyAccessor<?> parentPropertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty) {
        PropertyFilter.RelaxedPropertyPath startingPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(neo4jPersistentEntity.getUnderlyingClass());
        return this.processNestedRelations(neo4jPersistentEntity, parentPropertyAccessor, isParentObjectNew, stateMachine, includeProperty, startingPropertyPath);
    }

    private <T> Mono<T> processNestedRelations(Neo4jPersistentEntity<?> sourceEntity, PersistentPropertyAccessor<?> parentPropertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath previousPath) {
        Object fromId = parentPropertyAccessor.getProperty(sourceEntity.getRequiredIdProperty());
        ArrayList relationshipDeleteMonos = new ArrayList();
        ArrayList relationshipCreationCreations = new ArrayList();
        sourceEntity.doWithAssociations(association -> {
            Neo4jPersistentProperty idProperty;
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, parentPropertyAccessor, sourceEntity);
            if (relationshipContext.isReadOnly()) {
                return;
            }
            Object rawValue = relationshipContext.getValue();
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), rawValue);
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            PropertyFilter.RelaxedPropertyPath currentPropertyPath = previousPath.append(relationshipDescription.getFieldName());
            boolean dynamicRelationship = relationshipDescription.isDynamic();
            if (!(includeProperty.isNotFiltering() || dynamicRelationship || includeProperty.contains(currentPropertyPath))) {
                return;
            }
            if (!relationshipDescription.hasInternalIdProperty()) {
                idProperty = null;
            } else {
                Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                idProperty = (Neo4jPersistentProperty)relationshipPropertiesEntity.getIdProperty();
            }
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(fromId, relationshipDescription, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS || processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_BOTH) {
                return;
            }
            if (!isParentObjectNew && !stateMachine.hasProcessedRelationship(fromId, relationshipDescription)) {
                ArrayList<Long> knownRelationshipsIds = new ArrayList<Long>();
                if (idProperty != null) {
                    for (Object relatedValueToStore2 : relatedValuesToStore) {
                        Long id;
                        if (relatedValueToStore2 == null || (id = (Long)relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore2).getProperty((PersistentProperty)idProperty)) == null) continue;
                        knownRelationshipsIds.add(id);
                    }
                }
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(sourceEntity, relationshipDescription);
                relationshipDeleteMonos.add(((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(relationshipRemoveQuery)).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getIdProperty(), fromId)).to("fromId")).bind(knownRelationshipsIds).to("__knownRelationShipIds__")).run().checkpoint("delete relationships").then());
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            Neo4jPersistentProperty relationshipProperty = (Neo4jPersistentProperty)association.getInverse();
            stateMachine.markRelationshipAsProcessed(fromId, relationshipDescription);
            Flux relationshipCreation = Flux.fromIterable(relatedValuesToStore).concatMap(relatedValueToStore -> {
                Object relatedObjectBeforeCallbacksApplied = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                return Mono.deferContextual(ctx -> (stateMachine.hasProcessedValue(relatedObjectBeforeCallbacksApplied) ? Mono.just((Object)stateMachine.getProcessedAs(relatedObjectBeforeCallbacksApplied)) : this.eventSupport.maybeCallBeforeBind(relatedObjectBeforeCallbacksApplied)).flatMap(newRelatedObject -> {
                    Mono queryOrSave;
                    Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(relatedObjectBeforeCallbacksApplied.getClass());
                    if (stateMachine.hasProcessedValue(relatedValueToStore)) {
                        AtomicReference<Long> relatedInternalId = new AtomicReference<Long>();
                        Long possibleValue = stateMachine.getInternalId(relatedValueToStore);
                        if (possibleValue != null) {
                            relatedInternalId.set(possibleValue);
                        }
                        queryOrSave = Mono.just((Object)Tuples.of(relatedInternalId, new AtomicReference()));
                    } else {
                        queryOrSave = this.saveRelatedNode(newRelatedObject, targetEntity, includeProperty, currentPropertyPath).doOnNext(entity -> {
                            stateMachine.markValueAsProcessed(relatedValueToStore, entity.id());
                            if (relatedValueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder) {
                                Object value = ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValueToStore).getRelatedEntity();
                                stateMachine.markValueAsProcessedAs(value, entity.id());
                            }
                        }).map(entity -> Tuples.of(new AtomicReference<Long>(entity.id()), new AtomicReference<Entity>((Entity)entity)));
                    }
                    return queryOrSave.flatMap(idAndEntity -> {
                        Long relatedInternalId = (Long)((AtomicReference)idAndEntity.getT1()).get();
                        Entity savedEntity = (Entity)((AtomicReference)idAndEntity.getT2()).get();
                        Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)targetEntity.getRequiredIdProperty();
                        PersistentPropertyAccessor targetPropertyAccessor = targetEntity.getPropertyAccessor(newRelatedObject);
                        Object actualRelatedId = targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
                        if (targetEntity.isUsingInternalIds()) {
                            if (relatedInternalId == null && actualRelatedId != null) {
                                relatedInternalId = (Long)targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
                            } else if (actualRelatedId == null) {
                                targetPropertyAccessor.setProperty((PersistentProperty)requiredIdProperty, (Object)relatedInternalId);
                            }
                        }
                        if (savedEntity != null) {
                            TemplateSupport.updateVersionPropertyIfPossible(targetEntity, targetPropertyAccessor, savedEntity);
                        }
                        stateMachine.markValueAsProcessedAs(relatedObjectBeforeCallbacksApplied, targetPropertyAccessor.getBean());
                        stateMachine.markRelationshipAsProcessed(actualRelatedId == null ? relatedInternalId : actualRelatedId, relationshipDescription.getRelationshipObverse());
                        Object idValue = idProperty != null ? relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty) : null;
                        boolean isNewRelationship = idValue == null;
                        CreateRelationshipStatementHolder statementHolder = this.neo4jMappingContext.createStatement(sourceEntity, relationshipContext, relatedValueToStore, isNewRelationship);
                        return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statementHolder.getStatement())).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder.getProperties())).fetchAs(Long.class).one().flatMap(relationshipInternalId -> {
                            if (idProperty != null && isNewRelationship) {
                                relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).setProperty((PersistentProperty)idProperty, relationshipInternalId);
                            }
                            Mono nestedRelationshipsSignal = null;
                            if (processState != NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) {
                                nestedRelationshipsSignal = this.processNestedRelations(targetEntity, targetPropertyAccessor, targetEntity.isNew(newRelatedObject), stateMachine, dynamicRelationship ? PropertyFilter.acceptAll() : includeProperty, currentPropertyPath);
                            }
                            Mono getRelationshipOrRelationshipPropertiesObject = Mono.fromSupplier(() -> MappingSupport.getRelationshipOrRelationshipPropertiesObject(this.neo4jMappingContext, relationshipDescription.hasRelationshipProperties(), relationshipProperty.isDynamicAssociation(), relatedValueToStore, targetPropertyAccessor));
                            return nestedRelationshipsSignal == null ? getRelationshipOrRelationshipPropertiesObject : nestedRelationshipsSignal.then(getRelationshipOrRelationshipPropertiesObject);
                        });
                    }).doOnNext(potentiallyRecreatedRelatedObject -> {
                        RelationshipHandler handler = (RelationshipHandler)ctx.get((Object)CONTEXT_RELATIONSHIP_HANDLER);
                        handler.handle(relatedValueToStore, relatedObjectBeforeCallbacksApplied, potentiallyRecreatedRelatedObject);
                    });
                }).then(Mono.fromSupplier(() -> (RelationshipHandler)ctx.get((Object)CONTEXT_RELATIONSHIP_HANDLER))));
            }).contextWrite(ctx -> {
                RelationshipHandler relationshipHandler = RelationshipHandler.forProperty(relationshipProperty, rawValue);
                return ctx.put((Object)CONTEXT_RELATIONSHIP_HANDLER, (Object)relationshipHandler);
            });
            relationshipCreationCreations.add(relationshipCreation);
        });
        return Flux.concat(relationshipDeleteMonos).thenMany((Publisher)Flux.concat(relationshipCreationCreations)).doOnNext(objects -> objects.applyFinalResultToOwner(parentPropertyAccessor)).checkpoint().then(Mono.fromSupplier(() -> parentPropertyAccessor.getBean()));
    }

    private <Y> Mono<Entity> saveRelatedNode(Object relatedNode, Neo4jPersistentEntity<?> targetNodeDescription, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath currentPropertyPath) {
        return this.determineDynamicLabels(relatedNode, targetNodeDescription).flatMap(t -> {
            Object entity = t.getT1();
            Class entityType = targetNodeDescription.getType();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType);
            binderFunction = binderFunction.andThen(tree -> {
                Map properties = (Map)tree.get("__properties__");
                if (!includeProperty.isNotFiltering()) {
                    properties.entrySet().removeIf(e -> !includeProperty.contains(currentPropertyPath.append((String)e.getKey())));
                }
                return tree;
            });
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).bind(entity).with(binderFunction)).fetchAs(Entity.class).one();
        }).switchIfEmpty(Mono.defer(() -> {
            if (targetNodeDescription.hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }));
    }

    @Override
    public <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return Mono.defer(() -> this.lambda$toExecutableQuery$78(preparedQuery));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = ReactiveEventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
        SpelAwareProxyProjectionFactory spelAwareProxyProjectionFactory = new SpelAwareProxyProjectionFactory();
        spelAwareProxyProjectionFactory.setBeanClassLoader(this.beanClassLoader);
        spelAwareProxyProjectionFactory.setBeanFactory(beanFactory);
        this.projectionFactory = spelAwareProxyProjectionFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = this.beanClassLoader == null ? ClassUtils.getDefaultClassLoader() : this.beanClassLoader;
    }

    @Override
    public <T> ReactiveFluentSaveOperation.ExecutableSave<T> save(Class<T> domainType) {
        return new ReactiveFluentOperationSupport(this).save(domainType);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Mono lambda$toExecutableQuery$78(PreparedQuery preparedQuery) {
        resultType = preparedQuery.getResultType();
        queryFragmentsAndParameters = preparedQuery.getQueryFragmentsAndParameters();
        cypherQuery = queryFragmentsAndParameters.getCypherQuery();
        finalParameters = queryFragmentsAndParameters.getParameters();
        queryFragments = queryFragmentsAndParameters.getQueryFragments();
        entityMetaData = (Neo4jPersistentEntity)queryFragmentsAndParameters.getNodeDescription();
        if (entityMetaData == null) ** GOTO lbl-1000
        if (entityMetaData.containsPossibleCircles((Predicate<PropertyFilter.RelaxedPropertyPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(org.springframework.data.neo4j.core.mapping.PropertyFilter$RelaxedPropertyPath ), (Lorg/springframework/data/neo4j/core/mapping/PropertyFilter$RelaxedPropertyPath;)Z)((QueryFragments)queryFragments))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = containsPossibleCircles = false;
        }
        if (cypherQuery == null || containsPossibleCircles) {
            if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
                return this.createNodesAndRelationshipsByIdStatementProvider(entityMetaData, queryFragments, finalParameters).map((Function<TemplateSupport.NodesAndRelationshipsByIdStatementProvider, DefaultReactiveExecutableQuery>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$76(java.lang.Class org.springframework.data.neo4j.core.PreparedQuery org.springframework.data.neo4j.core.TemplateSupport$NodesAndRelationshipsByIdStatementProvider ), (Lorg/springframework/data/neo4j/core/TemplateSupport$NodesAndRelationshipsByIdStatementProvider;)Lorg/springframework/data/neo4j/core/ReactiveNeo4jTemplate$DefaultReactiveExecutableQuery;)((ReactiveNeo4jTemplate)this, resultType, (PreparedQuery)preparedQuery));
            }
            statement = queryFragments.toStatement();
            cypherQuery = ReactiveNeo4jTemplate.renderer.render(statement);
            finalParameters = TemplateSupport.mergeParameters(statement, finalParameters);
        }
        mappingSpec = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(cypherQuery).bindAll(finalParameters)).fetchAs(resultType);
        fetchSpec = preparedQuery.getOptionalMappingFunction().map((Function<BiFunction, ReactiveNeo4jClient.RecordFetchSpec>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$77(org.springframework.data.neo4j.core.ReactiveNeo4jClient$MappingSpec java.util.function.BiFunction ), (Ljava/util/function/BiFunction;)Lorg/springframework/data/neo4j/core/ReactiveNeo4jClient$RecordFetchSpec;)(mappingSpec)).orElse(mappingSpec);
        return Mono.just(new DefaultReactiveExecutableQuery<T>(preparedQuery, fetchSpec));
    }

    private static /* synthetic */ ReactiveNeo4jClient.RecordFetchSpec lambda$null$77(ReactiveNeo4jClient.MappingSpec mappingSpec, BiFunction mappingFunction) {
        return mappingSpec.mappedBy(mappingFunction);
    }

    private /* synthetic */ DefaultReactiveExecutableQuery lambda$null$76(Class resultType, PreparedQuery preparedQuery, TemplateSupport.NodesAndRelationshipsByIdStatementProvider nodesAndRelationshipsById) {
        ReactiveNeo4jClient.MappingSpec mappingSpec = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(nodesAndRelationshipsById.toStatement())).bindAll(nodesAndRelationshipsById.getParameters())).fetchAs(resultType);
        ReactiveNeo4jClient.RecordFetchSpec fetchSpec = preparedQuery.getOptionalMappingFunction().map(mappingFunction -> mappingSpec.mappedBy(mappingFunction)).orElse(mappingSpec);
        return new DefaultReactiveExecutableQuery(preparedQuery, fetchSpec);
    }

    private /* synthetic */ Mono lambda$createExecutableQuery$43(Class domainType, Class resultType, TemplateSupport.NodesAndRelationshipsByIdStatementProvider finalQueryAndParameters) {
        return this.createExecutableQuery(domainType, resultType, renderer.render(finalQueryAndParameters.toStatement()), finalQueryAndParameters.getParameters());
    }

    final class DefaultReactiveExecutableQuery<T>
    implements ReactiveNeo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;
        private final ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec;

        DefaultReactiveExecutableQuery(PreparedQuery<T> preparedQuery, ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec) {
            this.preparedQuery = preparedQuery;
            this.fetchSpec = fetchSpec;
        }

        @Override
        public Flux<T> getResults() {
            return this.fetchSpec.all().switchOnFirst((signal, f) -> {
                if (signal.hasValue() && this.preparedQuery.resultsHaveBeenAggregated()) {
                    return f.flatMap(nested -> Flux.fromIterable((Iterable)((Collection)nested)).distinct()).distinct();
                }
                return f;
            });
        }

        @Override
        public Mono<T> getSingleResult() {
            return this.fetchSpec.one().map(t -> {
                if (t instanceof LinkedHashSet) {
                    return ((LinkedHashSet)t).iterator().next();
                }
                return t;
            }).onErrorMap(IndexOutOfBoundsException.class, e -> new IncorrectResultSizeDataAccessException(e.getMessage(), 1));
        }
    }
}

